/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.sal.api.user.UserManager;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.utility.MoEncryptionUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class MoVerifyLicenseFile
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoVerifyLicenseFile.class);
    private static final String PUBLIC_CERT_PATH = "/certificates/com/miniorange/twofactor/crowd/publicKey.crt";
    private String configuredKey;
    private UploadedFile licenseFile;
    private Boolean isError = Boolean.FALSE;
    private String errorMessage;
    private final UserManager userManager;
    private final CrowdLicenseManager crowdLicenseManager;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;

    public MoVerifyLicenseFile(UserManager userManager, CrowdLicenseManager crowdLicenseManager, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.userManager = userManager;
        this.crowdLicenseManager = crowdLicenseManager;
        this.pluginSettings = pluginSettings;
        this.pluginConfiguration = pluginConfiguration;
    }

    public void doValidate() {
        this.isError = false;
        if (this.licenseFile == null) {
            this.errorMessage = "File not found";
            this.isError = true;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Do Post called:");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            if (Boolean.parseBoolean(request.getParameter("submitted"))) {
                String licenseKey = this.handleUpload();
                LOGGER.info("LicenseKey:" + licenseKey);
                if (licenseKey != null && this.isLicenseValid(licenseKey)) {
                    response.sendRedirect(this.pluginConfiguration.getConfigureActionUrl());
                    return;
                }
                LOGGER.debug("Invalid License");
                if (StringUtils.isBlank((CharSequence)this.errorMessage)) {
                    this.errorMessage = "Invalid_License!";
                }
            }
            response.sendRedirect(this.pluginConfiguration.getLoginActionUrl() + "?errorMessage=" + this.errorMessage);
        } else {
            this.errorMessage = "Admin_Access_required";
            response.sendRedirect(this.pluginSettings.getBaseUrl());
        }
    }

    private boolean isLicenseValid(String token) {
        try {
            this.configuredKey = IOUtils.toString(MoVerifyLicenseFile.class.getResourceAsStream(PUBLIC_CERT_PATH), "UTF-8");
            String serverId = "";
            if (this.crowdLicenseManager.getLicense() != null && this.crowdLicenseManager.getLicense().getServerId() != null) {
                serverId = this.crowdLicenseManager.getLicense().getServerId().trim();
                LOGGER.info("instance's serverID: " + serverId);
            }
            URL domainURL = new URL(this.pluginSettings.getBaseUrl());
            String domainName = "";
            if (domainURL != null) {
                domainName = domainURL.getAuthority().trim();
            }
            LOGGER.info("instance's domainName: " + domainName);
            token = MoEncryptionUtils.decrypt("u4JpSz2dti6u5kRB", token);
            LOGGER.debug("Token value after enc=" + token);
            RSAPublicKey publicKey = this.getPublicKey();
            Algorithm algorithm = Algorithm.RSA256(publicKey, null);
            JWTVerifier verifier = JWT.require(algorithm).withIssuer("miniOrange").build();
            DecodedJWT jwt = verifier.verify(token);
            if (!jwt.getClaims().get("pluginName").asString().equals("2FA")) {
                this.errorMessage = "Invalid_License";
                LOGGER.error("Invalid license. Plugin Name in the license does not match with the addon");
                return false;
            }
            if (this.pluginSettings.isLicenseExpired(jwt.getClaims().get("ExpiryDate").asString()).booleanValue()) {
                this.errorMessage = "Expired_License";
                LOGGER.error("License is expired");
                return false;
            }
            LOGGER.info("Licensed Domain = " + jwt.getClaims().get("domainName").asString().trim());
            LOGGER.info("Licensed serverID = " + jwt.getClaims().get("serverID").asString().trim());
            if (jwt.getClaims().get("serverID").asString().trim().equals(serverId) || jwt.getClaims().get("domainName").asString().trim().contains(domainName)) {
                return this.saveLicenseDetails(jwt.getClaims());
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying license:" + e);
        }
        return false;
    }

    private boolean saveLicenseDetails(Map<String, Claim> claims) {
        try {
            LOGGER.debug("Saving license details");
            this.pluginSettings.setCustomerAPIKey(claims.get("customerKey").asString());
            this.pluginSettings.setCustomerEmail(claims.get("customerEmail").asString());
            this.pluginSettings.setCustomerId(claims.get("customerId").asString());
            this.pluginSettings.setCustomerTokenKey(claims.get("customerToken").asString());
            this.pluginSettings.setLicenseVerified(Boolean.TRUE);
            this.pluginSettings.setLicenseType(claims.get("licenseType").asString());
            this.pluginSettings.setLicencedUsers(Integer.valueOf(claims.get("userTier").asString()));
            this.pluginSettings.setLicenseExpireDate(claims.get("ExpiryDate").asString());
            if (!this.pluginSettings.getLicenseVerified().booleanValue()) {
                this.errorMessage = "Invalid_Customer_Token_Key";
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Invalid License Details", e);
            this.errorMessage = "Invalid_License";
            e.printStackTrace();
            return false;
        }
    }

    private RSAPublicKey getPublicKey() {
        String publicKey = this.configuredKey.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        byte[] publicBytes = Base64.decodeBase64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while getting public key", e);
            return null;
        }
    }

    private String handleUpload() throws IOException {
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        this.licenseFile = wrapper.getFiles("licenseFile")[0];
        this.doValidate();
        if (!this.isError.booleanValue()) {
            return FileUtils.readFileToString((File)this.licenseFile.getContent());
        }
        return null;
    }
}

