/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.miniorange.twofactor.common.MoTwoFactorPluginException;
import com.miniorange.twofactor.crowd.Customer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.opensymphony.xwork2.Validateable;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorCustomerLoginAction
extends BaseAction
implements Validateable {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorCustomerLoginAction.class);
    private Boolean submitted;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private String email;
    private String password;
    private I18nHelper i18nHelper;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;

    public MoTwoFactorCustomerLoginAction(UserManager userManager, LoginUriProvider loginUriProvider, I18nHelper i18nHelper, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.i18nHelper = i18nHelper;
        this.pluginSettings = pluginSettings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
    }

    public void validate() {
        LOGGER.info("Register Action validate");
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.email)) {
            this.addActionError(this.i18nHelper.getText("2fa.error.register.email.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.password)) {
            this.addActionError(this.i18nHelper.getText("2fa.error.register.password.empty"));
        }
    }

    public String execute() throws Exception {
        LOGGER.info("Login action execute submitted");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("customer is registered, redirecting to the configure action");
                return "redirect";
            }
            if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                this.validate();
                try {
                    try {
                        Customer customer = this.pluginHandler.fetchCustomer(this.email, this.password);
                        this.pluginSettings.setCustomerId(customer.getCustomerId().toString());
                        this.pluginSettings.setCustomerEmail(customer.getEmail());
                        this.pluginSettings.setCustomerAPIKey(customer.getApiKey());
                        this.pluginSettings.setCustomerTokenKey(customer.getTokenKey());
                        this.initializeConfig();
                        return "verify";
                    }
                    catch (MoTwoFactorPluginException e) {
                        this.addActionError("Invalid username and password.");
                        return "input";
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while verifying account details", e);
                    this.addActionError("An unknown error occurred. Please check logs and contact us at support-atlassian@miniorange.atlassian.net.");
                    return "error";
                }
            }
            return "input";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }
}

