/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import java.util.List;

public class MembershipCache {
    private final CacheManager cacheManager;
    private final String cacheName;

    public MembershipCache(CacheManager cacheManager, String cacheName) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
    }

    private Cache getCache() {
        return this.cacheManager.getCache(this.cacheName);
    }

    protected String getMembershipKey(String username, Group group) {
        return username + "_" + group.getName();
    }

    public void put(User user, Group group, boolean isMember) {
        this.getCache().put(this.getMembershipKey(user.getName(), group), isMember);
    }

    public Boolean get(User user, Group group) {
        return (Boolean)this.getCache().get(this.getMembershipKey(user.getName(), group));
    }

    public void remove(User user, Group group) {
        this.getCache().remove(this.getMembershipKey(user.getName(), group));
    }

    public void remove(List usernames, Group group) {
        for (String username : usernames) {
            this.getCache().remove(this.getMembershipKey(username, group));
        }
    }
}

