<html>
    <head>
        <title>Audit Logs</title>
        <meta name="decorator" content="atl.general">
        <script>
            AJS.$(document).ready(function() {
                 AJS.$(".aui-nav li").removeClass("aui-nav-selected");
                 AJS.$("#AUDITLOGS").addClass("aui-nav-selected");
                 AJS.$('input').css("box-shadow","none");
            });

            function changeAuditIndex(index){
              document.getElementById("currentIndex").value = index;
              AJS.$("#auditlog-user-form").submit();
            }
            function DisplayFilterSpecificLogs(){
                var action = document.getElementById("filterUsersByAction");
                var ip = document.getElementById("auditLogIpSearchKeyword");
                var username = document.getElementById("auditLogUsernameSearchKeyword");
                var period = document.getElementById("filterUsersByPeriod");
                if(action.value =="" && period.value =="" && username.value =="" && ip.value ==""){
                    document.getElementById("filterUsersByAction").style.borderColor = "red";
                    document.getElementById("auditLogIpSearchKeyword").style.borderColor = "red";
                    document.getElementById("auditLogUsernameSearchKeyword").style.borderColor = "red";
                    document.getElementById("filterUsersByPeriod").style.borderColor = "red";
                    alert("Please select a valid Filter");
                }
            }
            function resetAuditLogsFilters() {
                AJS.$("#auditLogUsernameSearchKeyword").val("");
                AJS.$("#auditLogIpSearchKeyword").val("");
                AJS.$("#filterUsersByAction").val("All Actions");
                AJS.$("#filterUsersByPeriod").val("All Days");
            }
            function exportLogs() {
                var username = document.getElementById("auditLogUsernameSearchKeyword").value;
                var ip = document.getElementById("auditLogIpSearchKeyword").value;
                var action = document.getElementById("filterUsersByAction").value;
                var period = document.getElementById("filterUsersByPeriod").value;

                window.location.href = document.getElementById("exportAuditLogsUrlId").value+"?user_name="+username+"&ip_="+ip+"&action_="+action+"&period_="+period;
            }
            AJS.$(document).on('click','#autoDeleteAuditLogs',function() {
                if(this.checked) {
                    AJS.$("#autoDeleteLogsAfterDays").prop('disabled', false);
                    AJS.$("#nextdeletionscheduler").prop('disabled', false);
                } else {
                    AJS.$("#autoDeleteLogsAfterDays").prop('disabled', true);
                    AJS.$("#nextdeletionscheduler").prop('disabled', true);
                }
            });
            function openCloseElemenet(elementId){
                document.getElementById(elementId).classList.toggle("showElement");
            }
        </script>
        <style type="text/css">

        h4 {
                display: block;
                margin: 30px 65px 0px;
                font-weight: bold;
            }

            .aui-page-panel-content{
                padding: 0px !important;
            }

            .aui-page-panel{
                margin: 0px !important;
                border: 0px solid #dfe1e6;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }

            .mo-loading {
                background-image: url(/s/en_US/61008/1/3.0.4/_/download/resources/com.atlassian.upm.atlassian-universal-plugin-manager-plugin:upm-web-resources/images/throbber.gif);
                background-repeat: no-repeat;
                min-height: 30px;
            }
            .hideElement{
                 overflow: hidden;
                 text-overflow: ellipsis;
                 word-break:initial;
                 cursor: pointer;
            }
            .showElement{
                 overflow: initial;
                 text-overflow: ellipsis;
                 word-break:break-all;
                 cursor: pointer;
            }

        </style>
    </head>
    <body>
            <#include "*/header.ftl" parse=true>
            <div class="tabs-pane active-pane" id="auditlogs" role="tabpanel" >
                    <#if pageAccessType.equals("read")>
                        <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                            <p class="title">
                                <strong>Warning!</strong>
                            </p>
                            <p>You only have read access of this page, no configuration will be saved!</p>
                        </div>
                    </#if>
                    <h2>Audit Logs</h2>
                    <hr class="header"/>
                    <div>
                        <#if pageAccessType != "" && pageAccessType == "readwrite">
                        <form id="autoDeletion_form" class="aui long-label" action="" method="POST">
                            <input type="hidden" name="autoDeleteAuditLogsSubmitted" value="true"/>
                            <div class ="field-group">
                                <label for="autoDeleteAuditLogs">Auto Delete Audit Logs : </label>
                                <#if autoDeleteAuditLogs == true>
                                    <input type="checkbox" style="margin-top:11px;" id="autoDeleteAuditLogs" value="true" name="autoDeleteAuditLogs" checked="true"/>
                                <#else>
                                    <input type="checkbox" style="margin-top:11px;" id="autoDeleteAuditLogs" value="true" name="autoDeleteAuditLogs"/>
                                </#if>
                                <br>
                                <br>

                                <label for="autoDeleteLogsAfterDays">Enter days : </label>
                                <#if autoDeleteAuditLogs == true>
                                    <input type="number"  id="autoDeleteLogsAfterDays" name="autoDeleteLogsAfterDays" value="${autoDeleteLogsAfterDays}" class="text" style="width: 80px;" min="1" />&nbsp;
                                <#else>
                                    <input type="number"  id="autoDeleteLogsAfterDays" name="autoDeleteLogsAfterDays" value="${autoDeleteLogsAfterDays}" class="text" style="width: 80px;" min="1" disabled/>&nbsp;
                                </#if>
                                <input type='submit' value='Submit' id='perform-action-button' class="aui-button aui-button-primary"/>
                                <div class="description">Auto Delete Audit Logs will automatically delete logs after given number of days.</div>

                            </div>
                        </form>
                        </#if>
                        <form id="auditlog-user-form" class="aui long-label" action="" method="POST">
                            <input type="hidden" name="exportAuditLogsUrl" id="exportAuditLogsUrlId" value="${exportAuditLogsUrl}"/>
                            <input type="hidden" id="currentIndex"name="currentIndex" value="1">

                            <div>
                                Filter Logs :&nbsp;
                                <input type="text"  id="auditLogUsernameSearchKeyword" name="auditLogUsernameSearchKeyword" value="${auditLogUsernameSearchKeyword}" placeholder="Enter Username" class="text long-field" style="width: 155px; height: 33px;"/>&nbsp;
                                <input type="text"  id="auditLogIpSearchKeyword" name="auditLogIpSearchKeyword" value="${auditLogIpSearchKeyword}" placeholder="Enter IP Address" class="text long-field" style="width: 155px; height: 33px;"/>&nbsp;

                                <select class="select" name="filterUsersByAction" id="filterUsersByAction" class="filterUsers" style="width: 155px; height: 33px;">
                                <option value="" disabled>Select Action</option>
                                    <option value="All Actions" <#if (filterUsersByAction.equals("All Actions"))>selected="true" </#if>>All Actions</option>
                                    <option value="Login Successful" <#if (filterUsersByAction.equals("Login Successful"))>selected="true" </#if>>Login Successful</option>
                                    <option value="Login Failed" <#if (filterUsersByAction.equals("Login Failed"))>selected="true" </#if>>Login Failed</option>
                                    <option value="2FA Configuration Successful" <#if (filterUsersByAction.equals("2FA Configuration Successful"))>selected="true" </#if>>2FA Configuration Successful</option>
                                    <option value="2FA Configuration Failed" <#if (filterUsersByAction.equals("2FA Configuration Failed"))>selected="true" </#if>>2FA Configuration Failed</option>
                                    <option value="Temporarily Locked" <#if (filterUsersByAction.equals("Temporarily Locked"))>selected="true" </#if>>Temporarily Locked</option>
                                </select>&nbsp;

                                <select class="select" name="filterUsersByPeriod" id="filterUsersByPeriod" class="filterUsers" style="width: 155px; height: 33px;">
                                    <option value="" disabled>Select Log Period</option>
                                    <option value="All Days" <#if (filterUsersByPeriod.equals("All Days"))>selected="true" </#if>>All Days</option>
                                    <option value="1" <#if (filterUsersByPeriod.equals("1"))>selected="true" </#if>>Last 1 Days</option>
                                    <option value="7" <#if (filterUsersByPeriod.equals("7"))>selected="true" </#if>>Last 7 Days</option>
                                    <option value="30" <#if (filterUsersByPeriod.equals("30"))>selected="true" </#if>>Last 30 Days</option>
                                    <option value="180" <#if (filterUsersByPeriod.equals("180"))>selected="true" </#if>>Last 180 Days</option>
                                </select>&nbsp;

                                <input type='submit' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return DisplayFilterSpecificLogs()"/>
                                <input type='submit' value='Reset' id='perform-action-button' class="aui-button aui-button-primary" style="margin-left:2px" onclick="return resetAuditLogsFilters()"/>&nbsp;


                                <a class="aui-button" onclick="exportLogs()" resolved="" style="float: right;">
                                    <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export Audit Log
                                </a>
                                <hr class="header"/>
                            </div>
                                 <#if (moLogEntititesHashMap.size() > 0)>
                                    <table class="aui" style="table-layout: fixed;">
                                        <thead>
                                        <tr>
                                            <th id="number" style="width:3%;">Sr.No</th>
                                            <th id="username" style="width:20%;">Username</th>
                                            <th id="loginTimeAndDate" style="width:15%;">Date</th>
                                            <th id="ip" style="width:10%;">IP Address</th>
                                            <th id="action" style="width:15%;">Action</th>
                                            <th id="loginmethod" style="width:15%;">2FA Method </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <#assign loopCount = 1>
                                            <#foreach moLogEntitityHash in moLogEntititesHashMap>
                                                <#assign trid = "tr"+moLogEntitityHash.get("user")>
                                                <tr id="${trid}">
                                                    <td>${loopCount}</td>
                                                    <#assign tdId = "td_username_"+loopCount >
                                                    <td id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')"> ${moLogEntitityHash.get("user")}</td>

                                                    <td>${moLogEntitityHash.get("dateTime")}</td>
                                                    <td>${moLogEntitityHash.get("ipAddress")}</td>
                                                    <td>${moLogEntitityHash.get("action")}</td>
                                                    <td>${moLogEntitityHash.get("type")}</td>
                                                </tr>
                                                <#assign loopCount = loopCount + 1>
                                            </#foreach>
                                        </tbody>
                                    </table>
                                    <table style="width:100%">
                                        <tr>
                                            <td>
                                                <#assign end = start + moLogEntititesHashMap.size()>
                                                <#assign start = start + 1>
                                                <p>Displaying logs <strong>${start}</strong> to
                                                    <strong>${end}</strong>
                                                    of <strong>${totalLogs}</strong>.
                                                </p>
                                            </td>
                                            <td>
                                                <#if (lastIndex > 1 ) >
                                                    <ol class="aui-nav aui-nav-pagination" style="float:right;cursor:pointer">

                                                        <#if ( start > 20 ) >
                                                            <li class="aui-nav-first"><a onclick=changeAuditIndex("1")>First</a></li>
                                                            <li class="aui-nav-previous"><a onclick=changeAuditIndex("prevIndex")>Prev</a></li>
                                                        </#if>
                                                        <#list startIndex..endIndex as index>
                                                            <#if (index == currentIndex)>
                                                                <li><a onclick= changeAuditIndex('${index}')><strong>${index}</strong></a></li>
                                                            <#else>
                                                                <li><a onclick= changeAuditIndex('${index}')>${index}</a></li>
                                                            </#if>
                                                        </#list>
                                                        <#if (lastIndex - startIndex > 4 )>
                                                            <#assign jumpIndex = endIndex + 1>
                                                            <li class="aui-nav-truncation"><a onclick=changeAuditIndex("jumpIndex") id="pagination-truncation">&hellip;</a></li>
                                                        </#if>
                                                        <#if (end!=totalLogs)>
                                                            <li class="aui-nav-next"><a onclick=changeAuditIndex("${nextIndex}")>Next</a></li>
                                                            <li class="aui-nav-last"><a onclick=changeAuditIndex("${lastIndex}")>Last</a></li>
                                                        </#if>
                                                    </ol>
                                                </#if>
                                            </td>
                                        </tr>
                                    </table>
                                 <#else>
                                    <table class="aui" style="table-layout: fixed;">
                                        <thead>
                                        <tr>
                                            <th id="number" style="width:3%;">Sr.No</th>
                                            <th id="username">Username</th>
                                            <th id="loginTimeAndDate" style="width:15%;">Date</th>
                                            <th id="ip" style="width:10%;">IP Address</th>
                                            <th id="action" style="width:15%;">Action</th>
                                            <th id="loginmethod">2FA Method </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="6">
                                                    <p style="width:100%" align="center">
                                                        No Audit Logs found.
                                                    </p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                 </#if>
                        </form>
                    </div>

                </div>
                </div>
                </div>
                </div>
            </div>

    </body>
</html>