/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorExportGroups
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorExportGroups.class);
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private CrowdService crowdService;
    private UserManager userManager;

    public MoTwoFactorExportGroups(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, CrowdService crowdService, UserManager userManager) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.debug("MoTwoFactorExportGroups doGet called");
        List<String> pages = this.pluginHandler.getUserAccessiblePages();
        if (pages.contains("User_Management_readwrite") || pages.contains("User_Management_read")) {
            LOGGER.debug("Valid Admin user found");
            String action = request.getParameter("action");
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"AllGroups")) {
                LOGGER.debug("Exporting All Groups");
                this.exportAllGroups(request, response);
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"EnabledGroups")) {
                LOGGER.debug("Exporting Enabled Groups");
                this.exportEnabledGroups(request, response);
                return;
            }
            LOGGER.debug("Invalid Export action parameter");
        }
        LOGGER.debug("Invalid User or user is not an admin.");
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    private void exportEnabledGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportEnabledGroups called");
        List<String> enabledList = this.settings.getEnable2FAForGroupsList();
        String str = ",Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",Total 2FA Enabled Groups,: " + enabledList.size() + "\n\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Group Name");
        str = str + stringJoiner.toString() + "\n";
        int i = 0;
        for (String groupName : enabledList) {
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(groupName);
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Enabled_Groups.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    private void exportAllGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportAllGroups called");
        List<String> enabledList = this.settings.getEnable2FAForGroupsList();
        String str = ",Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",Total 2FA Enabled Groups,: " + enabledList.size() + "\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Groups Name");
        stringJoiner.add("2FA Enabled");
        str = str + stringJoiner.toString() + "\n";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        LOGGER.debug("Query for Group : " + query);
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        int i = 0;
        for (Group group : groupsFromSystem) {
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(group.getName());
            if (enabledList.contains(group.getName())) {
                stringJoiner.add("Enabled");
            } else {
                stringJoiner.add("Disabled");
            }
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_Groups.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

