/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.entity.MoLogEntity;
import com.miniorange.twofactor.crowd.service.MoLogEntityService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorExportAuditLogs
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorExportAuditLogs.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoLogEntityService service;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorExportAuditLogs(MoTwoFactorCommonPluginSettings settings, MoLogEntityService service, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        LOGGER.debug("MoTwoFactorExportAuditLogs constructor called...");
        this.settings = settings;
        this.service = service;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoTwoFactorExportAuditLogs doGet() called...");
        ArrayList filteredAuditLogsList = new ArrayList();
        String username = request.getParameter("user_name");
        String ip = request.getParameter("ip_");
        String action = request.getParameter("action_");
        String period = request.getParameter("period_");
        List<MoLogEntity> aoLogs = this.service.getLogs(0, action, period, username, ip, -1);
        for (int i = 0; i < aoLogs.size(); ++i) {
            MoLogEntity moLogEntity = aoLogs.get(i);
            if (moLogEntity == null) continue;
            HashMap<String, String> moLogEntityHash = new HashMap<String, String>();
            moLogEntityHash.put("user", moLogEntity.getUserName());
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            moLogEntityHash.put("dateTime", formatter.format(moLogEntity.getDateAndTime()));
            moLogEntityHash.put("ipAddress", moLogEntity.getIpAddress());
            moLogEntityHash.put("action", moLogEntity.getAction());
            moLogEntityHash.put("type", moLogEntity.getLoginMethod());
            filteredAuditLogsList.add(moLogEntityHash);
        }
        String str = ",,Date : " + new Date(System.currentTimeMillis()) + "\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("Sr.no");
        stringJoiner.add("Username");
        stringJoiner.add("Date");
        stringJoiner.add("IP Address");
        stringJoiner.add("Action");
        stringJoiner.add("2FA Method");
        str = str + stringJoiner.toString() + "\n";
        int listCounter = 0;
        for (int counter = 0; counter < filteredAuditLogsList.size(); ++counter) {
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++listCounter);
            stringJoiner.add(((HashMap)filteredAuditLogsList.get(counter)).get("user").toString());
            stringJoiner.add(((HashMap)filteredAuditLogsList.get(counter)).get("dateTime").toString());
            stringJoiner.add(((HashMap)filteredAuditLogsList.get(counter)).get("ipAddress").toString());
            stringJoiner.add(((HashMap)filteredAuditLogsList.get(counter)).get("action").toString());
            stringJoiner.add(((HashMap)filteredAuditLogsList.get(counter)).get("type").toString());
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_AuditLogs.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }
}

