/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.migration;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MoTwoFactorMigrationEvent
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorMigrationEvent.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorMigrationEvent(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("MoPluginMigrationEvent afterPropertiesSet Called");
        this.migrateIpAddressToIpAddressAndIpCommentsInMap();
        if (!this.settings.getCombineIpAddressAndIpMessage().booleanValue()) {
            LOGGER.debug("Migrating IP Address list to IP Address Map with IP Comments");
            this.migrateWhiteListIpAddressToIpAddressMapWithIpComments();
            this.migrateBlackListIpAddressToIpAddressMapWithIpComments();
            this.settings.setCombineIpAddressAndIpMessage(true);
        } else {
            LOGGER.debug("IP Address list is already migrated to IP Address Map with IP Comments");
        }
        if (!this.settings.getDisableUsersListMigrated().booleanValue()) {
            this.migrateDisableUsersSettings();
            this.settings.setDisableUsersListMigrated(true);
        } else {
            LOGGER.debug("Disabled users settings are already migrated");
        }
    }

    public void destroy() throws Exception {
    }

    private void migrateIpAddressToIpAddressAndIpCommentsInMap() {
        LOGGER.debug("Migrating IP Addresses with message to IP Address and message Map IP Map");
        if (!this.settings.getCombineIpAddressAndIpMessageInMapMigration().booleanValue()) {
            Map<String, String> whitelistIpAddressWithMessages = this.settings.getWhitelistIpAddressWithMessagesOld();
            Map<String, String> whitelistIpAddressAndMessagesInMap = this.settings.getWhitelistIpAddressWithMessages();
            for (Map.Entry<String, String> entry : whitelistIpAddressWithMessages.entrySet()) {
                if (whitelistIpAddressAndMessagesInMap.get(entry.getKey()) != null) continue;
                whitelistIpAddressAndMessagesInMap.put(entry.getKey(), entry.getValue());
            }
            this.settings.setWhitelistIpAddressAndMessagesInMap(whitelistIpAddressAndMessagesInMap);
            Map<String, String> blacklistIpAddressWithMessages = this.settings.getBlacklistIpAddressWithMessagesOld();
            Map<String, String> blacklistIpAddressAndMessagesInMap = this.settings.getBlacklistIpAddressWithMessages();
            for (Map.Entry<String, String> entry : blacklistIpAddressWithMessages.entrySet()) {
                if (blacklistIpAddressAndMessagesInMap.get(entry.getKey()) != null) continue;
                blacklistIpAddressAndMessagesInMap.put(entry.getKey(), entry.getValue());
            }
            this.settings.setBlacklistIpAddressAndMessagesInMap(blacklistIpAddressAndMessagesInMap);
            this.settings.setCombineIpAddressAndCommentsInMap(true);
            LOGGER.debug("Successfully Migrated IP Addresses with message to IP Address and message Map IP Map");
        }
    }

    private void migrateWhiteListIpAddressToIpAddressMapWithIpComments() {
        LOGGER.debug("Migrating WhiteList IP Addresses - Mapping IP Addresses with IP Comments");
        HashMap<String, String> listOfIpAddressesWithIpComments = new HashMap<String, String>();
        List<String> listOfIpAddresses = this.settings.getWhitelistIpAddresses();
        if (listOfIpAddresses.size() > 0) {
            for (String IpAddress : listOfIpAddresses) {
                int count = IpAddress.split("\\.").length;
                String validIpAddress = count == 1 ? IpAddress.trim() + ".*.*.*" : (count == 2 ? IpAddress.trim() + ".*.*" : (count == 3 ? IpAddress.trim() + ".*" : IpAddress));
                LOGGER.debug("Migrating IP Address = " + validIpAddress);
                listOfIpAddressesWithIpComments.put(validIpAddress, "-");
            }
            this.settings.setWhitelistIpAddressWithMessages(listOfIpAddressesWithIpComments);
            LOGGER.debug("Successfully Migrated WhiteList IP Addresses to IP Address Map with IP Comments");
        } else {
            LOGGER.error("List of IP Addresses is empty. No IP Address is whitelisted yet!");
        }
    }

    private void migrateBlackListIpAddressToIpAddressMapWithIpComments() {
        LOGGER.debug("Migrating BlackList IP Addresses - Mapping IP Addresses with IP Comments");
        HashMap<String, String> listOfIpAddressesWithIpComments = new HashMap<String, String>();
        List<String> listOfIpAddresses = this.settings.getBlacklistIpAddresses();
        if (listOfIpAddresses.size() > 0) {
            for (String IpAddress : listOfIpAddresses) {
                int count = IpAddress.split("\\.").length;
                String validIpAddress = count == 1 ? IpAddress.trim() + ".*.*.*" : (count == 2 ? IpAddress.trim() + ".*.*" : (count == 3 ? IpAddress.trim() + ".*" : IpAddress));
                LOGGER.debug("Migrating IP Address = " + validIpAddress);
                listOfIpAddressesWithIpComments.put(validIpAddress, "-");
            }
            this.settings.setBlacklistIpAddressWithMessages(listOfIpAddressesWithIpComments);
            LOGGER.debug("Successfully Migrated BlackList IP Addresses to IP Address Map with IP Comments");
        } else {
            LOGGER.error("List of IP Addresses is empty. No IP Address is blacklisted yet!");
        }
    }

    private void migrateDisableUsersSettings() {
        List<String> allUsers = this.pluginHandler.getUserFromCrowdUsingUsername("", -1);
        List<String> enabled2FAForUsersList = this.settings.getEnable2FAForUsersList();
        List disable2FAForUsersList = (List)CollectionUtils.subtract(allUsers, enabled2FAForUsersList);
        this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
        LOGGER.debug("destroy method called");
    }
}

