/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser.configuration;

import com.atlassian.user.configuration.AbstractRepositoryProcessor;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.config.xml.OSUConfigurationLoader;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.util.ClassLoaderUtils;
import java.io.InputStream;
import java.util.HashMap;

public class OSURepositoryProcessor
extends AbstractRepositoryProcessor {
    private OSUConfigurationLoader configLoader;
    private String configXMLFileName;
    private OSUAccessor accessor;

    public RepositoryAccessor process(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        this.configureOSUAccessor(components, componentClassNames);
        components.put("accessProvider", this.accessor.getAccessProvider());
        components.put("credentialsProvider", this.accessor.getCredentialsProvider());
        components.put("profileProvider", this.accessor.getProfileProvider());
        return super.process(components, componentClassNames);
    }

    protected void configureOSUAccessor(HashMap componentData, HashMap componentClassNames) throws ConfigurationException {
        InputStream is = ClassLoaderUtils.getResourceAsStream(this.configXMLFileName, this.getClass());
        if (is == null) {
            throw new ConfigurationException("Could not open InputStream on specified configuration file: [" + this.configXMLFileName + "]." + " Please ensure that the file is available on the classpath.");
        }
        this.configLoader.load(is);
        this.accessor = this.configLoader.getOSUAccessor();
        componentData.put("accessor", this.accessor);
    }

    public Authenticator configureAuthenticator(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String authenticatorClassName = (String)componentClassNames.get("authenticator");
        if (authenticatorClassName == null) {
            return null;
        }
        components.put("credentialsProviderList", this.configLoader.getCredentialProviders());
        this.authenticator = (Authenticator)this.instantiateComponent(authenticatorClassName);
        this.authenticator.init(components);
        components.put("authenticator", this.authenticator);
        return this.authenticator;
    }

    public void init(HashMap processorData, HashMap componentClassNames) {
        String configLoaderClassName = (String)componentClassNames.get("configLoader");
        this.configLoader = (OSUConfigurationLoader)this.instantiateComponent(configLoaderClassName);
        this.configLoader.init(processorData);
        processorData.put("configLoader", this.configLoader);
        this.configXMLFileName = (String)componentClassNames.get("configFile");
    }
}

