/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.ReadOnlyUserManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import java.util.HashMap;

public class MemoryUserManagerReadOnly
extends ReadOnlyUserManager
implements UserManager {
    private Repository repository;
    private MemoryProvider provider;
    private PasswordEncryptor encryptor;

    public MemoryUserManagerReadOnly() {
    }

    public MemoryUserManagerReadOnly(Repository repository, MemoryProvider provider, PasswordEncryptor passwordEncryptor) {
        this.repository = repository;
        this.provider = provider;
        this.encryptor = passwordEncryptor;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (Repository)args.get("repository");
        this.provider = (MemoryProvider)args.get("provider");
        this.encryptor = (PasswordEncryptor)args.get("passwordEncryptor");
        InitializationCheck.validateArgs(args, new String[]{"repository", "provider", "passwordEncryptor"}, this);
    }

    public User createUser(String username) throws DuplicateEntityException {
        throw new UnsupportedOperationException("This configuration cannot support write access");
    }

    public User createUser(String username, String password) throws EntityException {
        throw new UnsupportedOperationException("This configuration cannot support write access");
    }

    public void removeUser(User user) throws EntityException {
        throw new UnsupportedOperationException("This configuration cannot support write access");
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        if (this.getUser(user.getName()) != null) {
            return this.encryptor;
        }
        return null;
    }

    public Pager getUsers() {
        return this.provider.getUsers();
    }

    public Pager getUserNames() throws EntityException {
        return this.provider.getUserNames();
    }

    public User getUser(String username) {
        return this.provider.getUser(username);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }
}

