/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo.provider;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.Collection;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.criteria.KeyAlgorithmCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialContext;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.security.keyinfo.KeyInfoResolutionContext;
import org.opensaml.xml.security.keyinfo.provider.AbstractKeyInfoProvider;
import org.opensaml.xml.signature.DEREncodedKeyValue;
import org.opensaml.xml.util.LazySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DEREncodedKeyValueProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(DEREncodedKeyValueProvider.class);

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return this.getDEREncodedKeyValue(keyInfoChild) != null;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CriteriaSet criteriaSet, KeyInfoResolutionContext kiContext) throws SecurityException {
        KeyInfoCredentialContext credContext;
        DEREncodedKeyValue keyValue = this.getDEREncodedKeyValue(keyInfoChild);
        if (keyValue == null) {
            return null;
        }
        this.log.debug("Attempting to extract credential from a DEREncodedKeyValue");
        PublicKey pubKey = null;
        try {
            pubKey = KeyInfoHelper.getKey(keyValue);
        }
        catch (KeyException e) {
            this.log.error("Error extracting DER-encoded key value", e);
            throw new SecurityException("Error extracting DER-encoded key value", e);
        }
        KeyAlgorithmCriteria algorithmCriteria = criteriaSet.get(KeyAlgorithmCriteria.class);
        if (algorithmCriteria != null && algorithmCriteria.getKeyAlgorithm() != null && !algorithmCriteria.getKeyAlgorithm().equals(pubKey.getAlgorithm())) {
            this.log.debug("Criteria specified key algorithm {}, actually {}, skipping", (Object)algorithmCriteria.getKeyAlgorithm(), (Object)pubKey.getAlgorithm());
            return null;
        }
        BasicCredential cred = new BasicCredential();
        cred.setPublicKey(pubKey);
        if (kiContext != null) {
            cred.getKeyNames().addAll(kiContext.getKeyNames());
        }
        if ((credContext = this.buildCredentialContext(kiContext)) != null) {
            cred.getCredentalContextSet().add(credContext);
        }
        this.log.debug("Credential successfully extracted from DEREncodedKeyValue");
        LazySet<Credential> credentialSet = new LazySet<Credential>();
        credentialSet.add(cred);
        return credentialSet;
    }

    protected DEREncodedKeyValue getDEREncodedKeyValue(XMLObject xmlObject) {
        if (xmlObject instanceof DEREncodedKeyValue) {
            return (DEREncodedKeyValue)xmlObject;
        }
        return null;
    }
}

