/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.Arrays;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509DigestCriteria;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvaluableX509DigestCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableX509DigestCredentialCriteria.class);
    private final String algorithm;
    private final byte[] x509digest;

    public EvaluableX509DigestCredentialCriteria(X509DigestCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.algorithm = criteria.getAlgorithm();
        this.x509digest = criteria.getDigest();
    }

    public EvaluableX509DigestCredentialCriteria(String alg, byte[] digest) {
        if (digest == null || digest.length == 0) {
            throw new IllegalArgumentException("X.509 digest cannot be null or empty");
        }
        if (DatatypeHelper.isEmpty(alg)) {
            throw new IllegalArgumentException("Digest algorithm criteria value cannot be null or empty");
        }
        this.x509digest = digest;
        this.algorithm = DatatypeHelper.safeTrimOrNullString(alg);
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, does not satisfy X.509 digest criteria");
            return Boolean.FALSE;
        }
        X509Certificate entityCert = ((X509Credential)target).getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, does not satisfy criteria");
            return Boolean.FALSE;
        }
        try {
            MessageDigest hasher = MessageDigest.getInstance(this.algorithm);
            byte[] hashed = hasher.digest(entityCert.getEncoded());
            return Arrays.areEqual(hashed, this.x509digest);
        }
        catch (CertificateEncodingException e) {
            this.log.error("Unable to encode certificate for digest operation", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Unable to obtain a digest implementation for algorithm {" + this.algorithm + "}", e);
        }
        return null;
    }
}

