/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationWebAuthnHardwareToken
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationWebAuthnHardwareToken.class);
    private static final String REGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_webauthnhardwaretoken.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationWebAuthnHardwareToken(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationWebAuthnHardwareToken doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_U2FHardwareToken").booleanValue()) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", new ArrayList());
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            context.put("attestationType", "none");
            context.put("authenticatorType", "cross-platform");
            context.put("userVerification", "discouraged");
            context.put("residentKey", false);
            String template = this.pluginSettings.getConfigureWebAuthnHardwareTokenTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationWebAuthnHardwareToken doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        ArrayList<String> errorMessage = new ArrayList<String>();
        HttpSession httpSessionssion = request.getSession();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String deviceRegistered = request.getParameter("deviceRegistered");
            if (StringUtils.equalsIgnoreCase((CharSequence)((String)httpSessionssion.getAttribute("validate_WebAuthn_successfully")), (CharSequence)"TRUE")) {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Yubikey Hardware Token");
                LOGGER.debug("Yubikey is configured as U2F Successfully");
                twoFactorUserClass.setConfigured2FAMethodsByUser("YubikeyHardwareTokenAsU2F");
                twoFactorUserClass.setCurrent2FAMethod("YubikeyHardwareTokenAsU2F");
                twoFactorUserClass.setIsWebAuthnConfigured(Boolean.TRUE);
                this.settings.setIsWebAuthnConfigured(username, true);
                if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableBackupMethod())) {
                    LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(request, twoFactorUserClass.getConfigured2FAMethodsByUser());
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        response.sendRedirect(url);
                        return;
                    }
                }
                LOGGER.debug("2FA is Configured successfully");
                HttpSession session = request.getSession();
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                session.removeAttribute("validate_WebAuthn_successfully");
                this.settings.addTo2FAConfiguredUsersList(username);
                this.settings.setUserSettings(username, twoFactorUserClass);
                this.pluginHandler.redirectToValidUrl(request, response);
                return;
            }
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "Yubikey Hardware Token");
            LOGGER.debug("Hardware Token is Not valid");
            errorMessage.add("Hardware Token is Not valid. Please enter valid Hardware Token.");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            context.put("attestationType", "none");
            context.put("authenticatorType", "cross-platform");
            context.put("userVerification", "discouraged");
            context.put("residentKey", false);
            String template = this.pluginSettings.getConfigureWebAuthnHardwareTokenTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

