/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorExportUsers
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorExportUsers.class);
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private CrowdService crowdService;
    private UserManager userManager;

    public MoTwoFactorExportUsers(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, CrowdService crowdService, UserManager userManager) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.debug("MoTwoFactorExportUsers doGet called");
        List<String> pages = this.pluginHandler.getUserAccessiblePages();
        if (pages.contains("User_Management_readwrite") || pages.contains("User_Management_read")) {
            LOGGER.debug("Valid Admin user found");
            String action = request.getParameter("action");
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"AllUsers")) {
                LOGGER.debug("Exporting All Users");
                this.exportAllUsers(request, response);
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"EnabledUsers")) {
                LOGGER.debug("Exporting Enabled Users");
                this.exportEnabledUsers(request, response);
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"DisabledUsers")) {
                LOGGER.debug("Exporting Disabled Users");
                this.exportDisabledUsers(request, response);
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"ConfiguredUsers")) {
                LOGGER.debug("Exporting Configured Users");
                this.exportConfiguredUsers(request, response);
                return;
            }
            LOGGER.debug("Invalid Export action parameter");
        }
        LOGGER.debug("Invalid User or user is not an admin.");
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    private void exportConfiguredUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportConfiguredUsers called");
        List<String> enabledList = this.settings.getEnable2FAForUsersList();
        List<String> configuredList = this.settings.getListOf2FAConfiguredUsers();
        String str = ",,Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",,Total 2FA Configured Users,: " + configuredList.size() + "\n\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Username");
        stringJoiner.add("Email");
        stringJoiner.add("Status");
        stringJoiner.add("2FA Enabled");
        str = str + stringJoiner.toString() + "\n";
        int i = 0;
        for (String username : configuredList) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUserFromManager(username);
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(username);
            stringJoiner.add(userProfile.getEmail());
            if (userProfile != null) {
                stringJoiner.add("Active");
            } else {
                stringJoiner.add("Inactive");
            }
            if (enabledList.contains(username)) {
                stringJoiner.add("Enabled");
            } else {
                stringJoiner.add("Disabled");
            }
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Configured_Users.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    private void exportEnabledUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportEnabledUsers called");
        List<String> enabledList = this.settings.getEnable2FAForUsersList();
        List<String> configuredList = this.settings.getListOf2FAConfiguredUsers();
        String str = ",,Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",,Total 2FA Enabled Users,: " + enabledList.size() + "\n\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Username");
        stringJoiner.add("Email");
        stringJoiner.add("Status");
        stringJoiner.add("2FA Configured");
        str = str + stringJoiner.toString() + "\n";
        int i = 0;
        for (String username : enabledList) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUserFromManager(username);
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(username);
            stringJoiner.add(userProfile.getEmail());
            if (userProfile != null) {
                stringJoiner.add("Active");
            } else {
                stringJoiner.add("Inactive");
            }
            if (configuredList.contains(username)) {
                stringJoiner.add("Configured");
            } else {
                stringJoiner.add("Not Configured");
            }
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Enabled_Users.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    private void exportDisabledUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportEnabledUsers called");
        List<String> DisabledList = this.settings.getDisable2FAForUsersList();
        List<String> configuredList = this.settings.getListOf2FAConfiguredUsers();
        String str = ",,Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",,Total 2FA Disabled Users,: " + DisabledList.size() + "\n\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Username");
        stringJoiner.add("Email");
        stringJoiner.add("Status");
        stringJoiner.add("2FA Configured");
        str = str + stringJoiner.toString() + "\n";
        int i = 0;
        for (String username : DisabledList) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUserFromManager(username);
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(username);
            stringJoiner.add(userProfile.getEmail());
            if (userProfile != null) {
                stringJoiner.add("Active");
            } else {
                stringJoiner.add("Inactive");
            }
            if (configuredList.contains(username)) {
                stringJoiner.add("Configured");
            } else {
                stringJoiner.add("Not Configured");
            }
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Disabled_Users.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    private void exportAllUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportAllUsers called");
        List<String> enabledList = this.settings.getEnable2FAForUsersList();
        List<String> configuredList = this.settings.getListOf2FAConfiguredUsers();
        String str = ",,Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",,Total 2FA Enabled Users,: " + enabledList.size() + "\n";
        str = str + ",,Total 2FA Configured Users,: " + configuredList.size() + "\n\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Username");
        stringJoiner.add("Email");
        stringJoiner.add("Status");
        stringJoiner.add("2FA Enabled");
        stringJoiner.add("2FA Configured");
        str = str + stringJoiner.toString() + "\n";
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        LOGGER.debug("Query for User : " + query);
        Iterable usersFromSystem = this.crowdService.search((Query)query);
        int i = 0;
        for (User user : usersFromSystem) {
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(user.getName());
            stringJoiner.add(user.getEmailAddress());
            if (user.isActive()) {
                stringJoiner.add("Active");
            } else {
                stringJoiner.add("Inactive");
            }
            if (enabledList.contains(user.getName())) {
                stringJoiner.add("Enabled");
            } else {
                stringJoiner.add("Disabled");
            }
            if (configuredList.contains(user.getName())) {
                stringJoiner.add("Configured");
            } else {
                stringJoiner.add("Not Configured");
            }
            str = str + stringJoiner.toString() + "\n";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_Users.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

