/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorAdvancedSettings
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAdvancedSettings.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private Boolean settingsSubmitted;
    private String xsrfToken;
    private Boolean enableRememberMeDevice;
    private String rememberMeDeviceDuration;
    private Boolean enableBruteForceProtection;
    private String bruteForceNumberOfAttempts;
    private String bruteForceTimeInterval;
    private String bruteForceCustomTimeInterval;
    private String bruteForceCustomTimeDuration;
    private String appLabel;
    private Boolean showSupportedAppPopup;
    private String smsGateway;
    private ArrayList smsGatewayOptions;
    private String customerKey;
    private String apiKey;
    private String smsGatewayUrl;
    private String smsTemplate;
    private String attestationType;
    private String authenticatorType;
    private String userVerification;
    private String residentKey;
    private String emailTemplate;
    private String otpValidityDuration = "2";
    private String otpLength = "6";
    private Boolean smtpConfigured;
    private Boolean bypass2faAfterCrowdSso;
    private Boolean ignore2FAAfterSso;
    private String ssoLoginUrl;
    private String clientIpRequestHeader;
    private String skip2faUrls;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String byPassCookieDomain;
    private Boolean enableShareSecretKey;
    private String duoPushNotificationIntegrationKey;
    private String duoPushNotificationSecretKey;
    private String duoPushNotificationHostName;
    private SortedMap<String, String> groupsWithAdminPagesAccess;
    private int totalGroupsWithAdminPagesAccessConfigs;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private Boolean showWarningMssg = Boolean.FALSE;

    public MoTwoFactorAdvancedSettings(UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    public Boolean doValidate() {
        int number;
        LOGGER.debug("Configure Action doValidate");
        Boolean hasError = Boolean.FALSE;
        try {
            if (BooleanUtils.toBoolean((Boolean)this.enableRememberMeDevice)) {
                number = Integer.parseInt(this.rememberMeDeviceDuration);
                LOGGER.debug("number : " + number);
                if (number > 365 || number < 1) {
                    this.addActionError("The expiry time must be between 1 and 365.");
                    hasError = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid Expiry Time. Expiry Time should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            if (BooleanUtils.toBoolean((Boolean)this.enableBruteForceProtection) && ((number = Integer.parseInt(this.bruteForceNumberOfAttempts)) > 10 || number < 1)) {
                this.addActionError("Invalid Number of Login attempts Entered. The Login Attempt must be between 1 and 10.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid Number of Login attempts. Number of Login attempts should be in number format.");
            hasError = Boolean.TRUE;
        }
        if (!BooleanUtils.toBoolean((Boolean)this.bypass2faAfterCrowdSso)) {
            this.bypass2faAfterCrowdSso = Boolean.FALSE;
        }
        try {
            if (BooleanUtils.toBoolean((Boolean)this.enableBruteForceProtection)) {
                if (!this.getBruteForceTimeIntervalArray().contains(this.bruteForceTimeInterval)) {
                    this.addActionError("Please select valid Time Interval");
                    hasError = Boolean.TRUE;
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"custom", (CharSequence)this.bruteForceTimeInterval)) {
                    if (!this.getBruteForceCustomTimeIntervalArray().contains(this.bruteForceCustomTimeInterval)) {
                        this.addActionError("Please select valid Time Custom Interval");
                        hasError = Boolean.TRUE;
                    } else {
                        int number2 = Integer.parseInt(this.bruteForceCustomTimeDuration);
                        if (number2 < 1) {
                            this.addActionError("The Custom Locking Expiry Time should be greater than equal to 1.");
                            hasError = Boolean.TRUE;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid Locking Expiry Time. Locking Expiry Time should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            int number3 = Integer.parseInt(this.otpLength);
            if (number3 > 8 || number3 < 4) {
                this.addActionError("Invalid OTP Length. The OTP Length must be between 4 to 8.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid OTP Length. OTP Length should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            int number4 = Integer.parseInt(this.otpValidityDuration);
            if (number4 > 10 || number4 < 1) {
                this.addActionError("Invalid OTP Validity Duration. The OTP Validity Duration must be between 1 and 10.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid OTP Validity Duration. OTP Validity Duration date should be in number format.");
            hasError = Boolean.TRUE;
        }
        if (StringUtils.isBlank((CharSequence)this.duoPushNotificationIntegrationKey) && StringUtils.isBlank((CharSequence)this.duoPushNotificationSecretKey) && StringUtils.isBlank((CharSequence)this.duoPushNotificationHostName)) {
            LOGGER.debug("Not saving the Push Notification details");
        } else if (StringUtils.isBlank((CharSequence)this.duoPushNotificationIntegrationKey)) {
            this.addActionError("Integration Key cannot be blank.");
            hasError = Boolean.TRUE;
        } else if (StringUtils.isBlank((CharSequence)this.duoPushNotificationSecretKey)) {
            this.addActionError("Secret Key cannot be blank.");
            hasError = Boolean.TRUE;
        } else if (StringUtils.isBlank((CharSequence)this.duoPushNotificationHostName)) {
            this.addActionError("Host Name cannot be blank.");
            hasError = Boolean.TRUE;
        } else if (StringUtils.isNotBlank((CharSequence)this.duoPushNotificationHostName)) {
            try {
                new URL(this.duoPushNotificationHostName);
                this.addActionError("Invalid Hostname found. Please enter valid hostname.");
                hasError = Boolean.TRUE;
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Valid Hostname found.");
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.ignore2FAAfterSso)) {
            if (StringUtils.isBlank((CharSequence)this.ssoLoginUrl)) {
                this.addActionError("Empty SSO Login URL found. Please add valid SSO Login URL.");
                hasError = Boolean.TRUE;
            } else {
                for (String url : this.ssoLoginUrl.split(",")) {
                    try {
                        new URL(url.trim());
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error("Invalid URL", e);
                        this.addActionError("Invalid SSO Login URL Found.");
                        hasError = Boolean.TRUE;
                        break;
                    }
                }
            }
        }
        return hasError;
    }

    public String execute() throws Exception {
        LOGGER.debug("MoTwoFactorAdvancedSettings doExecute called");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("Advanced_Settings_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("Advanced_Settings_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            try {
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    return "verify";
                }
                this.skip2faUrls = MoTwoFactorUtility.sanitizeText(this.skip2faUrls);
                this.clientIpRequestHeader = MoTwoFactorUtility.sanitizeText(this.clientIpRequestHeader);
                this.appLabel = MoTwoFactorUtility.sanitizeText(this.appLabel);
                this.customerKey = MoTwoFactorUtility.sanitizeText(this.customerKey);
                this.apiKey = MoTwoFactorUtility.sanitizeText(this.apiKey);
                if (this.pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)this.settingsSubmitted) && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
                    if (BooleanUtils.toBoolean((Boolean)this.ignore2FAAfterSso)) {
                        StringJoiner stringJoiner = new StringJoiner(",");
                        for (String url : this.ssoLoginUrl.split(",")) {
                            stringJoiner.add(url.trim());
                        }
                        this.ssoLoginUrl = stringJoiner.toString();
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.byPassCookieDomain) && this.byPassCookieDomain.startsWith(".")) {
                        this.byPassCookieDomain = this.byPassCookieDomain.substring(1);
                    }
                    this.showWarningMssg = false;
                    this.totalGroupsWithAdminPagesAccessConfigs = Integer.parseInt(this.request.getParameter("totalGroupsWithAdminPagesAccessConfigs"));
                    HashMap<String, String> pagesWithGroupAccessMapping = new HashMap<String, String>();
                    for (int i = 0; i < this.totalGroupsWithAdminPagesAccessConfigs; ++i) {
                        String pageName = this.request.getParameter("PageName_" + i);
                        String accessType = this.request.getParameter("AccessType_" + i);
                        String value = this.request.getParameter("includeGroups_" + i);
                        if (StringUtils.isNotEmpty((CharSequence)pageName) && StringUtils.isNotEmpty((CharSequence)accessType) && StringUtils.isNotEmpty((CharSequence)value)) {
                            String key = pageName + "_" + accessType;
                            List<String> groups = Arrays.asList(value.split(","));
                            if (!pagesWithGroupAccessMapping.keySet().isEmpty() && pagesWithGroupAccessMapping.containsKey(key)) {
                                String existingGroups = (String)pagesWithGroupAccessMapping.get(key);
                                for (String group : groups) {
                                    if (!existingGroups.contains(group)) {
                                        existingGroups = existingGroups + "," + group;
                                        continue;
                                    }
                                    this.showWarningMssg = true;
                                }
                                pagesWithGroupAccessMapping.put(key, existingGroups);
                                continue;
                            }
                            pagesWithGroupAccessMapping.put(key, value);
                            continue;
                        }
                        this.showWarningMssg = true;
                    }
                    this.pluginHandler.saveAdvanced2FASettings(this.enableBruteForceProtection, this.bruteForceNumberOfAttempts, this.bruteForceTimeInterval, this.bruteForceCustomTimeInterval, this.bruteForceCustomTimeDuration, this.enableRememberMeDevice, this.rememberMeDeviceDuration, this.appLabel, this.showSupportedAppPopup, this.emailTemplate, this.otpLength, this.otpValidityDuration, this.smsGateway, this.customerKey, this.apiKey, this.smsGatewayUrl, this.smsTemplate, this.bypass2faAfterCrowdSso, this.byPassCookieDomain, this.ignore2FAAfterSso, this.ssoLoginUrl, this.enableShareSecretKey, this.duoPushNotificationIntegrationKey, this.duoPushNotificationSecretKey, this.duoPushNotificationHostName, this.clientIpRequestHeader, this.skip2faUrls, pagesWithGroupAccessMapping, this.attestationType, this.authenticatorType, this.userVerification, this.residentKey);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings Updated");
                }
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "upm";
            }
            this.initializeConfig();
            return "success";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        LOGGER.debug("inside MoTwoFactorAdvancedSettings initializeConfig...");
        this.appLabel = this.settings.getAppLabel("Crowd");
        this.enableRememberMeDevice = this.settings.getEnableRememberMeDevice();
        this.bypass2faAfterCrowdSso = this.settings.getBypass2faAfterCrowdSso();
        this.rememberMeDeviceDuration = this.settings.getRememberMeDeviceDuration().toString();
        this.enableBruteForceProtection = this.settings.getEnableBruteForceProtection();
        this.bruteForceNumberOfAttempts = this.settings.getBruteForceNumberOfAttempts().toString();
        this.bruteForceTimeInterval = this.settings.getBruteForceTimeInterval();
        this.bruteForceCustomTimeInterval = this.settings.getBruteForceCustomTimeInterval();
        this.bruteForceCustomTimeDuration = this.settings.getBruteForceCustomTimeDuration().toString();
        this.showSupportedAppPopup = this.settings.getShowSupportedAppPopup();
        this.emailTemplate = this.settings.getEmailTemplate();
        this.otpValidityDuration = this.settings.getOtpValidityDuration().toString();
        this.otpLength = this.settings.getOtpLength().toString();
        this.smtpConfigured = this.pluginHandler.isSmtpConfigured();
        this.smsGateway = this.settings.getSmsGateway();
        this.customerKey = this.settings.getCustomerKey();
        this.apiKey = this.settings.getApiKey();
        this.smsGatewayUrl = this.settings.getSmsGatewayUrl();
        this.smsTemplate = this.settings.getSmsTemplate();
        this.attestationType = this.settings.getAttestationType();
        this.authenticatorType = this.settings.getAuthenticatorType();
        this.userVerification = this.settings.getUserVerification();
        this.residentKey = this.settings.getResidentKey();
        this.ignore2FAAfterSso = this.settings.getIgnore2FAAfterSso();
        this.ssoLoginUrl = this.settings.getSsoLoginUrl();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.byPassCookieDomain = this.settings.getBypass2FACookieDomain();
        this.enableShareSecretKey = this.settings.getEnableShareSecretKey();
        this.duoPushNotificationIntegrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        this.duoPushNotificationSecretKey = this.settings.getDuoPushNotificationSecretKey();
        this.duoPushNotificationHostName = this.settings.getDuoPushNotificationHostName();
        this.clientIpRequestHeader = this.settings.getClientIpRequestHeader();
        this.skip2faUrls = this.settings.getSkip2faUrls();
        Map<String, String> groupsWithAdminPageAccessMap = this.settings.getGroupsWithAdminPagesAccess();
        this.groupsWithAdminPagesAccess = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : groupsWithAdminPageAccessMap.entrySet()) {
            this.groupsWithAdminPagesAccess.put(entry.getKey(), entry.getValue());
        }
        if (this.groupsWithAdminPagesAccess.keySet().isEmpty()) {
            LOGGER.debug("pages with group access length: " + this.groupsWithAdminPagesAccess.keySet().size());
            this.totalGroupsWithAdminPagesAccessConfigs = 0;
        } else {
            this.totalGroupsWithAdminPagesAccessConfigs = this.groupsWithAdminPagesAccess.keySet().size();
            LOGGER.debug("pages with group access length:" + this.totalGroupsWithAdminPagesAccessConfigs);
            LOGGER.debug("pages with group access" + this.groupsWithAdminPagesAccess);
        }
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("Advanced_Settings_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("Advanced_Settings_read")) {
            this.pageAccessType = "read";
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private List<String> getBruteForceTimeIntervalArray() {
        ArrayList<String> bruteForceTimeIntervalArray = new ArrayList<String>();
        bruteForceTimeIntervalArray.add("15 minutes");
        bruteForceTimeIntervalArray.add("30 minutes");
        bruteForceTimeIntervalArray.add("1 hour");
        bruteForceTimeIntervalArray.add("5 hours");
        bruteForceTimeIntervalArray.add("1 day");
        bruteForceTimeIntervalArray.add("7 days");
        bruteForceTimeIntervalArray.add("custom");
        return bruteForceTimeIntervalArray;
    }

    private List<String> getBruteForceCustomTimeIntervalArray() {
        ArrayList<String> bruteForceCustomTimeIntervalArray = new ArrayList<String>();
        bruteForceCustomTimeIntervalArray.add("minutes");
        bruteForceCustomTimeIntervalArray.add("hours");
        bruteForceCustomTimeIntervalArray.add("days");
        return bruteForceCustomTimeIntervalArray;
    }

    public String getClientIpRequestHeader() {
        return this.clientIpRequestHeader;
    }

    public void setClientIpRequestHeader(String clientIpRequestHeader) {
        this.clientIpRequestHeader = clientIpRequestHeader;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String getSkip2faUrls() {
        return this.skip2faUrls;
    }

    public void setSkip2faUrls(String skip2faUrls) {
        this.skip2faUrls = skip2faUrls;
    }

    public Boolean getSettingsSubmitted() {
        return this.settingsSubmitted;
    }

    public void setSettingsSubmitted(Boolean settingsSubmitted) {
        this.settingsSubmitted = settingsSubmitted;
    }

    public String getAppLabel() {
        return this.appLabel;
    }

    public void setAppLabel(String appLabel) {
        this.appLabel = appLabel;
    }

    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    public String getOtpValidityDuration() {
        return this.otpValidityDuration;
    }

    public void setOtpValidityDuration(String otpValidityDuration) {
        this.otpValidityDuration = otpValidityDuration;
    }

    public String getOtpLength() {
        return this.otpLength;
    }

    public void setOtpLength(String otpLength) {
        this.otpLength = otpLength;
    }

    public Boolean getSmtpConfigured() {
        return this.smtpConfigured;
    }

    public void setSmtpConfigured(Boolean smtpConfigured) {
        this.smtpConfigured = smtpConfigured;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getEnableRememberMeDevice() {
        return this.enableRememberMeDevice;
    }

    public void setEnableRememberMeDevice(Boolean enableRememberMeDevice) {
        this.enableRememberMeDevice = enableRememberMeDevice;
    }

    public Boolean getBypass2faAfterCrowdSso() {
        return this.bypass2faAfterCrowdSso;
    }

    public void setBypass2faAfterCrowdSso(Boolean bypass2faAfterCrowdSso) {
        this.bypass2faAfterCrowdSso = bypass2faAfterCrowdSso;
    }

    public String getRememberMeDeviceDuration() {
        return this.rememberMeDeviceDuration;
    }

    public void setRememberMeDeviceDuration(String rememberMeDeviceDuration) {
        this.rememberMeDeviceDuration = rememberMeDeviceDuration;
    }

    public Boolean getEnableBruteForceProtection() {
        return this.enableBruteForceProtection;
    }

    public void setEnableBruteForceProtection(Boolean enableBruteForceProtection) {
        this.enableBruteForceProtection = enableBruteForceProtection == null ? Boolean.FALSE : enableBruteForceProtection;
    }

    public String getBruteForceNumberOfAttempts() {
        return this.bruteForceNumberOfAttempts;
    }

    public void setBruteForceNumberOfAttempts(String bruteForceNumberOfAttempts) {
        this.bruteForceNumberOfAttempts = bruteForceNumberOfAttempts;
    }

    public String getBruteForceTimeInterval() {
        return this.bruteForceTimeInterval;
    }

    public void setBruteForceTimeInterval(String bruteForceTimeInterval) {
        this.bruteForceTimeInterval = bruteForceTimeInterval;
    }

    public String getBruteForceCustomTimeInterval() {
        return this.bruteForceCustomTimeInterval;
    }

    public void setBruteForceCustomTimeInterval(String bruteForceCustomTimeInterval) {
        this.bruteForceCustomTimeInterval = bruteForceCustomTimeInterval;
    }

    public String getBruteForceCustomTimeDuration() {
        return this.bruteForceCustomTimeDuration;
    }

    public void setBruteForceCustomTimeDuration(String bruteForceCustomTimeDuration) {
        this.bruteForceCustomTimeDuration = bruteForceCustomTimeDuration;
    }

    public Boolean getShowSupportedAppPopup() {
        return this.showSupportedAppPopup;
    }

    public void setShowSupportedAppPopup(Boolean showSupportedAppPopup) {
        this.showSupportedAppPopup = showSupportedAppPopup;
    }

    public String getSmsGateway() {
        return this.smsGateway;
    }

    public void setSmsGateway(String smsGateway) {
        this.smsGateway = smsGateway;
    }

    public ArrayList getSmsGatewayOptions() {
        this.smsGatewayOptions = new ArrayList();
        this.smsGatewayOptions.add("miniOrange Gateway");
        this.smsGatewayOptions.add("Custom Gateway");
        return this.smsGatewayOptions;
    }

    public void setSmsGatewayOptions(ArrayList smsGatewayOptions) {
        this.smsGatewayOptions = smsGatewayOptions;
    }

    public String getCustomerKey() {
        return this.customerKey;
    }

    public void setCustomerKey(String customerKey) {
        this.customerKey = customerKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSmsGatewayUrl() {
        return this.smsGatewayUrl;
    }

    public void setSmsGatewayUrl(String smsGatewayUrl) {
        this.smsGatewayUrl = smsGatewayUrl;
    }

    public String getSmsTemplate() {
        return this.smsTemplate;
    }

    public void setSmsTemplate(String smsTemplate) {
        this.smsTemplate = smsTemplate;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public Boolean getIgnore2FAAfterSso() {
        return this.ignore2FAAfterSso;
    }

    public void setIgnore2FAAfterSso(Boolean ignore2FAAfterSso) {
        this.ignore2FAAfterSso = ignore2FAAfterSso;
    }

    public String getSsoLoginUrl() {
        return this.ssoLoginUrl;
    }

    public void setSsoLoginUrl(String ssoLoginUrl) {
        this.ssoLoginUrl = ssoLoginUrl;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getByPassCookieDomain() {
        return this.byPassCookieDomain;
    }

    public void setByPassCookieDomain(String byPassCookieDomain) {
        this.byPassCookieDomain = byPassCookieDomain;
    }

    public Boolean getEnableShareSecretKey() {
        return this.enableShareSecretKey;
    }

    public void setEnableShareSecretKey(Boolean enableShareSecretKey) {
        this.enableShareSecretKey = enableShareSecretKey;
    }

    public String getDuoPushNotificationIntegrationKey() {
        return this.duoPushNotificationIntegrationKey;
    }

    public void setDuoPushNotificationIntegrationKey(String duoPushNotificationIntegrationKey) {
        this.duoPushNotificationIntegrationKey = duoPushNotificationIntegrationKey;
    }

    public String getDuoPushNotificationSecretKey() {
        return this.duoPushNotificationSecretKey;
    }

    public void setDuoPushNotificationSecretKey(String duoPushNotificationSecretKey) {
        this.duoPushNotificationSecretKey = duoPushNotificationSecretKey;
    }

    public String getDuoPushNotificationHostName() {
        return this.duoPushNotificationHostName;
    }

    public void setDuoPushNotificationHostName(String duoPushNotificationHostName) {
        this.duoPushNotificationHostName = duoPushNotificationHostName;
    }

    public SortedMap<String, String> getGroupsWithAdminPagesAccess() {
        return this.groupsWithAdminPagesAccess;
    }

    public void setGroupsWithAdminPagesAccess(SortedMap<String, String> groupsWithAdminPagesAccess) {
        this.groupsWithAdminPagesAccess = groupsWithAdminPagesAccess;
    }

    public int getTotalGroupsWithAdminPagesAccessConfigs() {
        return this.totalGroupsWithAdminPagesAccessConfigs;
    }

    public String getAttestationType() {
        return this.attestationType;
    }

    public void setTotalGroupsWithAdminPagesAccessConfigs(int totalGroupsWithAdminPagesAccessConfigs) {
        this.totalGroupsWithAdminPagesAccessConfigs = totalGroupsWithAdminPagesAccessConfigs;
    }

    public void setAttestationType(String attestationType) {
        this.attestationType = attestationType;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.authenticatorType = authenticatorType;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public String getUserVerification() {
        return this.userVerification;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public void setUserVerification(String userVerification) {
        this.userVerification = userVerification;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public String getResidentKey() {
        return this.residentKey;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public void setResidentKey(String residentKey) {
        this.residentKey = residentKey;
    }

    public Boolean getShowWarningMssg() {
        return this.showWarningMssg;
    }

    public void setShowWarningMssg(Boolean showWarningMssg) {
        this.showWarningMssg = showWarningMssg;
    }
}

