/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorPluginException;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.scheduler.UpdateLicenseService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorAccountDetailsAction
extends BaseAction {
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginHandler pluginHandler;
    private UpdateLicenseService updateLicenseService;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private String email;
    private Boolean reregister;
    private Boolean checklicense;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAccountDetailsAction.class);
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;

    public MoTwoFactorAccountDetailsAction(UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginHandler pluginHandler, UpdateLicenseService updateLicenseService, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginSettings = pluginSettings;
        this.pluginHandler = pluginHandler;
        this.updateLicenseService = updateLicenseService;
        this.pluginConfiguration = pluginConfiguration;
    }

    public void validate() {
        LOGGER.debug("Account Details Action: validate() called");
    }

    public String execute() throws Exception {
        LOGGER.info("Account Details Action: execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        try {
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    return "register";
                }
                if (this.reregister != null && BooleanUtils.toBoolean((Boolean)this.reregister)) {
                    LOGGER.debug("deactivating customer account");
                    this.pluginHandler.deactivateAndRemoveCustomerAccount();
                    this.updateLicenseService.unschedule();
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    return "verify";
                }
                if (this.pluginSettings.isCustomerRegistered().booleanValue() && BooleanUtils.toBoolean((Boolean)this.checklicense)) {
                    LOGGER.debug("check license...");
                    this.pluginHandler.getLicencedUsers(this.pluginSettings);
                    this.addActionMessage(this.getText("License check success"));
                }
                this.initializeConfig();
                return "success";
            }
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
            return null;
        }
        catch (MoTwoFactorPluginException e) {
            this.pluginHandler.deactivateAndRemoveCustomerAccount();
            LOGGER.error(e.getMessage());
            this.addActionMessage(this.getText("License Not Found. Please contact support-atlassian@miniorange.atlassian.net for more details."));
            return "register";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while while verifying license against registered account ", e);
            this.initializeConfig();
            this.addActionMessage(this.getText("An error occurred please check logs for more information"));
            return "success";
        }
    }

    private void initializeConfig() {
        this.email = this.pluginSettings.getCustomerEmail();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.pagesAccessibleToUser = new ArrayList<String>();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public Boolean getReregister() {
        return this.reregister;
    }

    public void setReregister(Boolean reregister) {
        this.reregister = reregister;
    }

    public Boolean getChecklicense() {
        return this.checklicense;
    }

    public void setChecklicense(Boolean checklicense) {
        this.checklicense = checklicense;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }
}

