/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import java.util.HashMap;

public class CachingUserManager
implements UserManager {
    protected UserManager underlyingUserManager;
    protected CacheManager cacheManager;
    public String userCacheName = null;
    public String userROCacheName = null;
    public String repositoryCacheName = null;
    public static final String CACHE_SUFFIX_USERS = "users";
    public static final String CACHE_SUFFIX_USERS_RO = "users_ro";
    public static final String CACHE_SUFFIX_REPOSITORIES = "repository";
    protected static User NULL_USER = new DefaultUser(){

        public String toString() {
            return "NULL USER";
        }
    };

    public CachingUserManager() {
    }

    public CachingUserManager(UserManager underlyingUserManager, CacheManager cacheManager) {
        this.underlyingUserManager = underlyingUserManager;
        this.cacheManager = cacheManager;
    }

    public Pager getUsers() throws EntityException {
        return this.underlyingUserManager.getUsers();
    }

    public Pager getUserNames() throws EntityException {
        return this.underlyingUserManager.getUserNames();
    }

    public User getUser(String username) throws EntityException {
        User cachedUser = (User)this.getUserCache().get(username);
        if (cachedUser != null) {
            return NULL_USER.equals(cachedUser) ? null : cachedUser;
        }
        User user = this.underlyingUserManager.getUser(username);
        this.cacheUser(username, user);
        return user;
    }

    private void cacheUser(String username, User user) {
        this.getUserCache().put(username, user == null ? NULL_USER : user);
    }

    private void cacheRepository(String username, Repository repository) {
        this.getRepositoryCache().put(username, repository);
    }

    private void cacheUserROFlag(User user, boolean ro) {
        this.getUserROFlagCache().put(user.getName(), ro);
    }

    private Cache getUserCache() {
        return this.cacheManager.getCache(this.userCacheName);
    }

    private Cache getUserROFlagCache() {
        return this.cacheManager.getCache(this.userROCacheName);
    }

    private Cache getRepositoryCache() {
        return this.cacheManager.getCache(this.repositoryCacheName);
    }

    public User createUser(String username) throws EntityException {
        User user = this.underlyingUserManager.createUser(username);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
        return user;
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        this.underlyingUserManager.alterPassword(user, plainTextPass);
    }

    public void saveUser(User user) throws EntityException {
        this.underlyingUserManager.saveUser(user);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
    }

    public void removeUser(User user) throws EntityException {
        this.underlyingUserManager.removeUser(user);
        try {
            this.removeUserFromCache(user);
        }
        catch (Exception e) {
            throw new EntityException("User removed in underlying repository but could not remove from cache");
        }
    }

    private void removeUserFromCache(User user) throws Exception {
        this.getUserCache().remove(user.getName());
    }

    public boolean isReadOnly(User user) throws EntityException {
        Boolean cachedROFlag = (Boolean)this.getUserROFlagCache().get(user.getName());
        if (cachedROFlag == null) {
            boolean ro = this.underlyingUserManager.isReadOnly(user);
            this.cacheUserROFlag(user, ro);
            return ro;
        }
        return cachedROFlag;
    }

    public Repository getRepository() {
        return this.underlyingUserManager.getRepository();
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository repository = null;
        Repository cachedRepository = (Repository)this.getRepositoryCache().get(entity.getName());
        if (cachedRepository == null) {
            repository = this.underlyingUserManager.getRepository(entity);
            this.cacheRepository(entity.getName(), repository);
            return repository;
        }
        return cachedRepository;
    }

    public boolean isCreative() {
        return this.underlyingUserManager.isCreative();
    }

    public void init(HashMap args) throws ConfigurationException {
        this.cacheManager = (CacheManager)args.get("cacheManager");
        this.underlyingUserManager = (UserManager)args.get("userManager");
        InitializationCheck.validateArgs(args, new String[]{"cacheManager", "userManager"}, this);
        this.userCacheName = this.getCacheKey(CACHE_SUFFIX_USERS);
        this.userROCacheName = this.getCacheKey(CACHE_SUFFIX_USERS_RO);
        this.repositoryCacheName = this.getCacheKey(CACHE_SUFFIX_REPOSITORIES);
    }

    private String getCacheKey(String cacheName) {
        String className = this.underlyingUserManager.getClass().getName();
        String repositoryKey = this.underlyingUserManager.getRepository().getKey();
        return className + "." + repositoryKey + "." + cacheName;
    }
}

