/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.ArrayEncoder;
import co.nstant.in.cbor.encoder.ByteStringEncoder;
import co.nstant.in.cbor.encoder.MapEncoder;
import co.nstant.in.cbor.encoder.NegativeIntegerEncoder;
import co.nstant.in.cbor.encoder.RationalNumberEncoder;
import co.nstant.in.cbor.encoder.SpecialEncoder;
import co.nstant.in.cbor.encoder.TagEncoder;
import co.nstant.in.cbor.encoder.UnicodeStringEncoder;
import co.nstant.in.cbor.encoder.UnsignedIntegerEncoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.RationalNumber;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.Tag;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public class CborEncoder {
    private final UnsignedIntegerEncoder unsignedIntegerEncoder;
    private final NegativeIntegerEncoder negativeIntegerEncoder;
    private final ByteStringEncoder byteStringEncoder;
    private final UnicodeStringEncoder unicodeStringEncoder;
    private final ArrayEncoder arrayEncoder;
    private final MapEncoder mapEncoder;
    private final TagEncoder tagEncoder;
    private final SpecialEncoder specialEncoder;
    private final RationalNumberEncoder rationalNumberEncoder;

    public CborEncoder(OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        this.unsignedIntegerEncoder = new UnsignedIntegerEncoder(this, outputStream);
        this.negativeIntegerEncoder = new NegativeIntegerEncoder(this, outputStream);
        this.byteStringEncoder = new ByteStringEncoder(this, outputStream);
        this.unicodeStringEncoder = new UnicodeStringEncoder(this, outputStream);
        this.arrayEncoder = new ArrayEncoder(this, outputStream);
        this.mapEncoder = new MapEncoder(this, outputStream);
        this.tagEncoder = new TagEncoder(this, outputStream);
        this.specialEncoder = new SpecialEncoder(this, outputStream);
        this.rationalNumberEncoder = new RationalNumberEncoder(this, outputStream);
    }

    public void encode(List<DataItem> dataItems) throws CborException {
        for (DataItem dataItem : dataItems) {
            this.encode(dataItem);
        }
    }

    public void encode(DataItem dataItem) throws CborException {
        if (dataItem == null) {
            dataItem = SimpleValue.NULL;
        }
        switch (dataItem.getMajorType()) {
            case UNSIGNED_INTEGER: {
                this.unsignedIntegerEncoder.encode((UnsignedInteger)dataItem);
                break;
            }
            case NEGATIVE_INTEGER: {
                this.negativeIntegerEncoder.encode((NegativeInteger)dataItem);
                break;
            }
            case BYTE_STRING: {
                this.byteStringEncoder.encode((ByteString)dataItem);
                break;
            }
            case UNICODE_STRING: {
                this.unicodeStringEncoder.encode((UnicodeString)dataItem);
                break;
            }
            case ARRAY: {
                this.arrayEncoder.encode((Array)dataItem);
                break;
            }
            case MAP: {
                this.mapEncoder.encode((Map)dataItem);
                break;
            }
            case SPECIAL: {
                this.specialEncoder.encode((Special)dataItem);
                break;
            }
            case TAG: {
                this.tagEncoder.encode((Tag)dataItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown major type");
            }
        }
    }

    public void encode(RationalNumber rationalNumber) throws CborException {
        this.rationalNumberEncoder.encode(rationalNumber);
    }
}

