<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
	        AJS.$(document).ready(function() {
	             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	             AJS.$("#CONFIGURE2FA").addClass("aui-nav-selected");
	             AJS.$('input').css("box-shadow","none");

                 var totalCount = ${total2faEnabledUsers};
                 var enableTwoFactor = '${enableTwoFactorString}';
                 if(enableTwoFactor == "true" && totalCount <= 0) {
                     require('aui/flag')({
                         title: 'Two Factor Configuration',
                         type: 'warning',
                         close: 'manual',
                         body: '<p>Two Factor Authentication is disabled for users.<br>Please navigate to the <strong>User Management</strong> tab to enable 2FA for users. Otherwise, 2FA will not work.</p>'
                     });
                 }

                 var isAdmin = "false";

                 jQuery.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                    timeout: 0,
                    data: {
                        "action": "AdminPresent"
                    },
                    type: "GET",
                    success: function (response) {
                    var configuredMethods = '${totalMethodsConfiguredByUser}';
                    console.log("isAdmin",isAdmin);
                    if(enableTwoFactor == 'true' &&  configuredMethods <= 0) {
                    require('aui/flag')({
                         title: 'Two Factor Authentication',
                         type: 'info',
                         close: 'auto',
                         body: '<p>2FA is enabled but no method is configured. If you do not configure it, you will be prompted to configure it during login.</p>'
                     });
                 }
                    },
                    error: function (response) {
                         console.log("in error");
                         isAdmin = "false";
                    },
                 });
                 /*console.log("out of ajax");
                 var configuredMethods = '${totalMethodsConfiguredByUser}';
                 console.log("isAdmin",isAdmin);
                 if(enableTwoFactor == 'true' &&  configuredMethods <= 0) {
                     require('aui/flag')({
                         title: 'Two Factor Authentication',
                         type: 'info',
                         close: 'auto',
                         body: '<p>2FA is enabled but no method is configured. If you do not configure it, you will be prompted to configure it during login.</p>'
                     });
                 }*/

                //setMethodIcons();
	        });

	        function setMethodIcons() {
	            var googleAuthenticatorIcon = document.getElementById("googleAuthenticatorIconId").value;
	            document.getElementById("imgGoogleAuthenticator").src = googleAuthenticatorIcon;

	            var otpOverEmailIconIcon = document.getElementById("otpOverEmailIconId").value;
	            document.getElementById("imgOtpOverEmail").src = otpOverEmailIconIcon;

	            var securityQuestionIcon = document.getElementById("securityQuestionIconId").value;
	            document.getElementById("imgSecurityQuestion").src = securityQuestionIcon;

	            var backupCodeIcon = document.getElementById("backupCodeIconId").value;
	            document.getElementById("imgBackupCode").src = backupCodeIcon;
	        }

	        function validateShowAllConfigureMethod() {
	            if (AJS.$("#showAllConfiguredMethodsDirectly")[0].checked === true) {
	                AJS.$("#enableEnforceCurrentMethod").prop("checked", false);
	                AJS.$("#primaryMethodForUserDiv").hide();
	            }
	        }

	        function validateEnforcePrimaryMethod() {
                if (AJS.$("#enableEnforceCurrentMethod")[0].checked === true) {
                    AJS.$("#showAllConfiguredMethodsDirectly").prop("checked", false);
                }
	        }
        </script>
        
        <style>
        	h4 {
        		display: block;
        		margin: 30px 65px 0px;
        		font-weight: bold;
        	}

        	.aui-page-panel-content{
                padding: 0px !important;
            }

            .aui-page-panel{
                margin: 0px !important;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }
        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>

<#--
	<#assign googleAuthenticatorIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.crowd-twofactor:twofactor.plugin.images.resource", "images/") + "GoogleAuthenticator.png" >
    <input type="hidden" id="googleAuthenticatorIconId" value="${googleAuthenticatorIcon}">

    <#assign otpOverEmailIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.crowd-twofactor:twofactor.plugin.images.resource", "images/") + "OtpOverEmail.png" >
    <input type="hidden" id="otpOverEmailIconId" value="${otpOverEmailIcon}">

    <#assign securityQuestionIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.crowd-twofactor:twofactor.plugin.images.resource", "images/") + "SecurityQuestion.png" >
    <input type="hidden" id="securityQuestionIconId" value="${securityQuestionIcon}">

    <#assign backupCodeIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.crowd-twofactor:twofactor.plugin.images.resource", "images/") + "BackupCode.png" >
    <input type="hidden" id="backupCodeIconId" value="${backupCodeIcon}">
-->

    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <h2>Two Factor Settings</h2>
        <hr class="header"/>
        <br>
        <div class="field-group" style="padding-left: 145px;">
            <span style="vertical-align:middle;">
                <label class="switch" style="vertical-align:middle;">
                    <#if (enableTwoFactor == true)>
                        <input form="settings-form" type="checkbox" id="enableTwoFactor" value="true" name="enableTwoFactor"
                           checked="true"/>
                        <span class="slider round"></span>
                    <#else>
                        <input form="settings-form" type="checkbox" id="enableTwoFactor" value="true" name="enableTwoFactor"/>
                        <span class="slider round"></span>
                    </#if>
                </label>
                <span style="height:16px; width: 16px">&nbsp;
                    Enable 2 Factor Authentication for Crowd users
                </span>
            </span>
        </div>

        <br><br>
        <#include "*/configurable2famethodlist.ftl" parse=true>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>

            <#--<br><br>
            <div id="methodsForUser">
                <h3>2FA methods For User</h3>
                <div class="field-group" style="padding-left: 145px;">
                    <table style="width: 100%;">
                        <tr>
                            <td style="width: 25%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("GoogleAuthenticator"))>
                                            <input type="checkbox" value="GoogleAuthenticator" id="idGoogleAuthenticator" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="GoogleAuthenticator" id="idGoogleAuthenticator" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;Mobile Authenticator
                                </span>
                            </td>
                            <td style="width: 25%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("OtpOverEmail"))>
                                            <input type="checkbox" value="OtpOverEmail" id="idOtpOverEmail" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="OtpOverEmail" id="idOtpOverEmail" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;OTP Over Email
                                </span>
                            </td>
                            <td style="width: 25%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("SecurityQuestion"))>
                                            <input type="checkbox" value="SecurityQuestion" id="idSecurityQuestion" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="SecurityQuestion" id="idSecurityQuestion" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;Security Question
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (allowToReconfigureMethod == true)>
                        <input type="checkbox" id="allowToReconfigureMethod" value="true" name="allowToReconfigureMethod"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="allowToReconfigureMethod" value="true" name="allowToReconfigureMethod"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Allow to reconfigure/reset 2FA method</span>
                    <div class="description">
                        If this option is enabled, user will be able to reconfigure the configured 2FA method.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (enableEnforceCurrentMethod == true)>
                        <input type="checkbox" id="enableEnforceCurrentMethod" onclick="validateEnforcePrimaryMethod()" value="true" name="enableEnforceCurrentMethod"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableEnforceCurrentMethod" onclick="validateEnforcePrimaryMethod()" value="true" name="enableEnforceCurrentMethod"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Enforce Current/Primary Method for User</span>
                    <div class="description">
                        With this option, admin can forcefully set the primary method for user. So the users are always redirected to the selected 2fa method for validation.
                    </div>
                </div>

                <#if (enableEnforceCurrentMethod == true)>
                <div id="primaryMethodForUserDiv">
                <#else>
                <div id="primaryMethodForUserDiv" style="display:none">
                </#if>
                    <div class="field-group" style="padding-left: 200px;">
                        <label>Primary method for user : </label>
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 25%;">
                                    <#if (primaryMethodForUser == "GoogleAuthenticator")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodGoogleAuthenticator" value="GoogleAuthenticator" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodGoogleAuthenticator" value="GoogleAuthenticator" />
                                    </#if>
                                    <label for="primaryMethodGoogleAuthenticator">Mobile Authenticator</label>
                                </td>

                                <td style="width: 25%;">
                                    <#if (primaryMethodForUser == "OtpOverEmail")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverEmail" value="OtpOverEmail" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverEmail" value="OtpOverEmail" />
                                    </#if>
                                    <label for="primaryMethodOtpOverEmail">OTP Over Email</label>
                                </td>

                                <td style="width: 25%;">
                                    <#if (primaryMethodForUser == "SecurityQuestion")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodSecurityQuestion" value="SecurityQuestion" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodSecurityQuestion" value="SecurityQuestion" />
                                    </#if>
                                    <label for="primaryMethodSecurityQuestion">Security Question</label>
                                </td>
                                <td style="width: 25%;">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (showAllConfiguredMethodsDirectly == true)>
                        <input type="checkbox" id="showAllConfiguredMethodsDirectly" onclick="validateShowAllConfigureMethod()" value="true" name="showAllConfiguredMethodsDirectly"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="showAllConfiguredMethodsDirectly" onclick="validateShowAllConfigureMethod()" value="true" name="showAllConfiguredMethodsDirectly"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Show All Configured Methods to User for Validation</span>
                    <div class="description">
                        With this option, user will see the list of all configured 2FA methods directly instead of redirecting to primary 2FA method.
                    </div>
                </div>
            </div>-->

            <br><br>
            <div>
                <h3>Backup Method</h3>
                <div class="field-group" style="padding-left: 145px;">
                    <span style="vertical-align:middle;">
                        <label class="switch" style="vertical-align:middle;">
                            <#if (enableBackupMethod == true)>
                                <input type="checkbox" id="enableBackupMethod" value="true" name="enableBackupMethod"
                                   checked="true"/>
                                <span class="slider round"></span>
                            <#else>
                                <input type="checkbox" id="enableBackupMethod" value="true" name="enableBackupMethod"/>
                                <span class="slider round"></span>
                            </#if>
                        </label>
                        <span style="height:16px; width: 16px">
                            &nbsp;Enable Backup Method For Crowd users
                    </span>
                </div>

                <#--<div id="backupMethodDiv">
                    <div class="field-group" style="padding-left: 200px;">
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("SecurityQuestion"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="SecurityQuestion"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="SecurityQuestion"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>Security Question</span>
                                </td>

                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("OtpOverEmail"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="OtpOverEmail"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="OtpOverEmail"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>OTP Over Email</span>
                                </td>

                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("BackupCode"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="BackupCode"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="BackupCode"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>Backup Code</span>
                                </td>

                                <td style="width: 25%;">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>-->
            </div>

            <br>
            <div id="mobileAuthenticatorSettingsDiv">
                <h3>Mobile Authenticator Settings</h3>
                <div class="field-group" style="padding-left: 247px;">
                    <label for="appLabel">Mobile Authenticator Label: </label>
                    <input type="text" id="appLabel" name="appLabel" autofocus="true" value="${appLabel}" class="text long-field" disabled/>
                    <span class="aui-lozenge aui-lozenge-error" style="margin-left: 1em;">PREMIUM</span>
                    <div class="description">You can name the authenticator application using Label</div>
                </div>
            </div>

            <div class="field-group">
                </br>
                <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
            </div>
        </form>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>