<div id="current2faProvidesDiv">
    <h3 style="margin-left: 10px;">Available 2FA methods</h3>

    <#assign configuredGoogleAuthenticator = false>
    <#assign configuredOtpOverSms = false>
    <#assign configuredOtpOverEmail = false>
    <#assign configuredSecurityQuestion = false>
    <#assign configuredBackupCode = false>
    <#assign configuredDuoPushNotification = false>

    <#assign remainingMethods = totalConfiguredMethods>
    <#list 1..2 as count>
        <#assign loopCount = 0>
        <#if (remainingMethods >= 3)>
        <div class="aui-group" style="width: 87%;margin-left: 10%;">
        <#elseif (remainingMethods == 2)>
        <div class="aui-group" style="width: 58%;margin-left: 10%;">
        <#else>
        <div class="aui-group" style="width: 29%;margin-left: 10%;">
        </#if>

        <#if (loopCount < 3 && shouldShowGoogleAuthenticator == true && configuredGoogleAuthenticator == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredGoogleAuthenticator = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div class="card" style="width: 100%;">
                    <div class="card-body">
                        <b>Mobile Authenticator</b>
                        <#if (currentDefault2faMethod == "GoogleAuthenticator")>
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <#--<td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img id="imgGoogleAuthenticator" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>-->
                                <td>
                                    In this method, user needs to enter 6 digit passcode generated by Mobile Authenticator app.
                                    <br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (googleAuthenticatorConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="google-authenticator-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" resolved>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "GoogleAuthenticator")>
                                <button id="setGoogleAuthenticatorAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        <#else>
                            <button id="google-authenticator-configuration" class="aui-button" >Configure</button>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowBackupCode == true && configuredBackupCode == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredBackupCode = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div class="card" style="width: 100%;">
                    <div class="card-body">
                        <b>Backup Code (Backup Method)</b>
                        <br><br>
                        <table>
                            <tr>
                                <#--<td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img id="imgBackupCode" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>-->
                                <td>
                                    In this method, user needs to provide the Backup Code to access of Crowd.
                                    <br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <button id="backup-code-show-button" class="aui-button">Show Details</button>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowOtpOverSms == true && configuredOtpOverSms == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredOtpOverSms = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div class="card" style="width: 100%;height: 13.3em;">
                    <div class="card-body">
                        <b>OTP Over SMS</b>
                        <span class="aui-lozenge aui-lozenge-error" style="float: right;">Premium</span>
                        <br><br>
                        <table>
                            <tr>
                                </td>
                                <td>
                                    In this method, user receives an SMS containing a OTP which he/she needs to enter.
                                    <br><br>
                                </td>
                            </tr>
                        </table>
                        <#if (otpOverSmsConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="otp-over-email-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "OtpOverEmail")>
                                <button id="setOtpOverEmailAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowOtpOverEmail == true && configuredOtpOverEmail == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredOtpOverEmail = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div class="card" style="width: 100%;">
                    <div class="card-body">
                        <b>OTP Over Email</b>
                        <span class="aui-lozenge aui-lozenge-error" style="float: right;">Premium</span>
                        <br><br>
                        <table>
                            <tr>
                                <#--<td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img id="imgOtpOverEmail" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>-->
                                <td>
                                    In this method, user receives an email containing a OTP which he/she needs to enter.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (otpOverEmailConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="otp-over-email-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "OtpOverEmail")>
                                <button id="setOtpOverEmailAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowSecurityQuestion == true && configuredSecurityQuestion == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredSecurityQuestion = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div class="card" style="width: 100%;">
                    <div class="card-body">
                        <b>Security Question</b>
                        <span class="aui-lozenge aui-lozenge-error" style="float: right;">Premium</span>
                        <br><br>
                        <table>
                            <tr>
                                <#--<td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img id="imgSecurityQuestion" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>-->
                                <td>
                                    In this method, user needs to answer the security questions to get access of Crowd.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (securityQuestionConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="security-question-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "SecurityQuestion")>
                                <button id="setSecurityQuestionAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>
        <#if (loopCount < 3 && shouldShowDuoPushNotification == true && configuredDuoPushNotification == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredDuoPushNotification = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div class="card" style="width: 100%;">
                    <div class="card-body">
                        <b>Duo Push Notification</b>
                        <span class="aui-lozenge aui-lozenge-error" style="float: right;">Premium</span>
                         <#if (currentDefault2faMethod == "DuoPushNotification") >
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <!--<td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img id="imgPushNotification" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>-->
                                <td>
                                    In this method, user receives a notification on his mobile which he needs to APPROVE | DENY.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (duoPushNotificationConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="duo-push-notification-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "DuoPushNotification") >
                                <button id="setDuoPushNotificationAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>
        </div>
        <#assign count = count - 1>
    </#list>
</div>

<section id="configure-google-authenticator-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:800px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - MOBILE AUTHENTICATOR</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <form id="google-authenticator-configuration-form" class="aui" action="" method="POST">
            <#if (googleAuthenticatorConfigured == true)>
                <div class="aui-message aui-message-info" id="successMessageGoogleAuthenticator">
                    <p>
                       You have already configured Mobile Authenticator successfully.
                    </p>
                    <p>
                       You can use the below details for reconfiguring it on other device.
                    </p>
                </div>
            </#if>
            <table class="aui" style="width:100%">
                <tbody>
                    <tr>
                        <td width="45%">
                            <div id="google-authenticator-main-div">
                                <p>
                                    <b>Use below steps to configure Authenticator Application</b></br>
                                    Step 1: Download <b>Authenticator Application</b> app in your smart phone from App Store or from Google Play Store.</br></br>
                                    Step 2: To register your device scan the <b>QR code</b> or Enter <b>Secret Key</b> through <b>Mobile Authenticator</b> app.</br></br>
                                    Step 3: Enter the Passcode generated by Authenticator app.
                                </p>
                            </div>
                        </td>
                        <td width="5%"></td>
                        <td>
                            <div id="google-authenticator-secondary-div" name="google-authenticator-secondary-div">
                                <div class="aui-group" style="margin-left:25%">
                                    <img style="max-width: 150px;" src="data:image/jpg;base64,${qrcode}" />
                                </div>

                                <div class="aui-group" id="idProblemWithScanningDiv">
                                    <p><a href="#">Problems with QR Code?</a></p>
                                </div>

                                <div id="idSecretKeyDiv" class="aui-message aui-message-info" style="display:none">
                                    <p>Secret Key : <b>${secretKey}</b></p>
                                </div>

                                <div class="aui-message aui-message-info" id="auiInfoMessageDiv">
                                    <p>Scan above QR code or Enter the Secret Key  in your mobile application and Enter the valid OTP.</p>
                                </div>

                                <div class="aui-group">
                                    <label>Enter OTP</label>&nbsp;
                                    <input class="text" id="qrCodeOtp" name="qrCodeOtp" type="text" value="" autofocus required autocomplete="off"/>
                                </div>

                                <div class="aui-group" style="margin-left:35%">
                                    <input class="aui-button aui-button-primary" id="google-authenticator-form-submit" name="Validate" type="submit" value="Validate"/>
                                    <button id="google-authenticator-form-close" class="aui-button">Close</button>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
        <footer class="aui-dialog2-footer" id="showAfterSuccessGoogleAuthenticator" style="display:none">
            <div class="aui-dialog2-footer-actions">
                <button id="google-authenticator-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="configure-security-question-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:800px; max-height:800px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - SECURITY QUESTIONS</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;">
        <form id="security-question-configuration-form" class="aui" action="" method="POST">
            <#if (securityQuestionConfigured == true)>
                <div class="aui-message aui-message-info" id="successMessageSecurityQuestion">
                    <p>
                       You have already configured Security Question successfully.
                    </p>
                </div>
            </#if>

            <p>
                Select your security questions and enter their answers to setup Security Questions as your backup method for login in case you don't have access to your phone. Security Question must be unique.
            </p>
            <br>
            <#assign loopCount = 0>
            <table style="width: 100%;">
                <thead>
                    <tr>
                        <th id="question-number">#</th>
                        <th id="select-question">Question</th>
                        <th id="enter-answer">Answer</th>
                    </tr>
                </thead>
                <tbody>
                    <#foreach questionNumber in securityQuestionNumber>
                        <tr>
                            <td headers="question-number" class="table-label" style="padding-top: 10px;padding-bottom: 10px;">${questionNumber}:</td>
                            <td headers="select-question" style="padding-top: 10px;padding-bottom: 10px;">
                                <select class="select" name="question_${loopCount}" id="question_${loopCount}" class="securityquestions" required style="max-width: 100%;">
                                    <#foreach question in questionList>
                                        <option value="${question}">
                                            ${question}
                                        </option>
                                    </#foreach>
                                </select>
                            </td>
                            <td headers="enter-answer" style="padding-top: 10px;padding-bottom: 10px;">
                                <input class="text" id="answer_${loopCount}" name="answer_${loopCount}" type="text" value="" placeholder="Enter Answer" required autocomplete="off"/>
                            </td>
                        </tr>
                        <#assign loopCount = loopCount + 1>
                    </#foreach>
                    <tr>
                        <td headers="question-number" class="table-label" style="padding-top: 10px;padding-bottom: 10px;">Custom Question:</td>
                        <td headers="select-question" style="padding-top: 10px;padding-bottom: 10px;">
                            <input class="text" id="custom_question" name="custom_question" type="text" value="" placeholder="Enter Custom Question" required style="max-width: 100%;" autocomplete="off"/>
                        </td>
                        <td headers="enter-answer" style="padding-top: 10px;padding-bottom: 10px;">
                            <input class="text" id="custom_answer" name="custom_answer" type="text" value="" placeholder="Enter Custom Answer" required autocomplete="off"/>
                        </td>
                    </tr>
                </tbody>
            </table>
            <br/>
            <div style="margin-left: 81%;">
                <input class="aui-button aui-button-primary" id="otp-validate-form-submit" name="Submit" type="submit" value="Submit" resolved=""/>
                <button id="security-question-form-close" class="aui-button" resolved="">Close</button>
            </div>
        </form>

        <footer class="aui-dialog2-footer" id="showAfterSuccessSecurityQuestion" style="display:none">
            <div class="aui-dialog2-footer-actions">
                <button id="security-question-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="configure-backup-code-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:800px; max-height:800px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - BACKUP CODE</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;">
        <#if (backupCodeConfigured == true && shouldShowBackupCodeWarning == true)>
            <div class="aui-message aui-message-warning" id="warningBackupCodeUsed">
        <#else>
            <div class="aui-message aui-message-warning" id="warningBackupCodeUsed" style="display:none">
        </#if>
                <p>
                   You have used all the Backup Codes. Please click on "Change Backup Code" to generate new Backup Codes.
                </p>
            </div>

        <div class="aui-message aui-message-success" id="successMessageBackupCodeChange" style="margin-top: 0px;">
            <p>
               Successfully changed the Backup Code.
            </p>
        </div>
        <div class="aui-message aui-message-success" id="successMessageBackupCodeEnabled" style="margin-top: 0px;">
            <p>
               Successfully enable the Backup Code.
            </p>
        </div>
        <div class="aui-message aui-message-success" id="successMessageBackupCodeDisable" style="margin-top: 0px;">
            <p>
               Successfully disable the Backup Code.
            </p>
        </div>

        <form id="backup-code-configuration-form" class="aui" action="" method="POST">
            <div class="aui-message aui-message-info">
                <p>These are emergency one time backup codes that you can use to get access to your account. It can be used when you are not able to login using two factor.</p>
                <#if (backupCodeConfigured == true)>
                <div id="backup-code-enabled-info-div">
                <#else>
                <div id="backup-code-enabled-info-div" style="display:none">
                </#if>
                    <p>Click "Download Backup Code" button to download the Backup Code & click "Change Backup Code" button to change the current Backup Code.</p>
                    <p>Click "Disable Backup Code" button disable the Backup Code method for your account.</p>
                </div>

                <#if (backupCodeConfigured != true)>
                <div id="backup-code-enable-info-div">
                <#else>
                <div id="backup-code-enable-info-div" style="display:none">
                </#if>
                    <p>You haven't enabled Backup Code for your account. Please click "Enable Backup Code" button to enabled it for your account.</p>
                </div>
            </div>
            <br>
            <#if (backupCodeConfigured == true)>
            <div id="backup-code-enabled-div">
            <#else>
            <div id="backup-code-enabled-div" style="display:none">
            </#if>
                <input class="aui-button" id="backup-code-download" name="DownloadBackupCode" type="button" value="Download Backup Code" onclick="window.location.href = '${downloadBackupCodeUrl}';"/>

                <#if (allowToReconfigureMethod == true)>
                    <input class="aui-button" id="backup-code-change" name="ChangeBackupCode" type="button" value="Change Backup Code" style="margin-left: 17%;"/>
                <#else>
                    <input class="aui-button" id="backup-change" name="ChangeBackupCode" type="button" value="Change Backup Code" style="margin-left: 17%;" disabled/>
                </#if>

                <#if (allowToReconfigureMethod == true)>
                    <input class="aui-button" id="backup-code-disable" name="DisableBackupCode" type="button" value="Disable Backup Code" style="float: right;"/>
                <#else>
                    <input class="aui-button" id="backup-disable" name="DisableBackupCode" type="button" value="Disable Backup Code" style="float: right;" disabled/>
                </#if>
            </div>

            <#if (backupCodeConfigured != true)>
            <div id="backup-code-enable-div">
            <#else>
            <div id="backup-code-enable-div" style="display:none">
            </#if>
                <input class="aui-button" id="backup-code-enable" name="Enable" type="button" value="Enable Backup Code" />
            </div>
        </form>
        <hr class="header"/>
        <div class="aui-dialog2-footer-actions">
            <button id="backup-code-form-close_1" class="aui-button">Close</button>
        </div>
    </div>
</section>

<section id="configure-otp-over-email-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:400px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - OTP OVER EMAIL</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <#if (smtpConfigured == false)>
            <div class="aui-message aui-message-warning">
                <p>
                   As Crowd's mail server is not configured yet. So won't be able to enable OTP Over Email as 2FA method.
                </p>
            </div>
        <#else>
            <form id="otp-over-email-configuration-form" class="aui" action="" method="POST" >
                <div id="otp-over-email-enable-button-div">
                    <input class="aui-button" id="otp-over-email-enable" name="Enable" type="button" value="Enable OTP Over Email" />
                    <br><br>
                </div>

                <div id="otp-over-email-configuration-div" style="display:none">
                    <div class="aui-group">
                        <label>Enter OTP</label>&nbsp;
                        <input class="text" id="otpCode" name="otpCode" type="text" value="" autofocus required autocomplete="off"/>
                        <div class="aui-group" id="idResendOtpDiv">
                            <p><a href="#">Resend OTP</a></p>
                        </div>
                    </div>

                    <div class="aui-group" style="margin-left:35%">
                        <input class="aui-button aui-button-primary" id="otp-over-email-form-submit" name="Validate" type="submit" value="Validate"/>
                        <button id="otp-over-email-form-close" class="aui-button">Close</button>
                    </div>
                </div>
            </form>
        </#if>

        <footer class="aui-dialog2-footer" id="showAfterSuccessOtpOverEmail" style="display:block">
            <div class="aui-dialog2-footer-actions">
                <button id="otp-over-email-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>