<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
	        AJS.$(document).ready(function() {
	             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	             AJS.$("#ADVANCEDSETTINGS").addClass("aui-nav-selected");
	             AJS.$('input').css("box-shadow","none");
	        });
        </script>

        <style>
        	h4 {
        		display: block;
        		margin: 30px 65px 0px;
        		font-weight: bold;
        	}

            .aui-page-panel-content{
                padding: 0px !important;
            }

        	.aui-page-panel{
                margin: 0px !important;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }

        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <p style="font-size:13pt;margin-bottom: 10px">Advanced Settings</p>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>
            <hr class="header"/>

            <div id="bruteForceSettingsDiv">
                <h3>Brute Force Configuration</h3>

                <div class="field-group">
                    <#if enableBruteForceProtection == true>
                        <input type="checkbox" id="enableBruteForceProtection" value="true" name="enableBruteForceProtection"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableBruteForceProtection" value="true" name="enableBruteForceProtection"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Brute Force Protection for Crowd
                    </span>
                    <div class="description">The Enable Brute force checkbox allows you to add restrict Crowd access based on the number of Login Attempts.</div>
                </div>

                <div class="field-group">
                    <label for="bruteForceNumberOfAttempts">Number of Attempts : </label>
                    <#if enableBruteForceProtection == true>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" />
                    <#else>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Select the number of invalid login attempts to lock the user account.</div>
                </div>

                <div class="field-group">
                    <label>User Locked out Period : </label>
                    <table>
                    <tr>
                    <td>
                    <#if enableBruteForceProtection == true>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" style="width: 110px;">
                    <#else>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" disabled style="width: 110px;">
                    </#if>
                        <option value="15 minutes" <#if bruteForceTimeInterval.equals("15 minutes")>selected </#if>>15 Minutes</option>
                        <option value="30 minutes" <#if bruteForceTimeInterval.equals("30 minutes")>selected </#if>>30 Minutes</option>
                        <option value="1 hour" <#if bruteForceTimeInterval.equals("1 hour")>selected </#if>>1 Hour</option>
                        <option value="5 hours" <#if bruteForceTimeInterval.equals("5 hours")>selected </#if>>5 Hours</option>
                        <option value="1 day" <#if bruteForceTimeInterval.equals("1 day")>selected </#if>>1 Day</option>
                        <option value="7 days" <#if bruteForceTimeInterval.equals("7 days")>selected </#if>>7 Days</option>
                        <option value="custom" <#if bruteForceTimeInterval.equals("custom")>selected </#if>>Custom</option>
                    </select>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:block" <#if enableBruteForceProtection != true> disabled </#if> />
                    <#else>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:none" <#if enableBruteForceProtection != true> disabled </#if> />
                    </#if>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:block" <#if enableBruteForceProtection != true> disabled </#if>>
                    <#else>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:none" <#if enableBruteForceProtection != true> disabled </#if> >
                    </#if>
                        <option value="minutes" <#if bruteForceCustomTimeInterval.equals("minutes")>selected </#if>>Minutes</option>
                        <option value="hours" <#if bruteForceCustomTimeInterval.equals("hours")>selected </#if>>Hours</option>
                        <option value="days" <#if bruteForceCustomTimeInterval.equals("days")>selected </#if>>Days</option>
                        </select>
                    </td>
                    </tr>
                    </table>
                    <div class="description">Once this time is expired, the user will be able to login to Crowd again.</div>
                </div>
            </div>

            <br><br>
            <div id="rememberMeDeviceSettingsDiv">
                <h3>Remember My Device</h3>

                <div class="field-group">
                    <#if (enableRememberMeDevice == true)>
                        <input type="checkbox" id="enableRememberMeDevice" value="true" name="enableRememberMeDevice"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableRememberMeDevice" value="true" name="enableRememberMeDevice"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Remember My Device for Users
                    </span>
                    <div class="description">The Remember My Device checkbox allows you to ignore 2FA check if the user is trying to log in from the same device.</div>
                </div>

                <div class="field-group">
                    <label for="rememberMeDeviceDuration">Expiry Time (in Days) : </label>
                    <#if (enableRememberMeDevice == true)>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration" autofocus="true"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" />
                    <#else>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration" autofocus="true"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Once the time has expired, the device information for that user will be clear.</div>
                </div>
            </div>

            <br><br>
            <div id="advancedSettingsDiv">
                <h3>Mobile Authenticator Settings</h3>
                <div class="field-group">
                    <label for="appLabel">Mobile Authenticator Label: </label>
                    <input type="text" id="appLabel" name="appLabel" autofocus="true"
                          value="${appLabel}" class="text long-field" />
                    <div class="description">You can name the authenticator application using Label</div>
                </div>

                <div class="field-group">
                    <#if (showSupportedAppPopup == true)>
                        <input type="checkbox" id="showSupportedAppPopup" value="true" name="showSupportedAppPopup"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="showSupportedAppPopup" value="true" name="showSupportedAppPopup"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Show supported mobile app popup directly during inline registration
                    </span>
                    <div class="description">If enabled, it will show the supported mobile app popup directly to the user during inline registration.</div>
                </div>
            </div>

            <hr class="header"/>
            <div id="otpOverEmailSettingsDiv">
                <h4>OTP Over Email Settings</h4>

                <#if (smtpConfigured == false)>
                    <div class="field-group">
                        <div class="aui-message aui-message-warning">
                            <p class="title">
                                <strong>Warning!</strong>
                            </p>
                            <p>As Confluence's mail server is not configured yet. So add-on will not send any mails. You need to configure Confluence's mail server to do this.
                            </p>
                        </div>
                    </div>
                </#if>

                <div class="field-group">
                    <label for="emailTemplate">Email Template : </label>
                    <textarea name="emailTemplate" class="textarea long-field"
                        style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${emailTemplate}</textarea>
                    <div class="description">You need to write <b>$$username$$</b> and <b>$$otp$$</b> where you wish to place username & generated otp in this template respectively.</div>
                </div>

                <div class="field-group">
                    <label for="otpLength">OTP Length : </label>
                    <input type="number" id="otpLength" name="otpLength"
                          value="${otpLength}" class="text" min="4" max="8" style="width: 80px;" />
                    <div class="description">Enter the length of OTP. (The OTP length can vary from 4 to 8 characters)</div>
                </div>

                <div class="field-group">
                    <label for="otpValidityDuration">OTP Validity Duration (In Minutes) : </label>
                    <input type="number" id="otpValidityDuration" name="otpValidityDuration"
                          value="${otpValidityDuration}" class="text" min="1" max="10" style="width: 80px;" />
                    <div class="description">Once the time has expired, the OTP will consider as a Invalid.</div>
                </div>
            </div>

            <br><br>
            <div class="field-group">
                </br>
                <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
            </div>
        </form>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>