/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorLoginFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorLoginFilter.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorLoginFilter(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor())) {
            List<String> blacklistIpAddresses;
            LOGGER.debug("MoTwoFactorLoginFilter doFilter called..................");
            HttpServletResponse res = (HttpServletResponse)response;
            HttpServletRequest req = (HttpServletRequest)request;
            String os_destination = req.getParameter("os_destination");
            if (StringUtils.isNotBlank((CharSequence)os_destination)) {
                LOGGER.debug("os_destination : " + os_destination);
                String return_to = os_destination.contains(this.pluginConfiguration.getBaseUrl()) ? os_destination : this.pluginConfiguration.getBaseUrl().concat(os_destination);
                LOGGER.debug("return_to : " + return_to);
                Cookie cookie = MoTwoFactorUtility.createCookie(req.getRequestURL().toString(), "CROWD_RETURNTOCOOKIE", return_to, false);
                res.addCookie(cookie);
            }
            if (BooleanUtils.toBoolean((Boolean)this.shouldIgnoreUrl(req))) {
                LOGGER.debug("Executing the default flow");
                chain.doFilter(request, response);
                return;
            }
            Cookie isUserLockedSet = MoTwoFactorUtility.getCookie("ENDSESSION", req);
            if (isUserLockedSet != null && StringUtils.equalsIgnoreCase((CharSequence)isUserLockedSet.getValue(), (CharSequence)"ShowContactAdminTemplate")) {
                LOGGER.debug("Redirecting user to Contact Admin URL");
                MoTwoFactorUtility.clearCookie(req, res, "ENDSESSION");
                res.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/contact_admin"));
                return;
            }
            String username = this.pluginConfiguration.getCurrentLoggedInUser();
            if (StringUtils.isNotBlank((CharSequence)username) && BooleanUtils.toBoolean((Boolean)this.settings.getEnableBruteForceProtection())) {
                LOGGER.debug("Checking for Locking of user");
                String path = req.getRequestURI();
                if (path.contains("/twofactor/user_locked")) {
                    LOGGER.debug("Is User Locked Template URL called");
                    chain.doFilter(request, response);
                    return;
                }
                Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
                if (lockedUserDetails.size() > 0 && lockedUserDetails.containsKey(username) && this.pluginHandler.isUserLocked(username).booleanValue()) {
                    LOGGER.debug("Redirecting user to Temporary Locked URL");
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                    chain.doFilter(request, response);
                    return;
                }
            }
            if ((blacklistIpAddresses = this.settings.getBlacklistIpAddresses()).size() > 0) {
                LOGGER.debug("Considering Blacklist IP check");
                String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(req);
                Boolean isBlacklistIp = this.pluginHandler.isInStoredIpAddress(currentIpAddress, blacklistIpAddresses);
                if (BooleanUtils.toBoolean((Boolean)isBlacklistIp)) {
                    LOGGER.debug("IP is in Blacklist IP");
                    String path = req.getRequestURI();
                    LOGGER.debug("Path : " + path);
                    if (path.contains("/twofactor/access_denied")) {
                        LOGGER.debug("Is Access Denied Template URL called");
                        chain.doFilter(request, response);
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)username)) {
                        this.pluginHandler.performUserLogout(res, username);
                    }
                    LOGGER.debug("Redirecting user to Access Denied URL");
                    res.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/access_denied"));
                    return;
                }
            }
            if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldConsiderMo2FA(username, req, res))) {
                LOGGER.debug("Considering 2FA for user : " + username);
                HttpSession session = req.getSession(true);
                Cookie returnToCookie = MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", req);
                if (returnToCookie != null && StringUtils.isNotBlank((CharSequence)returnToCookie.getValue())) {
                    LOGGER.debug("Return To : " + returnToCookie.getValue());
                    session.setAttribute("Referer", (Object)returnToCookie.getValue());
                } else {
                    String referer = req.getHeader("referer");
                    LOGGER.debug("Referer : " + referer);
                    if (referer != null && !referer.contains("userlogin") && referer.contains(this.pluginConfiguration.getBaseUrl())) {
                        session.setAttribute("Referer", (Object)referer);
                    }
                }
                String url = this.pluginHandler.findValidUrlToRedirect(username, req);
                session.setAttribute("executing_2fa_flow", (Object)Boolean.TRUE);
                res.sendRedirect(url);
                return;
            }
        }
        LOGGER.debug("Executing the default flow");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean shouldIgnoreUrl(HttpServletRequest req) {
        String path = req.getRequestURI();
        LOGGER.debug("Current URL : " + path);
        return StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/download/") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/images/") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/favicon.ico") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/rest/") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/unlockuser") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/console/logoff.action") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/userlogout") || StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/twofactor/contact_admin");
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

