/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorCrowdfreePluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationBackupCode
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationBackupCode.class);
    private static final String BACKUPMETHOD_VM_PATH = "/templates/com/miniorange/twofactor/crowdfree/inlineregistration_backupcode.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdfreePluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationBackupCode(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationBackupCode doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_BackupCode").booleanValue()) {
            HttpSession session = request.getSession();
            String referer = request.getHeader("referer");
            if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/twofactor/") || session.getAttribute("executing_2fa_flow").equals(Boolean.TRUE)) {
                LOGGER.debug("2FA is Configured successfully");
                UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
                String displayName = userProfile.getFullName();
                if (StringUtils.isBlank((CharSequence)displayName)) {
                    displayName = username;
                }
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("username", displayName);
                context.put("errorMessage", new ArrayList());
                context.put("downloadBackupCodeUrl", this.pluginConfiguration.getDownloadBackupCodeUrl());
                List<String> backupCodes = this.pluginHandler.generateBackupCode();
                context.put("backupCodes", backupCodes);
                MoTwoFactorCommonUserSettings userSettings = this.settings.getUserSettings(username);
                userSettings.setConfigured2FAMethodsByUser("BackupCode");
                userSettings.setBackupCodes(this.pluginHandler.encodeBackupCode(backupCodes));
                this.settings.setUserSettings(username, userSettings);
                this.settings.addTo2FAConfiguredUsersList(username);
                session.removeAttribute("considering_backup_method");
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                String template = this.pluginSettings.getConfigureBackupCodeTemplate();
                if (StringUtils.isNotBlank((CharSequence)template)) {
                    String result = this.renderer.renderFragment(template, context);
                    response.setContentType("text/html;charset=utf-8");
                    response.getWriter().write(result);
                    return;
                }
                response.setContentType("text/html;charset=utf-8");
                this.renderer.render(BACKUPMETHOD_VM_PATH, context, (Writer)response.getWriter());
                return;
            }
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationBackupCode doPost called");
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdfreePluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

