/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorCrowdfreePluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistration
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistration.class);
    private static final String INLINEREGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowdfree/inlineregistration_showinfo.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdfreePluginSettings pluginSettings;

    public MoTwoFactorInlineRegistration(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistration doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            LOGGER.debug("username::" + username);
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                LOGGER.debug("displayName::" + displayName);
                displayName = username;
            }
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            String nextPageUrl = "";
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser())) {
                LOGGER.debug("inside IF condition");
                String method = this.settings.getPrimary2faMethodForUser();
                LOGGER.debug("Enforce Primary method is selected : " + method);
                if (method.equalsIgnoreCase("GoogleAuthenticator")) {
                    LOGGER.debug("1");
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
                } else if (method.equalsIgnoreCase("OtpOverEmail")) {
                    LOGGER.debug("2");
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
                } else if (method.equalsIgnoreCase("SecurityQuestion")) {
                    LOGGER.debug("3");
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
                }
            } else {
                LOGGER.debug("inside else condition");
                List<String> methodsForUser = this.settings.get2FAMethodForUserList();
                if (methodsForUser.size() > 1) {
                    LOGGER.debug("method for user > 1");
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2famethodlist");
                } else {
                    LOGGER.debug("indide else 2");
                    if (methodsForUser.contains("GoogleAuthenticator")) {
                        LOGGER.debug("mobile otp");
                        nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
                    } else if (methodsForUser.contains("OtpOverEmail")) {
                        nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
                    } else if (methodsForUser.contains("SecurityQuestion")) {
                        nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
                    }
                }
            }
            LOGGER.debug("112233");
            context.put("nextPage", nextPageUrl);
            LOGGER.debug("nextPage::" + nextPageUrl);
            String template = this.pluginSettings.getWelcomeMessageTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                LOGGER.debug("template");
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                LOGGER.debug("before return");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(INLINEREGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdfreePluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

