/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorConfigure2FAByUser
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorConfigure2FAByUser.class);
    private static final String CONFIGURE_2FA_BY_USER_VM_PATH = "/templates/com/miniorange/twofactor/crowdfree/configure2fabyuser.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private UserManager userManager;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private String qrcode;
    private String secretKey;

    public MoTwoFactorConfigure2FAByUser(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, UserManager userManager, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.userManager = userManager;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorConfigure2FAByUser doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.canAccessPage(request)) {
            UserProfile user = this.userManager.getUserProfile(username);
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser();
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> methodsConfiguredByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
            this.initializeQrCode(request, twoFactorUserClass);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", username);
            context.put("enableTwoFactor", BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor()));
            context.put("qrcode", this.qrcode);
            context.put("secretKey", this.secretKey);
            context.put("googleAuthenticatorConfigured", methodsConfiguredByUser.contains("GoogleAuthenticator"));
            context.put("otpOverEmailConfigured", methodsConfiguredByUser.contains("OtpOverEmail"));
            context.put("securityQuestionConfigured", methodsConfiguredByUser.contains("SecurityQuestion"));
            context.put("backupCodeConfigured", methodsConfiguredByUser.contains("BackupCode"));
            List<String> methodForUserList = this.settings.get2FAMethodForUserList();
            List<String> backupMethodForUser = this.settings.getBackupMethodForUserList();
            Boolean shouldShowGoogleAuthenticator = this.userManager.isAdmin(user.getUserKey()) || this.userManager.isSystemAdmin(user.getUserKey()) || BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor()) && methodForUserList.contains("GoogleAuthenticator") || methodsConfiguredByUser.contains("GoogleAuthenticator");
            context.put("shouldShowGoogleAuthenticator", shouldShowGoogleAuthenticator);
            Boolean shouldShowBackupCode = BooleanUtils.toBoolean((Boolean)this.settings.getEnableBackupMethod()) && backupMethodForUser.contains("BackupCode");
            context.put("shouldShowBackupCode", shouldShowBackupCode);
            context.put("shouldShowBackupCodeWarning", shouldShowBackupCode != false && twoFactorUserClass.getBackupCodes().size() == 0);
            int totalConfiguredMethods = 0;
            if (BooleanUtils.toBoolean((Boolean)shouldShowGoogleAuthenticator)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowBackupCode)) {
                ++totalConfiguredMethods;
            }
            context.put("totalConfiguredMethods", totalConfiguredMethods);
            context.put("totalMethodsConfiguredByUser", methodsConfiguredByUser);
            context.put("securityQuestionNumber", this.getSecurityQuestionNumber());
            context.put("downloadBackupCodeUrl", this.pluginConfiguration.getDownloadBackupCodeUrl());
            context.put("backupCodeConfigured", methodsConfiguredByUser.contains("BackupCode"));
            context.put("questionList", MoTwoFactorUtility.getQuestionList());
            context.put("is2faEnabled", this.settings.getEnable2FAForUsersList().contains(username));
            context.put("userFullName", userProfile.getFullName());
            context.put("emailAddress", userProfile.getEmail());
            context.put("rememberMeDeviceDetails", twoFactorUserClass.getRememberMeDeviceDetails());
            if (twoFactorUserClass.getRememberMeDeviceDetails().size() > 0) {
                context.put("rememberMeDeviceDetailsMap", this.generateRememberMeDeviceDetailsMap(twoFactorUserClass.getRememberMeDeviceDetails()));
            }
            context.put("currentDefault2faMethod", twoFactorUserClass.getCurrent2FAMethod());
            context.put("allowToReconfigureMethod", this.settings.getAllowToReconfigureConfigured2faMethod());
            context.put("enableEnforceCurrentMethod", this.settings.getEnableEnforce2faMethodForUser());
            context.put("contextpath", this.pluginConfiguration.getBaseUrl());
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(CONFIGURE_2FA_BY_USER_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    private boolean canAccessPage(HttpServletRequest req) {
        HttpSession session = req.getSession();
        return !BooleanUtils.toBoolean((Boolean)((Boolean)session.getAttribute("executing_2fa_flow")));
    }

    private Map<String, List<String>> generateRememberMeDeviceDetailsMap(List<String> rememberMeDeviceDetails) {
        TreeMap<String, List<String>> rememberMeDeviceDetailsMap = new TreeMap<String, List<String>>();
        LOGGER.debug("rememberMeDeviceDetails : " + rememberMeDeviceDetails);
        for (String deviceDetails : rememberMeDeviceDetails) {
            LinkedList<String> mapValues = new LinkedList<String>();
            String osName = deviceDetails.split("=====")[0].trim().split("\\|\\|")[2].trim();
            String browserName = deviceDetails.split("=====")[0].trim().split("\\|\\|")[1].trim();
            String expiryDate = new Date(Long.parseLong(deviceDetails.split("=====")[1].trim())).toString();
            mapValues.add(osName);
            mapValues.add(browserName);
            mapValues.add(expiryDate);
            rememberMeDeviceDetailsMap.put(deviceDetails, mapValues);
        }
        return rememberMeDeviceDetailsMap;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    private void initializeQrCode(HttpServletRequest request, MoTwoFactorCommonUserSettings twoFactorUserClass) {
        String crowdInstanceKeyValue;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        this.secretKey = MoTwoFactorUtility.generateKey();
        HttpSession session = request.getSession();
        if (session.getAttribute("2fa_secret") == null || StringUtils.isBlank((CharSequence)((String)session.getAttribute("2fa_secret")))) {
            session.setAttribute("2fa_secret", (Object)this.secretKey);
        } else {
            this.secretKey = (String)session.getAttribute("2fa_secret");
        }
        this.qrcode = MoTwoFactorUtility.generateQrCode(this.secretKey, username, this.settings.getAppLabel("Crowd"));
        session.setAttribute("2fa_qrcode", (Object)this.qrcode);
        if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(userSpecific_salt_key);
            this.settings.setUserSettings(username, twoFactorUserClass);
        }
        if (StringUtils.isEmpty((CharSequence)(crowdInstanceKeyValue = this.settings.getEncryptionKey()))) {
            String crowd_instance_key = MoTwoFactorUtility.generateRandomString(10);
            this.settings.setEncryptionKey(crowd_instance_key);
        }
    }

    private List<String> getSecurityQuestionNumber() {
        int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }
}

