/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorConfigure2FA
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorConfigure2FA.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;

    public MoTwoFactorConfigure2FA(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method;
        switch (method = req.getParameter("method")) {
            case "GoogleAuthenticator": {
                this.configureGoogleAuthenticator(req, resp);
                break;
            }
            case "SecurityQuestion": {
                this.configureSecurityQuestion(req, resp);
                break;
            }
            case "OtpOverEmail": {
                this.configureOtpOverEmail(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                resp.sendError(405, "The requested method is not allowed. Choose valid Method");
                return;
            }
        }
    }

    private void configureOtpOverEmail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureSecurityQuestion");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            HttpSession session;
            String storedOtpCode;
            Boolean isValid = Boolean.FALSE;
            String errorMessage = "";
            String otp = StringUtils.trimToEmpty((String)req.getParameter("otp"));
            if (StringUtils.equalsIgnoreCase((CharSequence)otp, (CharSequence)(storedOtpCode = (String)(session = req.getSession(true)).getAttribute("otp_code")))) {
                long storedOtpExpiryTime;
                long currentTimeInMili = System.currentTimeMillis();
                if (currentTimeInMili < (storedOtpExpiryTime = ((Long)session.getAttribute("otp_expiry_time")).longValue())) {
                    isValid = Boolean.TRUE;
                } else {
                    isValid = Boolean.FALSE;
                    errorMessage = "Time Expires.";
                }
            } else {
                isValid = Boolean.FALSE;
                errorMessage = "Invalid OTP Entered";
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                session.removeAttribute("otp_code");
                session.removeAttribute("otp_expiry_time");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
                twoFactorUserClass.setConfigured2FAMethodsByUser("OtpOverEmail");
                if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"OtpOverEmail")) {
                    twoFactorUserClass.setCurrent2FAMethod("OtpOverEmail");
                } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    twoFactorUserClass.setCurrent2FAMethod("OtpOverEmail");
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
                this.sendSuccessFullResponse("OTP Over Email Added", resp);
            } else {
                LOGGER.debug("Error : " + errorMessage);
                this.sendErrorResponse(errorMessage, resp);
            }
        } else {
            this.sendErrorResponse("User is not logged in", resp);
            return;
        }
    }

    private void configureSecurityQuestion(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureSecurityQuestion");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
            TreeMap<String, String> securityQuestionAnswer = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            Boolean isValid = Boolean.TRUE;
            String errorMessage = "";
            for (int i = 0; i < securityQuestionCount; ++i) {
                if (req.getParameter("question_" + i) == null || req.getParameter("answer_" + i) == null) {
                    errorMessage = "EMPTY";
                    isValid = Boolean.FALSE;
                    break;
                }
                String key = req.getParameter("question_" + i).trim();
                String value = req.getParameter("answer_" + i).trim();
                if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)value) && !StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Select Security Question")) {
                    if (BooleanUtils.toBoolean((Boolean)securityQuestionAnswer.containsKey(key))) {
                        errorMessage = "DUPLICATE";
                        isValid = Boolean.FALSE;
                        continue;
                    }
                    try {
                        value = MoTwoFactorUtility.hashString(value.toLowerCase());
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                        isValid = Boolean.FALSE;
                        break;
                    }
                    securityQuestionAnswer.put(key, value);
                    continue;
                }
                errorMessage = "EMPTY";
                isValid = Boolean.FALSE;
                break;
            }
            if (req.getParameter("custom_question") == null || req.getParameter("custom_answer") == null) {
                errorMessage = "EMPTY";
                isValid = Boolean.FALSE;
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                String key = req.getParameter("custom_question").trim();
                String value = req.getParameter("custom_answer").trim();
                LOGGER.debug("hash Custom Question Value " + value);
                if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)value)) {
                    if (BooleanUtils.toBoolean((Boolean)securityQuestionAnswer.containsKey(key))) {
                        errorMessage = "DUPLICATE";
                        isValid = Boolean.FALSE;
                    } else {
                        try {
                            value = MoTwoFactorUtility.hashString(value.toLowerCase());
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        securityQuestionAnswer.put(key, value);
                    }
                } else {
                    errorMessage = "EMPTY";
                    isValid = Boolean.FALSE;
                }
            }
            if (BooleanUtils.toBoolean((Boolean)isValid)) {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Details Before Save : " + twoFactorUserClass.toString());
                twoFactorUserClass.setSecurityQuestionAnswer(securityQuestionAnswer);
                twoFactorUserClass.setConfigured2FAMethodsByUser("SecurityQuestion");
                if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"SecurityQuestion")) {
                    twoFactorUserClass.setCurrent2FAMethod("SecurityQuestion");
                } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    twoFactorUserClass.setCurrent2FAMethod("SecurityQuestion");
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                LOGGER.debug("Details After Save : " + twoFactorUserClass.toString());
                this.sendSuccessFullResponse("Security Question Added", resp);
            } else {
                this.sendErrorResponse(errorMessage, resp);
            }
        } else {
            this.sendErrorResponse("User is not logged in", resp);
            return;
        }
    }

    private void configureGoogleAuthenticator(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling configureGoogleAuthenticator");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String otp = StringUtils.trimToEmpty((String)req.getParameter("otp"));
            LOGGER.debug("Received OTP : " + otp);
            if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                LOGGER.debug("OTP is Valid = " + otp);
                Long otp_cast = Long.parseLong(otp);
                HttpSession session = req.getSession(true);
                String secret = (String)session.getAttribute("2fa_secret");
                MoTwoFactorUtility moTwoFactorUtility = new MoTwoFactorUtility();
                Long time = moTwoFactorUtility.get_interval_time();
                Boolean is_otp_valid = false;
                try {
                    LOGGER.debug("OTP cast : " + otp_cast);
                    is_otp_valid = moTwoFactorUtility.code_verification(secret, otp_cast, time);
                    LOGGER.debug("IS OTP VALID After 2fa : " + is_otp_valid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    is_otp_valid = false;
                }
                if (BooleanUtils.toBoolean((Boolean)is_otp_valid)) {
                    MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                    List<String> configured2FAMethodsByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
                    configured2FAMethodsByUser.add("GoogleAuthenticator");
                    twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAMethodsByUser);
                    if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getPrimary2faMethodForUser(), (CharSequence)"GoogleAuthenticator")) {
                        twoFactorUserClass.setCurrent2FAMethod("GoogleAuthenticator");
                    } else if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                        twoFactorUserClass.setCurrent2FAMethod("GoogleAuthenticator");
                    }
                    LOGGER.debug("OTP validated Successfully...");
                    String userSalt = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getUserSalt(), (CharSequence)"");
                    String secretWithSalt = "";
                    if (StringUtils.isNotBlank((CharSequence)userSalt)) {
                        secretWithSalt = secret + userSalt;
                        String encryptedString = MoTwoFactorUtility.encryptString(secretWithSalt, this.settings.getEncryptionKey());
                        LOGGER.debug("Encrypted String " + encryptedString);
                        secret = encryptedString;
                    }
                    twoFactorUserClass.setTotpSecret(secret);
                    this.settings.addTo2FAConfiguredUsersList(username);
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    if (!configuredUser.contains(username)) {
                        configuredUser.add(username);
                        this.settings.setListOf2FAConfiguredUsers(configuredUser);
                    }
                    this.sendSuccessFullResponse("Configured Mobile Authenticator", resp);
                    return;
                }
            }
            this.sendErrorResponse("Issue with Configuring Mobile Authenticator", resp);
            return;
        }
        this.sendErrorResponse("User is not logged in", resp);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

