/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorTroubleshootingAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorTroubleshootingAction.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private HttpServletRequest request;

    public MoTwoFactorTroubleshootingAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        LOGGER.info("Configure Action doValidate callled.");
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorTroubleshootingAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info("Configure Action doExecute called. ");
                return "success";
            }
            catch (PluginException e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

