/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorSettingsAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorSettingsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private Boolean settingsSubmitted;
    private String xsrfToken;
    private Boolean enableTwoFactor;
    private String enableTwoFactorString;
    private Boolean enableBackupMethod;
    private String setQR;
    private String[] backupMethodForUser;
    private List<String> backupMethodForUserList;
    private String[] twoFactorMethodForUser;
    private List<String> twoFactorMethodForUserList;
    private String qrcode;
    private String secretKey;
    private Boolean googleAuthenticatorConfigured;
    private Boolean securityQuestionConfigured;
    private Boolean duoPushNotificationConfigured;
    private List<String> questionList;
    private Integer total2faEnabledUsers;
    private Boolean backupCodeConfigured;
    private Boolean shouldShowBackupCodeWarning;
    private Boolean smtpConfigured;
    private Boolean otpOverEmailConfigured;
    private String otpOverEmailConfiguredString;
    private Boolean otpOverSmsConfigured;
    private int totalConfiguredMethods = 6;
    private Integer totalMethodsConfiguredByUser;
    private String currentDefault2faMethod;
    private Boolean allowToReconfigureMethod;
    private Boolean enableEnforceCurrentMethod;
    private Boolean showAllConfiguredMethodsDirectly;
    private String primaryMethodForUser;
    private String downloadBackupCodeUrl;
    private String appLabel = "Crowd";
    private HttpServletRequest request;

    public MoTwoFactorSettingsAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public Boolean doValidate() {
        LOGGER.debug("Configure Action doValidate");
        Boolean hasError = Boolean.FALSE;
        ArrayList twoFactorMethodForUserList = new ArrayList();
        if (this.getEnableTwoFactor() == Boolean.TRUE) {
            this.setAllowToReconfigureMethod(Boolean.TRUE);
            String[] twoFactorMethodForUserArray = new String[]{"GoogleAuthenticator"};
            this.setTwoFactorMethodForUser(twoFactorMethodForUserArray);
        } else if (this.getEnableTwoFactor() == Boolean.FALSE) {
            this.settings.setEnable2FAForAllUsers(Boolean.FALSE);
        }
        if (BooleanUtils.toBoolean((Boolean)this.enableEnforceCurrentMethod) && twoFactorMethodForUserList.size() != 0 && !twoFactorMethodForUserList.contains(this.primaryMethodForUser)) {
            this.addActionError("Please select the valid Primary method. It should be from 2FA methods For User method.");
            hasError = Boolean.TRUE;
        }
        if (BooleanUtils.toBoolean((Boolean)this.enableBackupMethod)) {
            this.setAllowToReconfigureMethod(Boolean.TRUE);
            String[] backupMethodForUserArray = new String[]{"BackupCode"};
            this.setBackupMethodForUser(backupMethodForUserArray);
            if (this.backupMethodForUser == null) {
                this.addActionError("Please select valid Backup method for user");
                hasError = Boolean.TRUE;
            } else if (this.backupMethodForUser.length == 0) {
                this.addActionError("Please select valid Backup method for user");
                hasError = Boolean.TRUE;
            } else {
                LinkedList<String> backupMethodList = new LinkedList<String>();
                for (String method : this.backupMethodForUser) {
                    backupMethodList.add(method);
                }
                if (backupMethodList.contains("OtpOverEmail") && !this.pluginHandler.isSmtpConfigured().booleanValue()) {
                    this.addActionError("As SMTP is not configured, won't be able to enable OTP Over Email.");
                    hasError = Boolean.TRUE;
                }
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.enableBackupMethod) && twoFactorMethodForUserList.size() > 0 && this.backupMethodForUser != null) {
            for (String method : this.backupMethodForUser) {
                if (!twoFactorMethodForUserList.contains(method)) continue;
                this.addActionError("Same method is selected for 2FA methods For User & Backup Method for user. It should not contains same method.");
                hasError = Boolean.TRUE;
                break;
            }
        }
        return hasError;
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorSettingsAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("reset"), (CharSequence)"success")) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"GoogleAuthenticator")) {
                        this.addActionMessage("Mobile Authenticator is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"OtpOverEmail")) {
                        this.addActionMessage("OTP Over Email is removed. Now you can reconfigure it again.");
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)this.request.getParameter("method"), (CharSequence)"SecurityQuestion")) {
                        this.addActionMessage("Security Question is removed. Now you can reconfigure it again.");
                    }
                }
                if (BooleanUtils.toBoolean((Boolean)this.settingsSubmitted) && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
                    this.twoFactorMethodForUserList = new ArrayList<String>();
                    if (this.twoFactorMethodForUser != null) {
                        for (String method : this.twoFactorMethodForUser) {
                            this.twoFactorMethodForUserList.add(method);
                        }
                    }
                    LOGGER.debug("twoFactorMethodForUserList : " + this.twoFactorMethodForUserList);
                    this.backupMethodForUserList = new ArrayList<String>();
                    if (this.backupMethodForUser != null) {
                        for (String backupMethod : this.backupMethodForUser) {
                            this.backupMethodForUserList.add(backupMethod);
                        }
                    }
                    LOGGER.debug("Backup Method : " + this.backupMethodForUserList);
                    if (!BooleanUtils.toBoolean((Boolean)this.enableBackupMethod)) {
                        for (String method : this.twoFactorMethodForUserList) {
                            this.backupMethodForUserList.removeAll(Collections.singleton(method));
                        }
                        LOGGER.debug("backup Method After remove : " + this.backupMethodForUserList);
                    }
                    this.pluginHandler.save2FASettings(this.enableTwoFactor, this.enableBackupMethod, this.backupMethodForUserList, this.twoFactorMethodForUserList, this.allowToReconfigureMethod, this.enableEnforceCurrentMethod, this.primaryMethodForUser, this.showAllConfiguredMethodsDirectly, this.appLabel);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings Updated");
                }
                this.initializeConfig();
                return "success";
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        LOGGER.debug("inside initializeConfig...");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        this.initializeQrCode(twoFactorUserClass);
        this.enableTwoFactor = this.settings.getEnableTwoFactor();
        this.enableBackupMethod = this.settings.getEnableBackupMethod();
        this.backupMethodForUserList = this.settings.getBackupMethodForUserList();
        this.twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
        this.googleAuthenticatorConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator");
        this.otpOverSmsConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverSms");
        this.otpOverEmailConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverEmail");
        this.smtpConfigured = this.pluginHandler.isSmtpConfigured();
        this.securityQuestionConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("SecurityQuestion");
        this.duoPushNotificationConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("DuoPushNotification");
        this.backupCodeConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode");
        this.shouldShowBackupCodeWarning = this.backupCodeConfigured != false && twoFactorUserClass.getBackupCodes().size() == 0;
        this.questionList = this.getQuestionList();
        this.total2faEnabledUsers = this.settings.getEnable2FAForUsersList().size();
        this.totalMethodsConfiguredByUser = twoFactorUserClass.getConfigured2FAMethodsByUser().size();
        this.allowToReconfigureMethod = this.settings.getAllowToReconfigureConfigured2faMethod();
        this.enableEnforceCurrentMethod = this.settings.getEnableEnforce2faMethodForUser();
        this.primaryMethodForUser = this.settings.getPrimary2faMethodForUser();
        this.showAllConfiguredMethodsDirectly = this.settings.getShowAllConfiguredMethodToUser();
        this.enableTwoFactorString = this.convertBooleanToString(this.enableTwoFactor);
        this.downloadBackupCodeUrl = this.pluginConfiguration.getDownloadBackupCodeUrl();
        this.appLabel = this.settings.getAppLabel("Crowd");
        if (this.enableEnforceCurrentMethod.booleanValue() && twoFactorUserClass.getConfigured2FAMethodsByUser().contains(this.primaryMethodForUser) && !StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)this.primaryMethodForUser)) {
            twoFactorUserClass.setCurrent2FAMethod(this.primaryMethodForUser);
            this.settings.setUserSettings(username, twoFactorUserClass);
        }
        this.currentDefault2faMethod = twoFactorUserClass.getCurrent2FAMethod();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getSettingsSubmitted() {
        return this.settingsSubmitted;
    }

    public void setSettingsSubmitted(Boolean settingsSubmitted) {
        this.settingsSubmitted = settingsSubmitted;
    }

    public Boolean getEnableTwoFactor() {
        return this.enableTwoFactor;
    }

    public void setEnableTwoFactor(Boolean enableTwoFactor) {
        this.enableTwoFactor = enableTwoFactor;
    }

    public Boolean getEnableBackupMethod() {
        return this.enableBackupMethod;
    }

    public void setEnableBackupMethod(Boolean enableBackupMethod) {
        this.enableBackupMethod = enableBackupMethod;
    }

    public String getSetQR() {
        return this.setQR;
    }

    public void setSetQR(String setQR) {
        this.setQR = setQR;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String[] getBackupMethodForUser() {
        return this.backupMethodForUser;
    }

    public void setBackupMethodForUser(String[] backupMethodForUser) {
        this.backupMethodForUser = backupMethodForUser;
    }

    public List<String> getBackupMethodForUserList() {
        return this.backupMethodForUserList;
    }

    public void setBackupMethodForUserList(List<String> backupMethodForUserList) {
        this.backupMethodForUserList = backupMethodForUserList;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public Boolean getGoogleAuthenticatorConfigured() {
        return this.googleAuthenticatorConfigured;
    }

    public void setGoogleAuthenticatorConfigured(Boolean googleAuthenticatorConfigured) {
        this.googleAuthenticatorConfigured = googleAuthenticatorConfigured;
    }

    public Boolean getSecurityQuestionConfigured() {
        return this.securityQuestionConfigured;
    }

    public void setSecurityQuestionConfigured(Boolean securityQuestionConfigured) {
        this.securityQuestionConfigured = securityQuestionConfigured;
    }

    public List<String> getSecurityQuestionNumber() {
        int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    public List<String> getQuestionList() {
        this.questionList = MoTwoFactorUtility.getQuestionList();
        return this.questionList;
    }

    public void setQuestionList(List<String> questionList) {
        this.questionList = questionList;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Integer getTotal2faEnabledUsers() {
        return this.total2faEnabledUsers;
    }

    public void setTotal2faEnabledUsers(Integer total2faEnabledUsers) {
        this.total2faEnabledUsers = total2faEnabledUsers;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    private void initializeQrCode(MoTwoFactorCommonUserSettings twoFactorUserClass) {
        String crowdInstanceKeyValue;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        this.secretKey = MoTwoFactorUtility.generateKey();
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session.getAttribute("2fa_secret") == null || StringUtils.isBlank((CharSequence)((String)session.getAttribute("2fa_secret")))) {
            session.setAttribute("2fa_secret", (Object)this.secretKey);
        } else {
            this.secretKey = (String)session.getAttribute("2fa_secret");
        }
        this.qrcode = MoTwoFactorUtility.generateQrCode(this.secretKey, username, this.settings.getAppLabel("Crowd"));
        session.setAttribute("2fa_qrcode", (Object)this.qrcode);
        if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(userSpecific_salt_key);
        }
        if (StringUtils.isEmpty((CharSequence)(crowdInstanceKeyValue = this.settings.getEncryptionKey()))) {
            String crowd_instance_key = MoTwoFactorUtility.generateRandomString(10);
            this.settings.setEncryptionKey(crowd_instance_key);
        }
        this.settings.setUserSettings(username, twoFactorUserClass);
        session.setAttribute("2fa_verification", (Object)true);
    }

    public Integer getTotalConfiguredMethods() {
        return this.totalConfiguredMethods;
    }

    public Boolean getShouldShowSecurityQuestion() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowBackupCode() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowOtpOverEmail() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowOtpOverSms() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowGoogleAuthenticator() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowDuoPushNotification() {
        return Boolean.TRUE;
    }

    public Boolean getDuoPushNotificationConfigured() {
        return this.duoPushNotificationConfigured;
    }

    public void setDuoPushNotificationConfigured(Boolean duoPushNotificationConfigured) {
        this.duoPushNotificationConfigured = duoPushNotificationConfigured;
    }

    public String getEnableTwoFactorString() {
        return this.enableTwoFactorString;
    }

    public void setEnableTwoFactorString(String enableTwoFactorString) {
        this.enableTwoFactorString = enableTwoFactorString;
    }

    private String convertBooleanToString(Boolean booleanValue) {
        if (BooleanUtils.toBoolean((Boolean)booleanValue)) {
            return "true";
        }
        return "false";
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Boolean getBackupCodeConfigured() {
        return this.backupCodeConfigured;
    }

    public void setBackupCodeConfigured(Boolean backupCodeConfigured) {
        this.backupCodeConfigured = backupCodeConfigured;
    }

    public Boolean getShouldShowBackupCodeWarning() {
        return this.shouldShowBackupCodeWarning;
    }

    public void setShouldShowBackupCodeWarning(Boolean shouldShowBackupCodeWarning) {
        this.shouldShowBackupCodeWarning = shouldShowBackupCodeWarning;
    }

    public void setTotalConfiguredMethods(int totalConfiguredMethods) {
        this.totalConfiguredMethods = totalConfiguredMethods;
    }

    public void setDownloadBackupCodeUrl(String downloadBackupCodeUrl) {
        this.downloadBackupCodeUrl = downloadBackupCodeUrl;
    }

    public String getDownloadBackupCodeUrl() {
        return this.downloadBackupCodeUrl;
    }

    public Integer getTotalMethodsConfiguredByUser() {
        return this.totalMethodsConfiguredByUser;
    }

    public void setTotalMethodsConfiguredByUser(Integer totalMethodsConfiguredByUser) {
        this.totalMethodsConfiguredByUser = totalMethodsConfiguredByUser;
    }

    public String[] getTwoFactorMethodForUser() {
        return this.twoFactorMethodForUser;
    }

    public void setTwoFactorMethodForUser(String[] twoFactorMethodForUser) {
        this.twoFactorMethodForUser = twoFactorMethodForUser;
    }

    public List<String> getTwoFactorMethodForUserList() {
        return this.twoFactorMethodForUserList;
    }

    public void setTwoFactorMethodForUserList(List<String> twoFactorMethodForUserList) {
        this.twoFactorMethodForUserList = twoFactorMethodForUserList;
    }

    public Boolean getSmtpConfigured() {
        return this.smtpConfigured;
    }

    public void setSmtpConfigured(Boolean smtpConfigured) {
        this.smtpConfigured = smtpConfigured;
    }

    public Boolean getOtpOverEmailConfigured() {
        return this.otpOverEmailConfigured;
    }

    public void setOtpOverEmailConfigured(Boolean otpOverEmailConfigured) {
        this.otpOverEmailConfigured = otpOverEmailConfigured;
    }

    public String getOtpOverEmailConfiguredString() {
        return this.otpOverEmailConfiguredString;
    }

    public void setOtpOverEmailConfiguredString(String otpOverEmailConfiguredString) {
        this.otpOverEmailConfiguredString = otpOverEmailConfiguredString;
    }

    public Boolean getOtpOverSmsConfigured() {
        return this.otpOverSmsConfigured;
    }

    public void setOtpOverSmsConfigured(Boolean otpOverSmsConfigured) {
        this.otpOverSmsConfigured = otpOverSmsConfigured;
    }

    public String getCurrentDefault2faMethod() {
        return this.currentDefault2faMethod;
    }

    public void setCurrentDefault2faMethod(String currentDefault2faMethod) {
        this.currentDefault2faMethod = currentDefault2faMethod;
    }

    public Boolean getAllowToReconfigureMethod() {
        return this.allowToReconfigureMethod;
    }

    public void setAllowToReconfigureMethod(Boolean allowToReconfigureMethod) {
        this.allowToReconfigureMethod = allowToReconfigureMethod;
    }

    public Boolean getEnableEnforceCurrentMethod() {
        return this.enableEnforceCurrentMethod;
    }

    public void setEnableEnforceCurrentMethod(Boolean enableEnforceCurrentMethod) {
        this.enableEnforceCurrentMethod = enableEnforceCurrentMethod;
    }

    public String getPrimaryMethodForUser() {
        return this.primaryMethodForUser;
    }

    public void setPrimaryMethodForUser(String primaryMethodForUser) {
        this.primaryMethodForUser = primaryMethodForUser;
    }

    public Boolean getShowAllConfiguredMethodsDirectly() {
        return this.showAllConfiguredMethodsDirectly;
    }

    public void setShowAllConfiguredMethodsDirectly(Boolean showAllConfiguredMethodsDirectly) {
        this.showAllConfiguredMethodsDirectly = showAllConfiguredMethodsDirectly;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getAppLabel() {
        return this.appLabel;
    }

    public void setAppLabel(String appLabel) {
        this.appLabel = appLabel;
    }
}

