/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowdfree.action.MoTwoFactorSettingsAction;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorPremiumFeatures
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorSettingsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private int totalCards = 6;
    private HttpServletRequest request;

    public MoTwoFactorPremiumFeatures(MoTwoFactorCommonPluginSettings settings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorSettingsAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                return "success";
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public Boolean getShouldShowUserManagement() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowIPRestriction() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowLookandFeel() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowAdvancedSettings() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowAuditLogs() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowAuthenticatorMethod() {
        return Boolean.TRUE;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public int getTotalCards() {
        return this.totalCards;
    }

    public void setTotalCards(int totalCards) {
        this.totalCards = totalCards;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

