/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.ReadOnlyGroupManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import java.util.HashMap;

public class MemoryGroupManagerReadOnly
extends ReadOnlyGroupManager {
    private Repository repository;
    private MemoryProvider provider;

    public MemoryGroupManagerReadOnly() {
    }

    public MemoryGroupManagerReadOnly(Repository config, MemoryProvider provider) {
        this.repository = config;
        this.provider = provider;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.provider = (MemoryProvider)args.get("provider");
        this.repository = (Repository)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"repository", "provider"}, this);
    }

    public Pager getGroups() {
        return this.provider.getGroups();
    }

    public boolean hasMembership(Group group, User user) {
        return this.provider.hasMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public Group getGroup(String groupName) {
        return this.provider.getGroup(groupName);
    }

    public Pager getGroups(User user) {
        return this.provider.getGroups(user);
    }

    public void setUserManager(UserManager userManager) {
    }

    public Pager getMemberNames(Group group) {
        return this.provider.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.provider.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        throw new UnsupportedOperationException("External membership is not supported");
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }
}

