/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Caching;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.hibernate.DefaultExternalEntityDAO;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import java.io.Serializable;

public class CachingExternalEntityDAO
extends DefaultExternalEntityDAO
implements Caching {
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ExternalEntity getExternalEntity(String externalEntityName) {
        Cache nameCache = this.cacheManager.getCache(this.getClass().getName() + ".externalEntityName");
        Long id = (Long)nameCache.get(externalEntityName);
        if (id != null) {
            return (ExternalEntity)this.getHibernateTemplate().get(DefaultHibernateExternalEntity.class, (Serializable)id);
        }
        ExternalEntity externalEntity = super.getExternalEntity(externalEntityName);
        if (externalEntity != null) {
            nameCache.put(externalEntityName, new Long(externalEntity.getId()));
        }
        return externalEntity;
    }
}

