/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultRepositoryAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.RepositoryProcessor;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.atlassian.user.util.ClassLoaderUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractRepositoryProcessor
implements RepositoryProcessor {
    protected static final Logger log = Logger.getLogger(AbstractRepositoryProcessor.class);
    protected DefaultRepositoryAccessor repositoryAccessor = new DefaultRepositoryAccessor();
    protected Repository repository;
    protected UserManager userManager;
    protected GroupManager groupManager;
    protected PasswordEncryptor passwordEncryptor;
    protected Authenticator authenticator;
    protected PropertySetFactory propertySetFactory;
    protected EntityQueryParser entityQueryParser;
    protected ExternalEntityDAO externalEntityDAO;

    public RepositoryAccessor process(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        this.repository = this.configureRepository(components, componentClassNames);
        this.repositoryAccessor.setRepository(this.repository);
        this.propertySetFactory = this.configurePropertySetFactory(components, componentClassNames);
        this.repositoryAccessor.setPropertySetFactory(this.propertySetFactory);
        this.passwordEncryptor = this.configurePasswordEncryptor(components, componentClassNames);
        this.repositoryAccessor.setPasswordEncryptor(this.passwordEncryptor);
        this.userManager = this.configureUserManager(components, componentClassNames);
        this.repositoryAccessor.setUserManager(this.userManager);
        this.authenticator = this.configureAuthenticator(components, componentClassNames);
        this.repositoryAccessor.setAuthenticator(this.authenticator);
        this.groupManager = this.configureGroupManager(components, componentClassNames);
        this.repositoryAccessor.setGroupManager(this.groupManager);
        this.entityQueryParser = this.configureEntityQueryParser(components, componentClassNames);
        this.repositoryAccessor.setEntityQueryParser(this.entityQueryParser);
        String caching = (String)components.get("cache");
        if (caching != null && caching.equals("true")) {
            this.configureCaching(components);
        }
        return this.repositoryAccessor;
    }

    protected void configureCaching(HashMap components) throws ConfigurationException {
        RepositoryConfiguration cachingConfiguration = (RepositoryConfiguration)components.get("cacheConfig");
        String cacheRepositoryProcessorClassName = (String)cachingConfiguration.getComponentClassNames().get("processor");
        RepositoryProcessor cachingProcessor = (RepositoryProcessor)this.instantiateComponent(cacheRepositoryProcessorClassName);
        cachingConfiguration.getComponents().put("underlyingComponents", components);
        RepositoryAccessor cachingRepositoryAccessor = cachingProcessor.process(cachingConfiguration.getComponents(), cachingConfiguration.getComponentClassNames());
        this.repositoryAccessor.setUserManager(cachingRepositoryAccessor.getUserManager());
        this.repositoryAccessor.setGroupManager(cachingRepositoryAccessor.getGroupManager());
        this.repositoryAccessor.setPropertySetFactory(cachingRepositoryAccessor.getPropertySetFactory());
    }

    public PasswordEncryptor configurePasswordEncryptor(HashMap components, HashMap componentClassNames) {
        String passwordEncryptorClassName = (String)componentClassNames.get("passwordEncryptor");
        if (passwordEncryptorClassName == null) {
            return null;
        }
        this.passwordEncryptor = (PasswordEncryptor)this.instantiateComponent(passwordEncryptorClassName);
        this.passwordEncryptor.init(components);
        components.put("passwordEncryptor", this.passwordEncryptor);
        return this.passwordEncryptor;
    }

    protected Object instantiateComponent(String className) {
        try {
            Class componentClass = ClassLoaderUtils.loadClass(className, this.getClass());
            return componentClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not create component, class not found: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not create component, access forbidden to class: " + className, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating component of class: " + className, e);
        }
    }

    public PropertySetFactory configurePropertySetFactory(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String propertySetFactoryClassName = (String)componentClassNames.get("propertySetFactory");
        if (propertySetFactoryClassName == null) {
            return null;
        }
        this.propertySetFactory = (PropertySetFactory)this.instantiateComponent(propertySetFactoryClassName);
        this.propertySetFactory.init(components);
        components.put("propertySetFactory", this.propertySetFactory);
        return this.propertySetFactory;
    }

    public UserManager configureUserManager(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String userManagerClassName = (String)componentClassNames.get("userManager");
        if (userManagerClassName == null) {
            return null;
        }
        this.userManager = (UserManager)this.instantiateComponent(userManagerClassName);
        this.userManager.init(components);
        components.put("userManager", this.userManager);
        return this.userManager;
    }

    public GroupManager configureGroupManager(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String groupManagerClassName = (String)componentClassNames.get("groupManager");
        if (groupManagerClassName == null) {
            return null;
        }
        this.groupManager = (GroupManager)this.instantiateComponent(groupManagerClassName);
        this.groupManager.init(components);
        components.put("groupManager", this.groupManager);
        return this.groupManager;
    }

    public Authenticator configureAuthenticator(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String authenticatorClassName = (String)componentClassNames.get("authenticator");
        if (authenticatorClassName == null) {
            return null;
        }
        this.authenticator = (Authenticator)this.instantiateComponent(authenticatorClassName);
        this.authenticator.init(components);
        components.put("authenticator", this.authenticator);
        return this.authenticator;
    }

    public EntityQueryParser configureEntityQueryParser(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String entityQueryParserClassName = (String)componentClassNames.get("entityQueryParser");
        if (entityQueryParserClassName == null) {
            return null;
        }
        this.entityQueryParser = (EntityQueryParser)this.instantiateComponent(entityQueryParserClassName);
        this.entityQueryParser.init(components);
        components.put("entityQueryParser", this.entityQueryParser);
        return this.entityQueryParser;
    }

    public Repository configureRepository(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String className = (String)componentClassNames.get("class");
        if (className == null) {
            return null;
        }
        this.repository = (Repository)this.instantiateComponent(className);
        this.repository.init(components);
        components.put("repository", this.repository);
        return this.repository;
    }

    public RepositoryAccessor getRepositoryAccessor() {
        return this.repositoryAccessor;
    }
}

