/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.utility;

import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorUtility {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorUtility.class);
    private static final int NO_OF_BYTES_FOR_SECRET = 10;
    private static final int TOKEN_INTERVAL = 30;
    private static final String CODE_GENERATION_ALGORITHM = "HmacSHA1";
    private static String GOOGLE_AUTH_CODE_URI_FORMAT = "otpauth://totp/%s?issuer=##issuerName##&secret=%s";

    public long get_interval_time() {
        Long currentTime = System.currentTimeMillis();
        long T = currentTime / 1000L / 30L;
        return T;
    }

    public static String generateKey() {
        byte[] buffer = new byte[10];
        new SecureRandom().nextBytes(buffer);
        String secret = new String(new Base32().encode(buffer));
        return secret;
    }

    public String convertToQRCodeString(String data) {
        ByteArrayOutputStream bytes = QRCode.from(data).to(ImageType.JPG).withSize(300, 300).withHint(EncodeHintType.MARGIN, 0).withErrorCorrection(ErrorCorrectionLevel.M).stream();
        return org.apache.commons.codec.binary.Base64.encodeBase64String(bytes.toByteArray());
    }

    public boolean code_verification(String secret, long code, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        LOGGER.debug("Code " + code);
        LOGGER.debug("Time " + t);
        Base32 codec = new Base32();
        byte[] decoded_secret = codec.decode(secret);
        int window = 3;
        for (int i = -window; i <= window; ++i) {
            long hash = MoTwoFactorUtility.generated_code(decoded_secret, t + (long)i);
            LOGGER.debug("CODE " + hash);
            if (hash != code) continue;
            return true;
        }
        return false;
    }

    private static int generated_code(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, CODE_GENERATION_ALGORITHM);
        Mac mac = Mac.getInstance(CODE_GENERATION_ALGORITHM);
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return (int)(truncatedHash %= 1000000L);
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie createCookie(String url, String cookieName, String cookieValue, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath("/");
        cookie.setSecure(StringUtils.isNotBlank((CharSequence)url) && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("https://"));
        cookie.setHttpOnly(isHttpOnly.booleanValue());
        return cookie;
    }

    public static void clearCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = MoTwoFactorUtility.getCookie(cookieName, request);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public static Boolean isValidNumberFormat(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return false;
        }
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String generateRandomString(int size) {
        byte[] buffer = new byte[size];
        new SecureRandom().nextBytes(buffer);
        String secret = new String(new Base32().encode(buffer));
        return secret;
    }

    public static String hashString(String hash) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] encodedhash = digest.digest(hash.getBytes(StandardCharsets.UTF_8));
        StringBuffer hexToString = new StringBuffer();
        for (int i = 0; i < encodedhash.length; ++i) {
            String hex = Integer.toHexString(0xFF & encodedhash[i]);
            if (hex.length() == 1) {
                hexToString.append('0');
            }
            hexToString.append(hex);
        }
        return hexToString.toString();
    }

    public static Boolean isTwoFactorVerified(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        Boolean twoFactorVerified = (Boolean)session.getAttribute("2fa_verification");
        LOGGER.debug("Is Session for Verified " + twoFactorVerified);
        return BooleanUtils.toBoolean((Boolean)twoFactorVerified);
    }

    public static Boolean isValidUrlForUser(String username, MoTwoFactorCommonPluginSettings settings, String currentMethod) {
        LOGGER.debug("validating current URL for : " + currentMethod);
        MoTwoFactorCommonUserSettings twoFactorUserSettings = settings.getUserSettings(username);
        List<String> enable2FAForUsersList = settings.getEnable2FAForUsersList();
        if (BooleanUtils.toBoolean((Boolean)settings.getEnableTwoFactor()) && enable2FAForUsersList.contains(username)) {
            LOGGER.debug("Enable Two Factor");
            List<String> twoFactorConfiguredUser = settings.getListOf2FAConfiguredUsers();
            List<String> twoFactorMethodsForUser = settings.get2FAMethodForUserList();
            List<String> backupMethodsForUser = settings.getBackupMethodForUserList();
            Boolean is2FAConfigured = twoFactorConfiguredUser.contains(username);
            Boolean enabledBackupMethod = settings.getEnableBackupMethod();
            MoTwoFactorCommonUserSettings twoFactorUserClass = settings.getUserSettings(username);
            switch (currentMethod) {
                case "InlineRegistration_GoogleAuthenticator": {
                    if (BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
                        LOGGER.debug("2FA is already configured");
                        return false;
                    }
                    if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator")) {
                        LOGGER.debug("Mobile Authenticator is already configured");
                        return false;
                    }
                    if (twoFactorMethodsForUser.contains("GoogleAuthenticator")) {
                        LOGGER.debug("Mobile Authenticator is enabled");
                        return true;
                    }
                    return false;
                }
                case "InlineRegistration_OtpOverEmail": {
                    if (BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
                        LOGGER.debug("2FA is already configured");
                        return false;
                    }
                    if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverEmail")) {
                        LOGGER.debug("OTP Over Email is already configured");
                        return false;
                    }
                    if (twoFactorMethodsForUser.contains("OtpOverEmail")) {
                        LOGGER.debug("OTP Over is enabled as Primary 2FA");
                        return true;
                    }
                    if (BooleanUtils.toBoolean((Boolean)settings.getEnableBackupMethod()) && backupMethodsForUser.contains("OtpOverEmail")) {
                        LOGGER.debug("OTP Over Email is enabled as Backup Method");
                        return true;
                    }
                    return false;
                }
                case "InlineRegistration_SecurityQuestion": {
                    if (BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
                        LOGGER.debug("2FA is already configured");
                        return false;
                    }
                    if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("SecurityQuestion")) {
                        LOGGER.debug("Security Question is already configured");
                        return false;
                    }
                    if (twoFactorMethodsForUser.contains("SecurityQuestion")) {
                        LOGGER.debug("Security Question is enabled as Primary 2FA");
                        return true;
                    }
                    if (BooleanUtils.toBoolean((Boolean)settings.getEnableBackupMethod()) && backupMethodsForUser.contains("SecurityQuestion")) {
                        LOGGER.debug("Security Question is enabled as Backup Method");
                        return true;
                    }
                    return false;
                }
                case "InlineRegistration_BackupCode": {
                    if (BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
                        LOGGER.debug("2FA is already configured");
                        return false;
                    }
                    if (!BooleanUtils.toBoolean((Boolean)enabledBackupMethod)) {
                        LOGGER.debug("Backup Method is not enabled");
                        return false;
                    }
                    if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode")) {
                        LOGGER.debug("Backup Code is already configured");
                        return false;
                    }
                    if (BooleanUtils.toBoolean((Boolean)settings.getEnableBackupMethod()) && backupMethodsForUser.contains("BackupCode")) {
                        LOGGER.debug("Backup Code is enabled as Backup Method");
                        return true;
                    }
                    return false;
                }
                case "Validate_Otp": {
                    if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
                        LOGGER.debug("2FA is not configured");
                        return false;
                    }
                    if (!twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator")) {
                        LOGGER.debug("Mobile Authentication is not configured");
                        return false;
                    }
                    return true;
                }
                case "Validate_OtpOverEmail": {
                    if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
                        LOGGER.debug("2FA is not configured");
                        return false;
                    }
                    if (!twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverEmail")) {
                        LOGGER.debug("OTP Over Email is not configured");
                        return false;
                    }
                    return true;
                }
                case "Validate_SecurityQuestion": {
                    if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured) || !twoFactorUserClass.getConfigured2FAMethodsByUser().contains("SecurityQuestion")) {
                        LOGGER.debug("2FA is not configured or Backup method is not enabled");
                        return false;
                    }
                    return true;
                }
                case "Validate_BackupCode": {
                    if (BooleanUtils.toBoolean((Boolean)is2FAConfigured) && twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode") && BooleanUtils.toBoolean((Boolean)settings.getEnableBackupMethod())) {
                        return true;
                    }
                    return false;
                }
                case "Validate_BackupMethodList": {
                    if (BooleanUtils.toBoolean((Boolean)is2FAConfigured) && twoFactorUserClass.getConfigured2FAMethodsByUser().contains("SecurityQuestion") && twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode")) {
                        LOGGER.debug("2FA is configured & multiple Backup Methods configured");
                        return true;
                    }
                    LOGGER.debug("2FA is not configured or Backup Code is not enabled");
                    return false;
                }
            }
        }
        return false;
    }

    public static SecretKeySpec getSecretKey(String myKey) {
        SecretKeySpec secretKey = null;
        MessageDigest sha = null;
        try {
            byte[] key = myKey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
            return secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return secretKey;
    }

    public static String encryptString(String toEncrypt, String crowdInstanceKey) {
        try {
            SecretKeySpec secretKey = MoTwoFactorUtility.getSecretKey(crowdInstanceKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(toEncrypt.getBytes("UTF-8")));
        }
        catch (Exception e) {
            LOGGER.debug("Error while encrypting: " + e.toString());
            return null;
        }
    }

    public static String decryptString(String toDecrypt, String crowdInstanceKey) {
        try {
            SecretKeySpec secretKey = MoTwoFactorUtility.getSecretKey(crowdInstanceKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, secretKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(toDecrypt)));
        }
        catch (Exception e) {
            LOGGER.debug("Error while decrypting: " + e.toString());
            return null;
        }
    }

    public static List<String> getQuestionList() {
        ArrayList<String> questionList = new ArrayList<String>();
        questionList.add("Select Security Question");
        questionList.add("What is your first company name?");
        questionList.add("What was your childhood nickname?");
        questionList.add("In what city did you meet your spouse/significant other?");
        questionList.add("What is the name of your favorite childhood friend?");
        questionList.add("What school did you attend for sixth grade?");
        questionList.add("In what city or town was your first job?");
        questionList.add("What is your favourite sport?");
        questionList.add("Who is your favourite sports player?");
        questionList.add("What is your grandmother's maiden name?");
        questionList.add("What was your first vehicle's registration number?");
        return questionList;
    }

    public static String generateQrCode(String secret, String email, String issuerName) {
        LOGGER.debug("Generating new QR code");
        MoTwoFactorUtility moTwoFactorUtility = new MoTwoFactorUtility();
        String TOTPURL = GOOGLE_AUTH_CODE_URI_FORMAT;
        TOTPURL = String.format(TOTPURL, email, secret);
        TOTPURL = StringUtils.replace((String)TOTPURL, (String)"##issuerName##", (String)issuerName);
        String qrcode = moTwoFactorUtility.convertToQRCodeString(TOTPURL);
        return qrcode;
    }

    public static String getDeviceDetails(HttpServletRequest request) {
        String[] strArr;
        String cookieValue = request.getHeader("cookie").trim();
        for (String str : strArr = cookieValue.split(";")) {
            LOGGER.debug("Available cookie : " + str);
            if (!str.contains("DEVICEDETAILS")) continue;
            str = str.trim();
            return str.split("=")[1].trim();
        }
        Cookie returnToCookie = MoTwoFactorUtility.getCookie("DEVICEDETAILS", request);
        if (returnToCookie != null && StringUtils.isNotBlank((CharSequence)returnToCookie.getValue())) {
            return returnToCookie.getValue();
        }
        return "";
    }

    public static String getCurrentIpAddress(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && (StringUtils.isBlank((CharSequence)(remoteAddr = request.getHeader("X-FORWARDED-FOR"))) || StringUtils.isEmpty((CharSequence)remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }
}

