/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.servlet.MoTwoFactorInlineRegistration2FAMethodList;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationBackupMethodList
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistration2FAMethodList.class);
    private static final String METHODLIST_VM_PATH = "/templates/com/miniorange/twofactor/crowdfree/inlineregistration_backupmethodlist.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorInlineRegistrationBackupMethodList(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistration2FAMethodList doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && !this.settings.getListOf2FAConfiguredUsers().contains(username)) {
            Map<String, Object> context = this.initializeContext(username, request);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(METHODLIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoValidateOtpAction doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String configureTwoFactor = request.getParameter("configureTwoFactor");
            if (StringUtils.isNotBlank((CharSequence)"configureTwoFactor")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"OtpOverEmail")) {
                    LOGGER.debug("Redirecting to OTP Over EMail");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"SecurityQuestion")) {
                    LOGGER.debug("Redirecting to Security Question");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion"));
                    return;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)configureTwoFactor, (CharSequence)"BackupCode")) {
                    LOGGER.debug("Redirecting to Backup Code");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode"));
                    return;
                }
            }
            String errorMessage = "Please select valid method.";
            Map<String, Object> context = this.initializeContext(username, request);
            context.put("errorMessage", errorMessage);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(METHODLIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    private Map<String, Object> initializeContext(String username, HttpServletRequest request) {
        UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
        String displayName = userProfile.getFullName();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = username;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("username", displayName);
        context.put("errorMessage", "");
        List<String> backupMethodList = this.settings.getBackupMethodForUserList();
        MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
        List<String> configuredMethods = twoFactorCommonUserSettings.getConfigured2FAMethodsByUser();
        if (backupMethodList.contains("SecurityQuestion") && !configuredMethods.contains("SecurityQuestion")) {
            context.put("securityQuestionEnabled", Boolean.TRUE);
        } else {
            context.put("securityQuestionEnabled", Boolean.FALSE);
        }
        if (backupMethodList.contains("OtpOverEmail") && !configuredMethods.contains("OtpOverEmail")) {
            context.put("otpOverEmailEnabled", Boolean.TRUE);
        } else {
            context.put("otpOverEmailEnabled", Boolean.FALSE);
        }
        if (backupMethodList.contains("BackupCode")) {
            context.put("backupCodeEnabled", Boolean.TRUE);
        } else {
            context.put("backupCodeEnabled", Boolean.FALSE);
        }
        context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
        return context;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

