/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorDownloadBackupCode
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorDownloadBackupCode.class);
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorDownloadBackupCode(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.debug("MoTwoFactorDownloadBackupCode doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            MoTwoFactorCommonUserSettings userSettings = this.settings.getUserSettings(username);
            if (userSettings.getConfigured2FAMethodsByUser().contains("BackupCode")) {
                LOGGER.info("Downloading Backup Code.");
                String backupCodeString = "These are emergency one time backup codes that you can use to get access to your account. It can be used when you arer not able to login using two factor. \nYou are advised to use one backup code at a time.\n\n" + this.generateUsersBackupCodeFile(username);
                LOGGER.debug("backupCodeString : " + backupCodeString);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + username + "_crowd_backupcode.txt\"");
                response.setHeader("Cache-Control", "max-age=0");
                response.setHeader("Pragma", "");
                response.setContentType("application/json");
                response.getOutputStream().write(backupCodeString.getBytes());
                return;
            }
            LOGGER.debug("Backup Code is not enabled.");
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    private String generateUsersBackupCodeFile(String username) {
        String file = "";
        MoTwoFactorCommonUserSettings userSettings = this.settings.getUserSettings(username);
        List<String> backupCodes = userSettings.getBackupCodes();
        LOGGER.debug("Backup Code : " + backupCodes);
        if (backupCodes.size() > 0) {
            int i = 1;
            for (String backupCode : backupCodes) {
                file = file + i + ". " + MoTwoFactorUtility.decryptString(backupCode, this.pluginConfiguration.SECRETE_KEY) + "\n\n";
                ++i;
            }
        } else {
            LOGGER.debug("Empty backup code found.");
            return "";
        }
        return file;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

