/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAjaxConfigurationSaveServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAjaxConfigurationSaveServlet.class);
    private MoTwoFactorCommonPluginSettings settings;

    public MoTwoFactorAjaxConfigurationSaveServlet(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("Calling doGet");
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String actioneType;
        LOGGER.debug("Calling doPost");
        switch (actioneType = request.getParameter("action")) {
            case "SetUserSettings": {
                this.performSetUserSettings(request, response);
                break;
            }
            case "SetEnable2FAForGroupsList": {
                this.performSetEnable2FAForGroupsList(request, response);
                break;
            }
            case "SetListOf2FAConfiguredUsers": {
                this.performSetListOf2FAConfiguredUsers(request, response);
                break;
            }
            case "SetEnable2FAForUsersList": {
                this.performSetEnable2FAForUsersList(request, response);
                break;
            }
            case "SetUserManagementSelectedAction": {
                this.performSetUserManagementSelectedAction(request, response);
                break;
            }
            case "SetEncryptionKey": {
                this.performSetEncryptionKey(request, response);
                break;
            }
            case "SetEnable2FAForAllUsers": {
                this.setEnable2FAForAllUsers(request, response);
                break;
            }
            case "AddTo2FAConfiguredUsersList": {
                this.addTo2FAConfiguredUsersList(request, response);
                break;
            }
            case "SetIpManagementSelectedAction": {
                this.setIpManagementSelectedAction(request, response);
                break;
            }
            case "SetWhitelistIpAddresses": {
                this.setWhitelistIpAddresses(request, response);
                break;
            }
            case "SetBlacklistIpAddresses": {
                this.setBlacklistIpAddresses(request, response);
                break;
            }
            case "SetLockedUserDetails": {
                this.setLockedUserDetails(request, response);
            }
        }
    }

    private void setLockedUserDetails(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String data = request.getParameter("lockedUserDetails");
        Map<Object, Object> lockedUserDetails = StringUtils.isBlank((CharSequence)data) ? new HashMap() : this.parseToMap(data);
        this.settings.setLockedUserDetails(lockedUserDetails);
        this.sendSuccessFullResponse("Success", response);
    }

    private void setBlacklistIpAddresses(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String data = request.getParameter("blacklistIpAddresses");
        List<String> blacklistIpAddresses = this.parseToList(data);
        blacklistIpAddresses = StringUtils.isBlank((CharSequence)data) ? new ArrayList<String>() : this.parseToList(data);
        this.settings.setBlacklistIpAddresses(blacklistIpAddresses);
        this.sendSuccessFullResponse("Success", response);
    }

    private void setWhitelistIpAddresses(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String data = request.getParameter("whitelistIpAddresses");
        List<String> whitelistIpAddresses = this.parseToList(data);
        whitelistIpAddresses = StringUtils.isBlank((CharSequence)data) ? new ArrayList<String>() : this.parseToList(data);
        this.settings.setWhitelistIpAddresses(whitelistIpAddresses);
        this.sendSuccessFullResponse("Success", response);
    }

    private void setIpManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = request.getParameter("selectedAction");
        LOGGER.debug("selectedAction : " + selectedAction);
        this.settings.setIpManagementSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void addTo2FAConfiguredUsersList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String username = request.getParameter("username");
        this.settings.addTo2FAConfiguredUsersList(username);
        this.sendSuccessFullResponse("Success", response);
    }

    private void setEnable2FAForAllUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String enable2FAForAllUsers = request.getParameter("enable2FAForAllUsers");
        if (StringUtils.equalsIgnoreCase((CharSequence)enable2FAForAllUsers, (CharSequence)"true")) {
            this.settings.setEnable2FAForAllUsers(Boolean.TRUE);
        } else {
            this.settings.setEnable2FAForAllUsers(Boolean.FALSE);
        }
        this.sendSuccessFullResponse("Success", response);
    }

    private void performSetEncryptionKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String encryptionKey = request.getParameter("encryptionKey");
        this.settings.setEncryptionKey(encryptionKey);
        this.sendSuccessFullResponse("Success", response);
    }

    private void performSetUserManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = request.getParameter("selectedAction");
        LOGGER.debug("selectedAction : " + selectedAction);
        this.settings.setUserManagementSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void performSetEnable2FAForUsersList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<String> enable2FAFor = this.parseToList(request.getParameter("enable2FAFor"));
        this.settings.setEnable2FAForUsersList(enable2FAFor);
        this.sendSuccessFullResponse("Success", response);
    }

    private void performSetListOf2FAConfiguredUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<String> configuredUser = this.parseToList(request.getParameter("configuredUsers"));
        this.settings.setListOf2FAConfiguredUsers(configuredUser);
        this.sendSuccessFullResponse("Success", response);
    }

    private void performSetEnable2FAForGroupsList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<String> enable2FAFor = this.parseToList(request.getParameter("enable2FAFor"));
        this.settings.setEnable2FAForGroupsList(enable2FAFor);
        this.sendSuccessFullResponse("Success", response);
    }

    private void performSetUserSettings(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String username = request.getParameter("username");
        String twoFactorUserClass = request.getParameter("twoFactorUserClass");
        this.settings.setUserSettings(username, this.getFromJsonObject(twoFactorUserClass));
        this.sendSuccessFullResponse("Success", response);
    }

    private MoTwoFactorCommonUserSettings getFromJsonObject(String jsonObject) {
        JsonParser parser = new JsonParser();
        Gson gson = new Gson();
        MoTwoFactorCommonUserSettings twoFactorUserSettings = gson.fromJson((JsonElement)parser.parse(jsonObject).getAsJsonObject(), MoTwoFactorCommonUserSettings.class);
        return twoFactorUserSettings;
    }

    private List<String> parseToList(String listOfData) {
        LOGGER.debug("List Data : " + listOfData);
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        JsonArray groupListJsonArray = parser.parse(listOfData).getAsJsonArray();
        Type listType = new TypeToken<List<String>>(){}.getType();
        List groupsToAssign = (List)gson.fromJson((JsonElement)groupListJsonArray, listType);
        return groupsToAssign;
    }

    private Map<String, String> parseToMap(String listOfData) {
        LOGGER.debug("Map Data : " + listOfData);
        Gson gson = new Gson();
        Map dataInMap = gson.fromJson(listOfData, Map.class);
        return dataInMap;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse response) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        response.setContentType("application/json");
        response.setStatus(200);
        if (result != null) {
            response.getOutputStream().write(result.getBytes());
            response.getOutputStream().close();
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }
}

