/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAjaxCallsServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAjaxCallsServlet.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private CrowdService crowdService;
    private UserManager userManager;
    private String userSearchFilter;
    private String usernameSearchKeyword;
    private List<String> totalEnabledUserList;

    public MoTwoFactorAjaxCallsServlet(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, CrowdService crowdService, UserManager userManager) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.crowdService = crowdService;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action;
        LOGGER.debug("Calling Ajax");
        switch (action = request.getParameter("action")) {
            case "Reset": {
                String method = request.getParameter("method");
                LOGGER.debug("Current 2FA Reset method : " + method);
                if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"GoogleAuthenticator")) {
                    this.resetGoogleAuthenticator(request, response);
                    break;
                }
                if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"SecurityQuestion")) {
                    this.resetSecurityQuestion(request, response);
                    break;
                }
                if (!StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"OtpOverEmail")) break;
                this.resetOtpOverEmail(request, response);
                break;
            }
            case "Disable2faForUser": {
                this.disable2FAForUser(request, response);
                break;
            }
            case "Enable2faForUser": {
                this.enable2FAForUser(request, response);
                break;
            }
            case "Reset2faForUser": {
                this.reset2FAForUser(request, response);
                break;
            }
            case "Enable2faForSelectedUsers": {
                this.enable2FAForSelectedUsers(request, response);
                break;
            }
            case "Disable2faForSelectedUsers": {
                this.disable2faForSelectedUsers(request, response);
                break;
            }
            case "Reset2faForSelectedUsers": {
                this.reset2faForSelectedUsers(request, response);
                break;
            }
            case "Enable2faForAllUsers": {
                this.enable2FAForAllUser(request, response);
                break;
            }
            case "Disable2faForAllUsers": {
                this.disable2FAForAllUser(request, response);
                break;
            }
            case "Reset2faForAllUsers": {
                this.reset2FAForAllUser(request, response);
                break;
            }
            case "EnableDisable2FAForAllUsers": {
                this.enableDisable2FAForAllUsers(request, response);
                break;
            }
            case "ChangeUserManagementSelectedAction": {
                this.changeUserManagementSelectedAction(request, response);
                break;
            }
            case "Enable2faForGroup": {
                this.enable2faForGroup(request, response);
                break;
            }
            case "Disable2faForGroup": {
                this.disable2faForGroup(request, response);
                break;
            }
            case "Enable2faForSelectedGroups": {
                this.enable2FAForSelectedGroups(request, response);
                break;
            }
            case "Disable2faForSelectedGroups": {
                this.disable2faForSelectedGroups(request, response);
                break;
            }
            case "Enable2faForAllGroups": {
                this.enable2FAForAllGroups(request, response, true);
                break;
            }
            case "Disable2faForAllGroups": {
                this.disable2FAForAllGroups(request, response, true);
                break;
            }
            case "RemoveDeviceDetails": {
                this.removeDeviceDetails(request, response);
                break;
            }
            case "ChangeIpManagementSelectedAction": {
                this.changeIpManagementSelectedAction(request, response);
                break;
            }
            case "RemoveWhitelistIp": {
                this.removeWhitelistIp(request, response);
                break;
            }
            case "RemoveBlacklistIp": {
                this.removeBlacklistIp(request, response);
                break;
            }
            case "RemoveSelectedWhitelistIps": {
                this.removeSelectedWhitelistIps(request, response);
                break;
            }
            case "RemoveSelectedBlacklistIps": {
                this.removeSelectedBlacklistIps(request, response);
                break;
            }
            case "RemoveAllWhitelistIps": {
                this.removeAllWhitelistIps(request, response);
                break;
            }
            case "RemoveAllBlacklistIps": {
                this.removeAllBlacklistIps(request, response);
                break;
            }
            case "RemoveLockedUser": {
                this.removeLockedUser(request, response);
                break;
            }
            case "RemoveSelectedLockedUsers": {
                this.removeSelectedLockedUsers(request, response);
                break;
            }
            case "RemoveAllLockedUsers": {
                this.removeAllLockedUsers(request, response);
                break;
            }
            case "EnableBackupCode": {
                this.enableBackupCode(request, response);
                break;
            }
            case "DisableBackupCode": {
                this.disableBackupCode(request, response);
                break;
            }
            case "ChangeBackupCode": {
                this.changeBackupCode(request, response);
                break;
            }
            case "SendOtpOverEmail": {
                this.sendOtpOverEmail(request, response);
                break;
            }
            case "SetAsDefault2fa": {
                this.setAsDefault2fa(request, response, request.getParameter("method"));
                break;
            }
            case "fetchGroups": {
                this.fetchGroups(request, response);
                break;
            }
            case "AdminPresent": {
                LOGGER.debug("case-action");
                this.adminPresent(request, response);
                break;
            }
            default: {
                response.setContentType("application/json");
                response.sendError(405, "The requested method is not allowed. Choose valid Method");
                return;
            }
        }
    }

    private void fetchGroups(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Calling fetchGroups");
        try {
            String search = StringUtils.trim((String)request.getParameter("search"));
            List<String> groups = this.pluginHandler.getGroupsFromCrowdUsingGroupname(search, 10);
            JsonObject data = new JsonObject();
            JsonArray resultArray = new JsonArray();
            for (String groupName : groups) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", groupName);
                jsonObject.addProperty("text", groupName);
                resultArray.add(jsonObject);
            }
            LOGGER.debug("Sending array : " + resultArray);
            data.add("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching groups ", e);
        }
    }

    private void setAsDefault2fa(HttpServletRequest request, HttpServletResponse response, String method) throws IOException {
        LOGGER.debug("Calling setAsDefault2fa");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                LOGGER.debug("Setting default 2FA method to : " + method);
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                twoFactorUserClass.setCurrent2FAMethod(method);
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully set default 2fa method to : " + method);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Setting Default 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void sendOtpOverEmail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling sendOtpOverEmail");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmtpConfigured())) {
                try {
                    UserProfile user = this.pluginConfiguration.getCrowdUser();
                    LOGGER.debug("Sending OTP to: " + user.getEmail());
                    this.pluginHandler.sendOtpOnEmail(request, user);
                    LOGGER.debug("Successfully Send OTP on Email : " + user.getEmail());
                    this.sendSuccessFullResponse("Success", response);
                }
                catch (Exception e) {
                    LOGGER.debug("Error : " + e);
                    e.printStackTrace();
                    this.sendErrorResponse("Error", response);
                }
            } else {
                this.sendErrorResponse("No SMTP Configured", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void changeBackupCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling changeBackupCode");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                LOGGER.debug("Changing Backup Code for : " + username);
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                List<String> backupCodes = this.pluginHandler.generateBackupCode();
                twoFactorUserClass.setBackupCodes(this.pluginHandler.encodeBackupCode(backupCodes));
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Changed Backup Code for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Changing Backup Code : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void disableBackupCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disableBackupCode");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Disabling Backup Code for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("BackupCode"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                twoFactorUserClass.setBackupCodes(new ArrayList<String>());
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Disable Backup Code for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Disabling Backup Code : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void enableBackupCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enableBackupCode");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Enabling Backup Code for : " + username);
                List<String> backupCodes = this.pluginHandler.generateBackupCode();
                twoFactorUserClass.setBackupCodes(this.pluginHandler.encodeBackupCode(backupCodes));
                twoFactorUserClass.setConfigured2FAMethodsByUser("BackupCode");
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                LOGGER.debug("Successfully Enabled Backup Code for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Backup Code : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void removeAllLockedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllLockedUsers");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                this.settings.setLockedUserDetails(new HashMap<String, String>());
                LOGGER.debug("Successfully Removed All Users from Locked List");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Locked User : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Remove the users from Locked list.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeSelectedLockedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedLockedUsers");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedLockedUserList = request.getParameterValues("selectedLockedUserList");
                Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
                for (String selectedUser : selectedLockedUserList) {
                    LOGGER.debug("Removing Locked User : " + selectedUser);
                    if (!lockedUserDetails.containsKey(selectedUser)) continue;
                    lockedUserDetails.remove(selectedUser);
                }
                this.settings.setLockedUserDetails(lockedUserDetails);
                LOGGER.debug("Successfully Removed Selected User from Locked List");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Locked User : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Remove the users from Locked list.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeLockedUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeLockedUser");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String username = request.getParameter("username").trim();
                LOGGER.debug("Removing Locked User : " + username);
                Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
                if (lockedUserDetails.containsKey(username)) {
                    lockedUserDetails.remove(username);
                    this.settings.setLockedUserDetails(lockedUserDetails);
                }
                LOGGER.debug("Successfully Removed User from Locked List: " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Locked User : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Remove user from Locked list.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeAllBlacklistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllBlacklistIps");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"adaptiveauthentication") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                this.settings.setBlacklistIpAddresses(new ArrayList<String>());
                LOGGER.debug("Successfully Removed All IPs from Blacklist");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Blacklist IP : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to remove IPs from Blacklist.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeAllWhitelistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllWhitelistIps");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"adaptiveauthentication") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                this.settings.setWhitelistIpAddresses(new ArrayList<String>());
                LOGGER.debug("Successfully Removed All IPs from Whitelist");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Whitelist IP : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to remove IPs from Whitelist.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeSelectedBlacklistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedBlacklistIps");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"adaptiveauthentication") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedBlacklistIps = request.getParameterValues("selectedBlacklistIps");
                List<String> blacklistIpAddresses = this.settings.getBlacklistIpAddresses();
                for (String ipAddress : selectedBlacklistIps) {
                    blacklistIpAddresses.removeAll(Collections.singleton(ipAddress));
                }
                this.settings.setBlacklistIpAddresses(blacklistIpAddresses);
                LOGGER.debug("Successfully Removed Selected IPs from Blacklist");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Blacklist IP : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to remove IPs from Blacklist.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeSelectedWhitelistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedWhitelistIps");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"adaptiveauthentication") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedWhitelistIps = request.getParameterValues("selectedWhitelistIps");
                List<String> whitelistIpAddresses = this.settings.getWhitelistIpAddresses();
                for (String ipAddress : selectedWhitelistIps) {
                    whitelistIpAddresses.removeAll(Collections.singleton(ipAddress));
                }
                this.settings.setWhitelistIpAddresses(whitelistIpAddresses);
                LOGGER.debug("Successfully Removed Selected IPs from Whitelist");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Whitelist IP : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to remove IPs from Whitelist.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeBlacklistIp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeBlacklistIp");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"adaptiveauthentication") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String ipAddress = request.getParameter("ipAddress");
                List<String> blacklistIpAddresses = this.settings.getBlacklistIpAddresses();
                blacklistIpAddresses.removeAll(Collections.singleton(ipAddress));
                this.settings.setBlacklistIpAddresses(blacklistIpAddresses);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Blacklist IP : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Remove IP from Blacklist.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void removeWhitelistIp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeWhitelistIp");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"adaptiveauthentication") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String ipAddress = request.getParameter("ipAddress");
                LOGGER.debug("Removing IP : " + ipAddress);
                List<String> whitelistIpAddresses = this.settings.getWhitelistIpAddresses();
                LOGGER.debug("Before Remove : " + whitelistIpAddresses);
                whitelistIpAddresses.removeAll(Collections.singleton(ipAddress));
                LOGGER.debug("After Remove : " + whitelistIpAddresses);
                this.settings.setWhitelistIpAddresses(whitelistIpAddresses);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Removing Whitelist IP : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Remove IP from Whitelist.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void changeIpManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = request.getParameter("selectedAction");
        this.settings.setIpManagementSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void removeDeviceDetails(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeDeviceDetails");
        try {
            String deviceDetails = request.getParameter("deviceDetails").trim();
            String username = request.getParameter("username").trim();
            LOGGER.debug("Removing Device Details : " + deviceDetails + " for Username : " + username);
            MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
            List<String> rememberMeDeviceDetails = twoFactorCommonUserSettings.getRememberMeDeviceDetails();
            rememberMeDeviceDetails.removeAll(Collections.singleton(deviceDetails));
            twoFactorCommonUserSettings.setRememberMeDeviceDetails(rememberMeDeviceDetails);
            this.settings.setUserSettings(username, twoFactorCommonUserSettings);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Issue with Removing Device Details : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2faForGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2faForGroup");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String groupname = request.getParameter("groupname").trim();
                LOGGER.debug("Enabling 2FA for Group : " + groupname);
                List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
                if (!enable2FAForGroupsList.contains(groupname)) {
                    enable2FAForGroupsList.add(groupname);
                    this.performEnable2FAForGroup(groupname);
                    this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
                }
                LOGGER.debug("Successfully Enabled 2FA for Group : " + groupname);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with enabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Enable the 2FA for Groups.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void disable2faForGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForGroup");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String groupname = request.getParameter("groupname").trim();
                LOGGER.debug("Disabling 2FA for Group : " + groupname);
                List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
                if (enable2FAForGroupsList.contains(groupname)) {
                    enable2FAForGroupsList.removeAll(Collections.singleton(groupname));
                    this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
                    this.performDisable2FAForGroup(groupname, false);
                }
                LOGGER.debug("Successfully Disable 2FA for Group : " + groupname);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with disabling 2fa : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Enable the 2FA for Groups.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void changeUserManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = request.getParameter("selectedAction");
        this.settings.setUserManagementSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void enableDisable2FAForAllUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enableDisable2FAForAllUsers");
        Boolean isEnableForAllUserChecked = BooleanUtils.toBoolean((String)request.getParameter("isEnableForAllUserChecked"));
        if (BooleanUtils.toBoolean((Boolean)isEnableForAllUserChecked)) {
            this.enable2FAForAllGroups(request, response, false);
            this.enable2FAForAllUser(request, response);
        } else {
            this.disable2FAForAllGroups(request, response, false);
            this.disable2FAForAllUser(request, response);
        }
    }

    private void disable2FAForAllGroups(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        block7: {
            LOGGER.debug("Calling disable2FAForAllGroups");
            String referer = request.getHeader("referer");
            LOGGER.debug("Referer : " + referer);
            if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
                try {
                    List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
                    LOGGER.debug("Total 2FA enabled Groups : " + enable2FAGroupList.size());
                    for (int i = enable2FAGroupList.size() - 1; i >= 0; --i) {
                        String groupname = enable2FAGroupList.get(i);
                        LOGGER.debug("Disabling 2FA for Group :" + groupname);
                        this.performDisable2FAForGroup(groupname, true);
                    }
                    this.settings.setEnable2FAForGroupsList(new ArrayList<String>());
                    LOGGER.debug("Successfully Disable 2FA for All Groups");
                    if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                        this.sendSuccessFullResponse("Success", response);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Issue with disabling 2FA : " + e);
                    if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                        this.sendErrorResponse("Error", response);
                        break block7;
                    }
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl());
                }
            } else {
                LOGGER.error("You don't have an access to Enable the 2FA for Groups.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    private void enable2FAForAllGroups(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        block7: {
            LOGGER.debug("Calling enable2FAForAllGroups");
            String referer = request.getHeader("referer");
            LOGGER.debug("Referer : " + referer);
            if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
                try {
                    EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
                    List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
                    LOGGER.debug("Query for Group : " + query);
                    Iterable groupsFromSystem = this.crowdService.search((Query)query);
                    for (Group group : groupsFromSystem) {
                        if (enable2FAGroupList.contains(group.getName())) continue;
                        enable2FAGroupList.add(group.getName());
                        this.performEnable2FAForGroup(group.getName());
                    }
                    this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
                    LOGGER.debug("Successfully Enabled 2FA for All Groups");
                    if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                        this.sendSuccessFullResponse("Success", response);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Issue with enabling 2FA : " + e);
                    if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                        this.sendErrorResponse("Error", response);
                        break block7;
                    }
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl());
                }
            } else {
                LOGGER.error("You don't have an access to Enable the 2FA for Groups.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    private void reset2faForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2faForSelectedUsers");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedUser;
                for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                    this.performReset2FAForUser(username);
                }
                LOGGER.debug("Successfully Reset 2FA for Selected Users");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with resetting 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Reset the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void disable2faForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSelectedUsers");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedUser;
                for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                    this.performDisable2FAForUser(username);
                }
                LOGGER.debug("Successfully Disabled 2FA for Selected Users");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Disabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Disable the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void enable2FAForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedUsers");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        Integer count = this.settings.getEnable2FAForUsersList().size();
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedUser;
                for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                    if (count >= 25) continue;
                    this.performEnable2FAForUser(username);
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                LOGGER.debug("Successfully Enabled 2FA for Selected Users");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Enabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Enable the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void enable2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForAllUser");
        Integer count = this.settings.getEnable2FAForUsersList().size();
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                LOGGER.debug("Query for User : " + query);
                Iterable usersFromSystem = this.crowdService.search((Query)query);
                List<String> enabled2FAUserList = this.settings.getEnable2FAForUsersList();
                for (User user : usersFromSystem) {
                    if (!enabled2FAUserList.contains(user.getName()) && count < 25) {
                        LOGGER.debug("Enabling 2FA for :-" + user.getName());
                        this.performEnable2FAForUser(user.getName());
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                        continue;
                    }
                    LOGGER.debug("Enabled Users Exceeded.");
                    this.sendErrorResponse("Exceeded", response);
                }
                this.settings.setEnable2FAForAllUsers(Boolean.TRUE);
                LOGGER.debug("Successfully Enabled 2FA for All Users");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Enabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Enable the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void disable2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2FAForAllUser");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                List<String> enabled2FAUserList = this.settings.getEnable2FAForUsersList();
                LOGGER.debug("Total 2FA Enabled User Count : " + enabled2FAUserList.size());
                for (int i = enabled2FAUserList.size() - 1; i >= 0; --i) {
                    String username = enabled2FAUserList.get(i);
                    this.performDisable2FAForUser(username);
                }
                this.settings.setEnable2FAForAllUsers(Boolean.FALSE);
                LOGGER.debug("Successfully Disabled 2FA for All Users");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Disabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Disable the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void reset2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2FAForAllUser");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                List<String> configured2FAUsers = this.settings.getListOf2FAConfiguredUsers();
                LOGGER.debug("Total 2FA Enabled User Count : " + configured2FAUsers.size());
                for (int i = configured2FAUsers.size() - 1; i >= 0; --i) {
                    String username = configured2FAUsers.get(i);
                    LOGGER.debug("Resetting 2FA for User :" + username);
                    this.performReset2FAForUser(username);
                }
                LOGGER.debug("Successfully Reset 2FA for All Users");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Resetting 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Reset the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void reset2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block5: {
            LOGGER.debug("Calling reset2FAForUser");
            String referer = request.getHeader("referer");
            LOGGER.debug("Referer : " + referer);
            if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
                try {
                    String username = request.getParameter("username").trim();
                    if (BooleanUtils.toBoolean((Boolean)this.performReset2FAForUser(username))) {
                        LOGGER.debug("Successfully Reset 2FA for Username : " + username);
                        this.sendSuccessFullResponse("Success", response);
                        break block5;
                    }
                    LOGGER.debug("Issue with resetting 2fa for username : " + username);
                    this.sendErrorResponse("Error", response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Issue with Resetting 2FA : " + e);
                    this.sendErrorResponse("Error", response);
                }
            } else {
                LOGGER.error("You don't have an access to Enable the 2FA for user.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    private void enable2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block7: {
            LOGGER.debug("Calling enable2FAForUser");
            String referer = request.getHeader("referer");
            LOGGER.debug("Referer : " + referer);
            Integer enabledUsersListSize = this.settings.getEnable2FAForUsersList().size();
            LOGGER.debug("Enabled Users List Size :" + enabledUsersListSize);
            if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
                try {
                    if (enabledUsersListSize < 25) {
                        String username = request.getParameter("username").trim();
                        LOGGER.debug("Enabling 2FA for Username : " + username);
                        if (BooleanUtils.toBoolean((Boolean)this.performEnable2FAForUser(username))) {
                            LOGGER.debug("Successfully Enabled 2FA for Username : " + username);
                            this.sendSuccessFullResponse("Success", response);
                        } else {
                            LOGGER.debug("Issue with enabling 2fa for username : " + username);
                            this.sendErrorResponse("Error", response);
                        }
                        break block7;
                    }
                    LOGGER.debug("Enabled Users Exceeded.");
                    this.sendErrorResponse("Exceeded", response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Issue with enabling 2fa : " + e);
                    this.sendErrorResponse("Error", response);
                }
            } else {
                LOGGER.error("You don't have an access to Enable the 2FA for user.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    private void disable2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block5: {
            LOGGER.debug("Calling disable2FAForUser");
            String referer = request.getHeader("referer");
            LOGGER.debug("Referer : " + referer);
            if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
                try {
                    String username = request.getParameter("username").trim();
                    LOGGER.debug("Disabling 2FA for Username : " + username);
                    if (BooleanUtils.toBoolean((Boolean)this.performDisable2FAForUser(username))) {
                        LOGGER.debug("Successfully Disabled 2FA for Username : " + username);
                        this.sendSuccessFullResponse("Success", response);
                        break block5;
                    }
                    LOGGER.debug("Issue with disabling 2fa for username : " + username);
                    this.sendErrorResponse("Error", response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("Issue with disabling 2fa : " + e);
                    this.sendErrorResponse("Error", response);
                }
            } else {
                LOGGER.error("You don't have an access to Disable the 2FA for user.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    private void resetOtpOverEmail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetOtpOverEmail");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                HttpSession session = request.getSession(true);
                session.removeAttribute("otp_code");
                session.removeAttribute("otp_expiry_time");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting OTP Over Email for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("OtpOverEmail"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"OtpOverEmail")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset OTP Over Email for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Resetting OTP Over Email : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void resetSecurityQuestion(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetSecurityQuestion");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting Security Question for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("SecurityQuestion"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                twoFactorUserClass.setSecurityQuestionAnswer(new HashMap<String, String>());
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"SecurityQuestion")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset Security Question for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Resetting Security Question : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void resetGoogleAuthenticator(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling resetGoogleAuthenticator");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting Mobile Authenticator for : " + username);
                HttpSession session = req.getSession();
                String secret = MoTwoFactorUtility.generateKey();
                session.setAttribute("2fa_secret", (Object)secret);
                String qrcode = MoTwoFactorUtility.generateQrCode(secret, username, this.settings.getAppLabel("Crowd"));
                session.setAttribute("2fa_qrcode", (Object)qrcode);
                String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
                twoFactorUserClass.setUserSalt(userSpecific_salt_key);
                String userSalt = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getUserSalt(), (CharSequence)"");
                String secretWithSalt = "";
                if (StringUtils.isNotBlank((CharSequence)userSalt)) {
                    secretWithSalt = secret + userSalt;
                    String encryptedString = MoTwoFactorUtility.encryptString(secretWithSalt, this.settings.getEncryptionKey());
                    LOGGER.debug("Encrypted String " + encryptedString);
                    secret = encryptedString;
                }
                twoFactorUserClass.setTotpSecret(secret);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("GoogleAuthenticator"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"GoogleAuthenticator")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset Mobile Authenticator for : " + username);
                this.sendSuccessFullResponse("Success", resp);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Resetting Google Authenticator : " + e);
                this.sendErrorResponse("Error", resp);
            }
        } else {
            resp.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            LOGGER.debug("result::" + result);
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
        LOGGER.debug("Response submitted");
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    private Boolean performReset2FAForUser(String username) {
        String status;
        LOGGER.debug("Calling performReset2FAForUser for User : " + username);
        List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
        if (configuredUser.contains(username)) {
            configuredUser.removeAll(Collections.singleton(username));
            status = "SUCCESS";
        } else {
            status = "ERROR";
        }
        this.settings.setListOf2FAConfiguredUsers(configuredUser);
        if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)status)) {
            this.settings.setUserSettings(username, new MoTwoFactorCommonUserSettings());
        }
        return Boolean.TRUE;
    }

    private Boolean performDisable2FAForUser(String username) {
        try {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (enable2FAForUsersList.contains(username)) {
                LOGGER.debug("Disabling 2FA for User : " + username);
                enable2FAForUsersList.removeAll(Collections.singleton(username));
                this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                disable2FAForUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Issue with disabling 2fa : " + e);
            return Boolean.FALSE;
        }
    }

    private Boolean performEnable2FAForUser(String username) {
        try {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                LOGGER.debug("Enabling 2FA for User : " + username);
                enable2FAForUsersList.add(username);
                this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                disable2FAForUsersList.removeAll(Collections.singleton(username));
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Issue with enabling 2fa : " + e);
            return Boolean.FALSE;
        }
    }

    private Boolean performEnable2FAForGroup(String groupname) {
        LOGGER.debug("Calling performEnable2FAForGroup for Group : " + groupname);
        List<String> usersFromGroup = this.pluginHandler.getAllUsersInGroup(groupname);
        for (String username : usersFromGroup) {
            this.performEnable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private Boolean performDisable2FAForGroup(String groupname, Boolean disableForAll) {
        LOGGER.debug("Calling performDisable2FAForGroup for Group : " + groupname);
        List<String> usersFromGroup = this.pluginHandler.getAllUsersInGroup(groupname);
        Boolean shouldDisable2FAforUser = Boolean.TRUE;
        for (String username : usersFromGroup) {
            shouldDisable2FAforUser = Boolean.TRUE;
            if (BooleanUtils.toBoolean((Boolean)disableForAll)) {
                this.performDisable2FAForUser(username);
                continue;
            }
            List<String> groupListOfUser = this.pluginHandler.getAllGroupsOfUser(groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (groupListOfUser.size() < enable2FAForGroupsList.size()) {
                for (String groupnameOfUser : groupListOfUser) {
                    if (!enable2FAForGroupsList.contains(groupnameOfUser)) continue;
                    shouldDisable2FAforUser = Boolean.FALSE;
                    break;
                }
            } else {
                for (String enableGroupName : enable2FAForGroupsList) {
                    if (!groupListOfUser.contains(enableGroupName)) continue;
                    shouldDisable2FAforUser = Boolean.FALSE;
                    break;
                }
            }
            if (!BooleanUtils.toBoolean((Boolean)shouldDisable2FAforUser)) continue;
            this.performDisable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private void disable2faForSelectedGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSelectedGroups");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedGroup;
                List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
                for (String groupname : selectedGroup = request.getParameterValues("selectedGroups")) {
                    if (!enable2FAGroupList.contains(groupname)) continue;
                    enable2FAGroupList.removeAll(Collections.singleton(groupname));
                    this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
                    this.performDisable2FAForGroup(groupname, false);
                }
                this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
                LOGGER.debug("Successfully Disabled 2FA for Selected Groups");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Disabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Disable the 2FA for groups.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void enable2FAForSelectedGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedGroups");
        String referer = request.getHeader("referer");
        LOGGER.debug("Referer : " + referer);
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") || this.pluginHandler.isSystemAdmin().booleanValue()) {
            try {
                String[] selectedGroup;
                List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
                for (String groupname : selectedGroup = request.getParameterValues("selectedGroups")) {
                    if (enable2FAGroupList.contains(groupname)) continue;
                    this.performEnable2FAForGroup(groupname);
                    enable2FAGroupList.add(groupname);
                }
                this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
                LOGGER.error("Successfully Enabled 2FA for Selected Groups");
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Issue with Enabling 2FA : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to Enable the 2FA for Groups.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void adminPresent(HttpServletRequest request, HttpServletResponse response) {
        List<Object> usernameList = new ArrayList();
        String searchFilter = request.getParameter("searchFilter");
        String searchKeyword = request.getParameter("usernameSearchKeywordUrl");
        if (StringUtils.isNotBlank((CharSequence)searchKeyword)) {
            this.usernameSearchKeyword = searchKeyword.trim();
        }
        this.totalEnabledUserList = this.settings.getEnable2FAForUsersList();
        this.userSearchFilter = "EnabledUsers";
        if (StringUtils.equalsIgnoreCase((CharSequence)this.userSearchFilter, (CharSequence)"EnabledUsers")) {
            usernameList = this.pluginHandler.getFromList(this.totalEnabledUserList, this.usernameSearchKeyword, 100);
            Collections.sort(usernameList);
            LOGGER.debug("usernameList::" + usernameList);
        }
        try {
            JsonObject data = new JsonObject();
            JsonArray resultArray = new JsonArray();
            for (String string : usernameList) {
                UserProfile userProfile = this.userManager.getUserProfile(string);
                if (!this.userManager.isAdmin(userProfile.getUserKey())) continue;
                LOGGER.debug("Admin::" + string);
                data.addProperty("result", Boolean.TRUE);
                resultArray.add(data);
                this.sendSuccessFullResponse(resultArray.toString(), response);
                return;
            }
            data.addProperty("result", Boolean.FALSE);
            resultArray.add(data);
            this.sendErrorResponse(resultArray.toString(), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

