/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorCrowdfreePluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAccessDenied
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAccessDenied.class);
    private static final String ACCESSDENIED_VM_PATH = "/templates/com/miniorange/twofactor/crowdfree/accessdenied.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdfreePluginSettings pluginSettings;

    public MoTwoFactorAccessDenied(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorAccessDenied doGet called");
        String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request);
        List<String> blacklistIpAddresses = this.settings.getBlacklistIpAddresses();
        Boolean isBlacklistIp = this.pluginHandler.isInStoredIpAddress(currentIpAddress, blacklistIpAddresses);
        if (BooleanUtils.toBoolean((Boolean)isBlacklistIp)) {
            HashMap context = new HashMap();
            String template = this.pluginSettings.getBlocklistIpTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(ACCESSDENIED_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdfreePluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

