/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.eventlistener;

import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorUserEvent {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorUserEvent.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;

    public MoTwoFactorUserEvent(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent userCreatedEvent) {
        LOGGER.debug("User Created : " + userCreatedEvent.getUser().getName());
        String username = userCreatedEvent.getUser().getName();
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnable2FAForAllUsers())) {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                enable2FAForUsersList.add(username);
            }
            this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
        } else {
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!disable2FAForUsersList.contains(username)) {
                disable2FAForUsersList.add(username);
            }
            this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
        }
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent groupMembershipCreatedEvent) {
        LOGGER.debug("Group Membership Created : " + groupMembershipCreatedEvent.getEntityName());
        String username = groupMembershipCreatedEvent.getEntityName();
        String groupName = groupMembershipCreatedEvent.getGroupName();
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        if (!this.settings.getEnable2FAForUsersList().contains(username) && enable2FAForGroupsList.contains(groupName)) {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            enable2FAForUsersList.add(username);
            this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
        }
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent groupMembershipDeletedEvent) {
        LOGGER.debug("Group Membership Deleted : " + groupMembershipDeletedEvent.getEntityName());
        String username = groupMembershipDeletedEvent.getEntityName();
        String groupName = groupMembershipDeletedEvent.getGroupName();
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        List<String> enable2FAUsersList = this.settings.getEnable2FAForUsersList();
        if (enable2FAUsersList.contains(username) && enable2FAForGroupsList.contains(groupName)) {
            List<String> usersGroups = this.pluginConfiguration.getUsersGroup(username);
            Boolean shouldEnable = Boolean.FALSE;
            for (String group : usersGroups) {
                if (!enable2FAForGroupsList.contains(group) || StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)group)) continue;
                shouldEnable = Boolean.TRUE;
                break;
            }
            if (!BooleanUtils.toBoolean((Boolean)shouldEnable)) {
                LOGGER.debug("Removing user from Enabled list");
                enable2FAUsersList.removeAll(Collections.singleton(username));
                this.settings.setEnable2FAForUsersList(enable2FAUsersList);
            } else {
                LOGGER.debug("User is part of other group for which 2FA is enabled");
            }
        }
    }

    @EventListener
    public void onUserDelete(UserDeletedEvent userDeletedEvent) {
        LOGGER.debug("Deleted User : " + userDeletedEvent.getUsername());
        String username = userDeletedEvent.getUsername();
        this.settings.deleteUserAction(username);
    }

    @EventListener
    public void onGroupDelete(GroupDeletedEvent groupDeletedEvent) {
        String groupName = groupDeletedEvent.getGroupName();
        LOGGER.debug("Deleting Group : " + groupName);
        this.settings.deleteGroupAction(groupName);
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

