/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorCrowdfreePluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorLookAndFeelTemplates
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorLookAndFeelTemplates.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private UserManager userManager;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCrowdfreePluginSettings twoFactorCrowdPluginSettings;
    private Boolean settingsSubmitted;
    private String xsrfToken;
    private String welcomeMessageTemplate;
    private String configureGoogleAuthenticatorTemplate;
    private String validateGoogleAuthenticatorTemplate;
    private String configureSecurityQuestionTemplate;
    private String validateSecurityQuestionTemplate;
    private String configureOtpOverEmailTemplate;
    private String validateOtpOverEmailTemplate;
    private String configureBackupCodeTemplate;
    private String validateBackupCodeTemplate;
    private String lockedUsersTemplate;
    private String contactAdminTemplate;
    private String blocklistIpTemplate;
    private HttpServletRequest request;

    public MoTwoFactorLookAndFeelTemplates(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCrowdfreePluginSettings twoFactorCrowdPluginSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.twoFactorCrowdPluginSettings = twoFactorCrowdPluginSettings;
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorTroubleshootingAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info("Configure Action doExecute called. ");
                if (BooleanUtils.toBoolean((Boolean)this.settingsSubmitted)) {
                    this.pluginHandler.save2FATemplateSettings(this.welcomeMessageTemplate, this.configureGoogleAuthenticatorTemplate, this.validateGoogleAuthenticatorTemplate, this.configureSecurityQuestionTemplate, this.validateSecurityQuestionTemplate, this.configureOtpOverEmailTemplate, this.validateOtpOverEmailTemplate, this.configureBackupCodeTemplate, this.validateBackupCodeTemplate, this.lockedUsersTemplate, this.blocklistIpTemplate);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings Updated");
                }
                this.initializeConfig();
                return "success";
            }
            catch (PluginException e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        this.welcomeMessageTemplate = this.twoFactorCrowdPluginSettings.getWelcomeMessageTemplate();
        this.configureGoogleAuthenticatorTemplate = this.twoFactorCrowdPluginSettings.getConfigureGoogleAuthenticatorTemplate();
        this.validateGoogleAuthenticatorTemplate = this.twoFactorCrowdPluginSettings.getValidateGoogleAuthenticatorTemplate();
        this.configureSecurityQuestionTemplate = this.twoFactorCrowdPluginSettings.getConfigureSecurityQuestionTemplate();
        this.validateSecurityQuestionTemplate = this.twoFactorCrowdPluginSettings.getValidateSecurityQuestionTemplate();
        this.configureOtpOverEmailTemplate = this.twoFactorCrowdPluginSettings.getConfigureOtpOverEmailTemplate();
        this.validateOtpOverEmailTemplate = this.twoFactorCrowdPluginSettings.getValidateOtpOverEmailTemplate();
        this.configureBackupCodeTemplate = this.twoFactorCrowdPluginSettings.getConfigureBackupCodeTemplate();
        this.validateBackupCodeTemplate = this.twoFactorCrowdPluginSettings.getValidateBackupCodeTemplate();
        this.lockedUsersTemplate = this.twoFactorCrowdPluginSettings.getLockedUserTemplate();
        this.contactAdminTemplate = this.twoFactorCrowdPluginSettings.getContactAdminTemplate();
        this.blocklistIpTemplate = this.twoFactorCrowdPluginSettings.getBlocklistIpTemplate();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public MoTwoFactorCrowdfreePluginSettings getTwoFactorCrowdPluginSettings() {
        return this.twoFactorCrowdPluginSettings;
    }

    public void setTwoFactorCrowdPluginSettings(MoTwoFactorCrowdfreePluginSettings twoFactorCrowdPluginSettings) {
        this.twoFactorCrowdPluginSettings = twoFactorCrowdPluginSettings;
    }

    public Boolean getSettingsSubmitted() {
        return this.settingsSubmitted;
    }

    public void setSettingsSubmitted(Boolean settingsSubmitted) {
        this.settingsSubmitted = settingsSubmitted;
    }

    public String getWelcomeMessageTemplate() {
        return this.welcomeMessageTemplate;
    }

    public void setWelcomeMessageTemplate(String welcomeMessageTemplate) {
        this.welcomeMessageTemplate = welcomeMessageTemplate;
    }

    public String getConfigureGoogleAuthenticatorTemplate() {
        return this.configureGoogleAuthenticatorTemplate;
    }

    public void setConfigureGoogleAuthenticatorTemplate(String configureGoogleAuthenticatorTemplate) {
        this.configureGoogleAuthenticatorTemplate = configureGoogleAuthenticatorTemplate;
    }

    public String getValidateGoogleAuthenticatorTemplate() {
        return this.validateGoogleAuthenticatorTemplate;
    }

    public void setValidateGoogleAuthenticatorTemplate(String validateGoogleAuthenticatorTemplate) {
        this.validateGoogleAuthenticatorTemplate = validateGoogleAuthenticatorTemplate;
    }

    public String getConfigureSecurityQuestionTemplate() {
        return this.configureSecurityQuestionTemplate;
    }

    public void setConfigureSecurityQuestionTemplate(String configureSecurityQuestionTemplate) {
        this.configureSecurityQuestionTemplate = configureSecurityQuestionTemplate;
    }

    public String getValidateSecurityQuestionTemplate() {
        return this.validateSecurityQuestionTemplate;
    }

    public void setValidateSecurityQuestionTemplate(String validateSecurityQuestionTemplate) {
        this.validateSecurityQuestionTemplate = validateSecurityQuestionTemplate;
    }

    public String getConfigureOtpOverEmailTemplate() {
        return this.configureOtpOverEmailTemplate;
    }

    public void setConfigureOtpOverEmailTemplate(String configureOtpOverEmailTemplate) {
        this.configureOtpOverEmailTemplate = configureOtpOverEmailTemplate;
    }

    public String getValidateOtpOverEmailTemplate() {
        return this.validateOtpOverEmailTemplate;
    }

    public void setValidateOtpOverEmailTemplate(String validateOtpOverEmailTemplate) {
        this.validateOtpOverEmailTemplate = validateOtpOverEmailTemplate;
    }

    public String getConfigureBackupCodeTemplate() {
        return this.configureBackupCodeTemplate;
    }

    public void setConfigureBackupCodeTemplate(String configureBackupCodeTemplate) {
        this.configureBackupCodeTemplate = configureBackupCodeTemplate;
    }

    public String getValidateBackupCodeTemplate() {
        return this.validateBackupCodeTemplate;
    }

    public void setValidateBackupCodeTemplate(String validateBackupCodeTemplate) {
        this.validateBackupCodeTemplate = validateBackupCodeTemplate;
    }

    public String getLockedUsersTemplate() {
        return this.lockedUsersTemplate;
    }

    public void setLockedUsersTemplate(String lockedUsersTemplate) {
        this.lockedUsersTemplate = lockedUsersTemplate;
    }

    public String getContactAdminTemplate() {
        return this.contactAdminTemplate;
    }

    public void setContactAdminTemplate(String contactAdminTemplate) {
        this.contactAdminTemplate = contactAdminTemplate;
    }

    public String getBlocklistIpTemplate() {
        return this.blocklistIpTemplate;
    }

    public void setBlocklistIpTemplate(String blocklistIpTemplate) {
        this.blocklistIpTemplate = blocklistIpTemplate;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

