/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorAdvancedSettings
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAdvancedSettings.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private Boolean settingsSubmitted;
    private String xsrfToken;
    private Boolean enableRememberMeDevice;
    private String rememberMeDeviceDuration;
    private Boolean enableBruteForceProtection;
    private String bruteForceNumberOfAttempts;
    private String bruteForceTimeInterval;
    private String bruteForceCustomTimeInterval;
    private String bruteForceCustomTimeDuration;
    private String appLabel;
    private Boolean showSupportedAppPopup;
    private String emailTemplate;
    private String otpValidityDuration;
    private String otpLength;
    private Boolean smtpConfigured;
    private HttpServletRequest request;

    public MoTwoFactorAdvancedSettings(UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
    }

    public Boolean doValidate() {
        int number;
        LOGGER.debug("Configure Action doValidate");
        Boolean hasError = Boolean.FALSE;
        try {
            if (BooleanUtils.toBoolean((Boolean)this.enableRememberMeDevice)) {
                number = Integer.parseInt(this.rememberMeDeviceDuration);
                LOGGER.debug("number : " + number);
                if (number > 365 || number < 1) {
                    this.addActionError("The expiry time must be between 1 and 365.");
                    hasError = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid Expiry Time. Expiry Time should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            if (BooleanUtils.toBoolean((Boolean)this.enableBruteForceProtection) && ((number = Integer.parseInt(this.bruteForceNumberOfAttempts)) > 10 || number < 1)) {
                this.addActionError("Invalid Number of Login attempts Entered. The Login Attempt must be between 1 and 10.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid Number of Login attempts. Number of Login attempts should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            if (BooleanUtils.toBoolean((Boolean)this.enableBruteForceProtection)) {
                if (!this.getBruteForceTimeIntervalArray().contains(this.bruteForceTimeInterval)) {
                    this.addActionError("Please select valid Time Interval");
                    hasError = Boolean.TRUE;
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"custom", (CharSequence)this.bruteForceTimeInterval)) {
                    if (!this.getBruteForceCustomTimeIntervalArray().contains(this.bruteForceCustomTimeInterval)) {
                        this.addActionError("Please select valid Time Custom Interval");
                        hasError = Boolean.TRUE;
                    } else {
                        int number2 = Integer.parseInt(this.bruteForceCustomTimeDuration);
                        if (number2 < 1) {
                            this.addActionError("The Custom Locking Expiry Time should be greater than equal to 1.");
                            hasError = Boolean.TRUE;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid Locking Expiry Time. Locking Expiry Time should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            int number3 = Integer.parseInt(this.otpLength);
            if (number3 > 8 || number3 < 4) {
                this.addActionError("Invalid OTP Length. The OTP Length must be between 4 to 8.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid OTP Length. OTP Length should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            int number4 = Integer.parseInt(this.otpValidityDuration);
            if (number4 > 10 || number4 < 1) {
                this.addActionError("Invalid OTP Validity Duration. The OTP Validity Duration must be between 1 and 10.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.addActionError("Please enter valid OTP Validity Duration. OTP Validity Duration date should be in number format.");
            hasError = Boolean.TRUE;
        }
        return hasError;
    }

    public String execute() throws Exception {
        LOGGER.debug("MoTwoFactorUserDetailsAction doExecute called");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (BooleanUtils.toBoolean((Boolean)this.settingsSubmitted) && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
                    this.pluginHandler.saveAdvanced2FASettings(this.enableBruteForceProtection, this.bruteForceNumberOfAttempts, this.bruteForceTimeInterval, this.bruteForceCustomTimeInterval, this.bruteForceCustomTimeDuration, this.enableRememberMeDevice, this.rememberMeDeviceDuration, this.appLabel, this.showSupportedAppPopup, this.emailTemplate, this.otpLength, this.otpValidityDuration);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings Updated");
                }
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "input";
            }
            this.initializeConfig();
            return "success";
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        LOGGER.debug("inside initializeConfig...");
        this.appLabel = this.settings.getAppLabel("Crowd");
        this.enableRememberMeDevice = this.settings.getEnableRememberMeDevice();
        this.rememberMeDeviceDuration = this.settings.getRememberMeDeviceDuration().toString();
        this.enableBruteForceProtection = this.settings.getEnableBruteForceProtection();
        this.bruteForceNumberOfAttempts = this.settings.getBruteForceNumberOfAttempts().toString();
        this.bruteForceTimeInterval = this.settings.getBruteForceTimeInterval();
        this.bruteForceCustomTimeInterval = this.settings.getBruteForceCustomTimeInterval();
        this.bruteForceCustomTimeDuration = this.settings.getBruteForceCustomTimeDuration().toString();
        this.showSupportedAppPopup = this.settings.getShowSupportedAppPopup();
        this.emailTemplate = this.settings.getEmailTemplate();
        this.otpValidityDuration = this.settings.getOtpValidityDuration().toString();
        this.otpLength = this.settings.getOtpLength().toString();
        this.smtpConfigured = this.pluginHandler.isSmtpConfigured();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private List<String> getBruteForceTimeIntervalArray() {
        ArrayList<String> bruteForceTimeIntervalArray = new ArrayList<String>();
        bruteForceTimeIntervalArray.add("15 minutes");
        bruteForceTimeIntervalArray.add("30 minutes");
        bruteForceTimeIntervalArray.add("1 hour");
        bruteForceTimeIntervalArray.add("5 hours");
        bruteForceTimeIntervalArray.add("1 day");
        bruteForceTimeIntervalArray.add("7 days");
        bruteForceTimeIntervalArray.add("custom");
        return bruteForceTimeIntervalArray;
    }

    private List<String> getBruteForceCustomTimeIntervalArray() {
        ArrayList<String> bruteForceCustomTimeIntervalArray = new ArrayList<String>();
        bruteForceCustomTimeIntervalArray.add("minutes");
        bruteForceCustomTimeIntervalArray.add("hours");
        bruteForceCustomTimeIntervalArray.add("days");
        return bruteForceCustomTimeIntervalArray;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public Boolean getSettingsSubmitted() {
        return this.settingsSubmitted;
    }

    public void setSettingsSubmitted(Boolean settingsSubmitted) {
        this.settingsSubmitted = settingsSubmitted;
    }

    public String getAppLabel() {
        return this.appLabel;
    }

    public void setAppLabel(String appLabel) {
        this.appLabel = appLabel;
    }

    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    public String getOtpValidityDuration() {
        return this.otpValidityDuration;
    }

    public void setOtpValidityDuration(String otpValidityDuration) {
        this.otpValidityDuration = otpValidityDuration;
    }

    public String getOtpLength() {
        return this.otpLength;
    }

    public void setOtpLength(String otpLength) {
        this.otpLength = otpLength;
    }

    public Boolean getSmtpConfigured() {
        return this.smtpConfigured;
    }

    public void setSmtpConfigured(Boolean smtpConfigured) {
        this.smtpConfigured = smtpConfigured;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getEnableRememberMeDevice() {
        return this.enableRememberMeDevice;
    }

    public void setEnableRememberMeDevice(Boolean enableRememberMeDevice) {
        this.enableRememberMeDevice = enableRememberMeDevice;
    }

    public String getRememberMeDeviceDuration() {
        return this.rememberMeDeviceDuration;
    }

    public void setRememberMeDeviceDuration(String rememberMeDeviceDuration) {
        this.rememberMeDeviceDuration = rememberMeDeviceDuration;
    }

    public Boolean getEnableBruteForceProtection() {
        return this.enableBruteForceProtection;
    }

    public void setEnableBruteForceProtection(Boolean enableBruteForceProtection) {
        this.enableBruteForceProtection = enableBruteForceProtection;
    }

    public String getBruteForceNumberOfAttempts() {
        return this.bruteForceNumberOfAttempts;
    }

    public void setBruteForceNumberOfAttempts(String bruteForceNumberOfAttempts) {
        this.bruteForceNumberOfAttempts = bruteForceNumberOfAttempts;
    }

    public String getBruteForceTimeInterval() {
        return this.bruteForceTimeInterval;
    }

    public void setBruteForceTimeInterval(String bruteForceTimeInterval) {
        this.bruteForceTimeInterval = bruteForceTimeInterval;
    }

    public String getBruteForceCustomTimeInterval() {
        return this.bruteForceCustomTimeInterval;
    }

    public void setBruteForceCustomTimeInterval(String bruteForceCustomTimeInterval) {
        this.bruteForceCustomTimeInterval = bruteForceCustomTimeInterval;
    }

    public String getBruteForceCustomTimeDuration() {
        return this.bruteForceCustomTimeDuration;
    }

    public void setBruteForceCustomTimeDuration(String bruteForceCustomTimeDuration) {
        this.bruteForceCustomTimeDuration = bruteForceCustomTimeDuration;
    }

    public Boolean getShowSupportedAppPopup() {
        return this.showSupportedAppPopup;
    }

    public void setShowSupportedAppPopup(Boolean showSupportedAppPopup) {
        this.showSupportedAppPopup = showSupportedAppPopup;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

