/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorAdaptiveAuthenticationAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAdaptiveAuthenticationAction.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Boolean whiteListIpForm;
    private Boolean blackListIpForm;
    private String ipAddress;
    private Boolean whiteListIpFormSubmitted;
    private String whiteListIpSearchKeyword;
    private List<String> whiteListIpList;
    private List<String> currentPageWhiteListIpList;
    private Map<String, String> currentPageWhiteListIpMap;
    private Boolean blackListIpFormSubmitted;
    private String blackListIpSearchKeyword;
    private List<String> blackListIpList;
    private List<String> currentPageBlackListIpList;
    private Map<String, String> currentPageBlackListIpMap;
    private String ipManagementSelectedAction;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private Integer numberOfRecordsPerPage;
    private List<String> numberOfPagesList;
    private HttpServletRequest request;

    public MoTwoFactorAdaptiveAuthenticationAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    private Boolean validateIpAddress(String ipAddress) {
        try {
            if (StringUtils.isBlank((CharSequence)ipAddress)) {
                return Boolean.FALSE;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)(ipAddress = ipAddress.trim()), (CharSequence)".") || StringUtils.endsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)".")) {
                return Boolean.FALSE;
            }
            String[] parts = ipAddress.split("\\.");
            if (parts.length < 2 || parts.length > 4) {
                return Boolean.FALSE;
            }
            for (String part : parts) {
                int i = Integer.parseInt(part);
                if (i >= 0 && i <= 255 && part.length() <= 3) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public String execute() throws Exception {
        LOGGER.debug("MoTwoFactorUserDetailsAction doExecute called");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                String startIndexAsString = "";
                String endIndexAsString = "";
                if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getIpManagementSelectedAction(), (CharSequence)"WhitelistIpAction")) {
                    Object searchKeyword;
                    if (StringUtils.isNotBlank((CharSequence)this.ipAddress)) {
                        if (BooleanUtils.toBoolean((Boolean)this.validateIpAddress(this.ipAddress))) {
                            this.pluginHandler.saveWhitelistIpAddress(this.ipAddress);
                            this.ipAddress = "";
                            LOGGER.info("Successfully Added Whitelist IP Address");
                            this.addActionMessage("Successfully added Whitelist IP address.");
                        } else {
                            LOGGER.error("Invalid IP Address added");
                            this.addActionError("Invalid IP Address. Please add the valid one.");
                        }
                        this.whiteListIpSearchKeyword = "";
                        startIndexAsString = "";
                        endIndexAsString = "";
                    } else {
                        if (StringUtils.isBlank((CharSequence)this.whiteListIpSearchKeyword)) {
                            this.whiteListIpSearchKeyword = "";
                        }
                        if (BooleanUtils.toBoolean((Boolean)this.whiteListIpFormSubmitted)) {
                            startIndexAsString = "";
                            endIndexAsString = "";
                        } else {
                            searchKeyword = this.request.getParameter("whiteListIpSearchKeywordUrl");
                            if (searchKeyword != null) {
                                this.whiteListIpSearchKeyword = searchKeyword.trim();
                            }
                            startIndexAsString = this.request.getParameter("startIndex");
                            endIndexAsString = this.request.getParameter("endIndex");
                        }
                    }
                    this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                        this.selectedPage = 1;
                        this.startIndex = 1;
                        this.endIndex = this.numberOfRecordsPerPage;
                    } else {
                        this.startIndex = Integer.parseInt(startIndexAsString);
                        this.endIndex = Integer.parseInt(endIndexAsString);
                        this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    }
                    LOGGER.info("Searching for Whitelist IP using " + this.whiteListIpSearchKeyword);
                    this.whiteListIpList = this.pluginHandler.getStoredIpAddresses(this.settings.getWhitelistIpAddresses(), this.whiteListIpSearchKeyword.trim(), 100);
                    this.currentPageWhiteListIpList = this.pluginHandler.getSelectedDetailsForPagination(this.whiteListIpList, (Integer)(this.startIndex - 1), (Integer)(this.endIndex - 1));
                    this.currentPageWhiteListIpMap = this.pluginHandler.getValidIpAddressToDisplay(this.currentPageWhiteListIpList);
                    this.numberOfPages = this.whiteListIpList.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (this.whiteListIpList.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                        searchKeyword = this;
                        Integer n = ((MoTwoFactorAdaptiveAuthenticationAction)((Object)searchKeyword)).numberOfPages;
                        Integer n2 = ((MoTwoFactorAdaptiveAuthenticationAction)((Object)searchKeyword)).numberOfPages = Integer.valueOf(((MoTwoFactorAdaptiveAuthenticationAction)((Object)searchKeyword)).numberOfPages + 1);
                    }
                } else {
                    if (BooleanUtils.toBoolean((Boolean)this.blackListIpFormSubmitted)) {
                        Boolean hasError = Boolean.FALSE;
                        if (StringUtils.isNotBlank((CharSequence)this.ipAddress)) {
                            if (BooleanUtils.toBoolean((Boolean)this.validateIpAddress(this.ipAddress))) {
                                this.pluginHandler.saveBlacklistIpAddress(this.ipAddress);
                                this.ipAddress = "";
                                hasError = Boolean.FALSE;
                            } else {
                                hasError = Boolean.TRUE;
                                LOGGER.error("Invalid IP Address added");
                                this.addActionError("Invalid IP Address. Please add the valid one.");
                            }
                        }
                        if (!hasError.booleanValue()) {
                            LOGGER.info("Successfully save configuration");
                            this.addActionMessage("Blacklist Settings Updated");
                        }
                        this.blackListIpSearchKeyword = "";
                        startIndexAsString = "";
                        endIndexAsString = "";
                    } else {
                        if (StringUtils.isBlank((CharSequence)this.blackListIpSearchKeyword)) {
                            this.blackListIpSearchKeyword = "";
                        }
                        if (BooleanUtils.toBoolean((Boolean)this.blackListIpFormSubmitted)) {
                            startIndexAsString = "";
                            endIndexAsString = "";
                        } else {
                            String searchKeyword = this.request.getParameter("blackListIpSearchKeywordUrl");
                            if (searchKeyword != null) {
                                this.blackListIpSearchKeyword = searchKeyword.trim();
                            }
                            startIndexAsString = this.request.getParameter("startIndex");
                            endIndexAsString = this.request.getParameter("endIndex");
                        }
                    }
                    this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                        this.selectedPage = 1;
                        this.startIndex = 1;
                        this.endIndex = this.numberOfRecordsPerPage;
                    } else {
                        this.startIndex = Integer.parseInt(startIndexAsString);
                        this.endIndex = Integer.parseInt(endIndexAsString);
                        this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    }
                    LOGGER.info("Searching for Blacklist IP using " + this.blackListIpSearchKeyword);
                    this.blackListIpList = this.pluginHandler.getStoredIpAddresses(this.settings.getBlacklistIpAddresses(), this.blackListIpSearchKeyword.trim(), 100);
                    this.currentPageBlackListIpList = this.pluginHandler.getSelectedDetailsForPagination(this.blackListIpList, (Integer)(this.startIndex - 1), (Integer)(this.endIndex - 1));
                    this.currentPageBlackListIpMap = this.pluginHandler.getValidIpAddressToDisplay(this.currentPageBlackListIpList);
                    this.numberOfPages = this.blackListIpList.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (this.blackListIpList.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                        MoTwoFactorAdaptiveAuthenticationAction moTwoFactorAdaptiveAuthenticationAction = this;
                        Integer n = moTwoFactorAdaptiveAuthenticationAction.numberOfPages;
                        Integer n3 = moTwoFactorAdaptiveAuthenticationAction.numberOfPages = Integer.valueOf(moTwoFactorAdaptiveAuthenticationAction.numberOfPages + 1);
                    }
                }
                this.initializeAdaptiveAuthentication();
                return "success";
            }
            catch (MoTwoFactorCommonPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeAdaptiveAuthentication() {
        LOGGER.debug("inside initializeAdaptiveAuthentication...");
        this.ipManagementSelectedAction = this.settings.getIpManagementSelectedAction();
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public Boolean getWhiteListIpForm() {
        return this.whiteListIpForm;
    }

    public void setWhiteListIpForm(Boolean whiteListIpForm) {
        this.whiteListIpForm = whiteListIpForm;
    }

    public Boolean getBlackListIpForm() {
        return this.blackListIpForm;
    }

    public void setBlackListIpForm(Boolean blackListIpForm) {
        this.blackListIpForm = blackListIpForm;
    }

    public Boolean getWhiteListIpFormSubmitted() {
        return this.whiteListIpFormSubmitted;
    }

    public void setWhiteListIpFormSubmitted(Boolean whiteListIpFormSubmitted) {
        this.whiteListIpFormSubmitted = whiteListIpFormSubmitted;
    }

    public String getWhiteListIpSearchKeyword() {
        return this.whiteListIpSearchKeyword;
    }

    public void setWhiteListIpSearchKeyword(String whiteListIpSearchKeyword) {
        this.whiteListIpSearchKeyword = whiteListIpSearchKeyword;
    }

    public List<String> getWhiteListIpList() {
        return this.whiteListIpList;
    }

    public void setWhiteListIpList(List<String> whiteListIpList) {
        this.whiteListIpList = whiteListIpList;
    }

    public List<String> getCurrentPageWhiteListIpList() {
        return this.currentPageWhiteListIpList;
    }

    public void setCurrentPageWhiteListIpList(List<String> currentPageWhiteListIpList) {
        this.currentPageWhiteListIpList = currentPageWhiteListIpList;
    }

    public Boolean getBlackListIpFormSubmitted() {
        return this.blackListIpFormSubmitted;
    }

    public void setBlackListIpFormSubmitted(Boolean blackListIpFormSubmitted) {
        this.blackListIpFormSubmitted = blackListIpFormSubmitted;
    }

    public String getBlackListIpSearchKeyword() {
        return this.blackListIpSearchKeyword;
    }

    public void setBlackListIpSearchKeyword(String blackListIpSearchKeyword) {
        this.blackListIpSearchKeyword = blackListIpSearchKeyword;
    }

    public List<String> getBlackListIpList() {
        return this.blackListIpList;
    }

    public void setBlackListIpList(List<String> blackListIpList) {
        this.blackListIpList = blackListIpList;
    }

    public List<String> getCurrentPageBlackListIpList() {
        return this.currentPageBlackListIpList;
    }

    public void setCurrentPageBlackListIpList(List<String> currentPageBlackListIpList) {
        this.currentPageBlackListIpList = currentPageBlackListIpList;
    }

    public String getIpManagementSelectedAction() {
        return this.ipManagementSelectedAction;
    }

    public void setIpManagementSelectedAction(String ipManagementSelectedAction) {
        this.ipManagementSelectedAction = ipManagementSelectedAction;
    }

    public String getIpAddress() {
        return "";
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    public Map<String, String> getCurrentPageWhiteListIpMap() {
        return this.currentPageWhiteListIpMap;
    }

    public void setCurrentPageWhiteListIpMap(Map<String, String> currentPageWhiteListIpMap) {
        this.currentPageWhiteListIpMap = currentPageWhiteListIpMap;
    }

    public Map<String, String> getCurrentPageBlackListIpMap() {
        return this.currentPageBlackListIpMap;
    }

    public void setCurrentPageBlackListIpMap(Map<String, String> currentPageBlackListIpMap) {
        this.currentPageBlackListIpMap = currentPageBlackListIpMap;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

