/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.mail.MailConfigurationService;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorCrowdfreePluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowdfree.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorPluginHandler {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorPluginHandler.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private CrowdService crowdService;
    private UserManager userManager;
    private MailConfigurationService mailConfigurationService;
    private MoTwoFactorCrowdfreePluginSettings pluginSettings;

    public MoTwoFactorPluginHandler(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, CrowdService crowdService, MailConfigurationService mailConfigurationService, MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.mailConfigurationService = mailConfigurationService;
        this.pluginSettings = pluginSettings;
    }

    public void save2FASettings(Boolean enableTwoFactor, Boolean enableBackupMethod, List<String> backupMethodForUser, List<String> twoFactorMethodForUserList, Boolean allowToReconfigureMethod, Boolean enableEnforceCurrentMethod, String primaryMethodForUser, Boolean showAllConfiguredMethodsDirectly, String appLabel) {
        LOGGER.debug("Saving Two Factor Settings: enableTwoFactor " + enableTwoFactor + ", enableBackupMethod : " + enableBackupMethod + ", backupMethodForUser : " + backupMethodForUser + ", twoFactorMethodForUserList : " + twoFactorMethodForUserList + ", allowToReconfigureMethod : " + allowToReconfigureMethod + ", enableEnforceCurrentMethod : " + enableEnforceCurrentMethod + ", primaryMethodForUser : " + primaryMethodForUser + ", showAllConfiguredMethodsDirectly : " + showAllConfiguredMethodsDirectly + ", appLabel : " + appLabel);
        this.settings.setEnableTwoFactor(enableTwoFactor);
        this.settings.setEnableBackupMethod(enableBackupMethod);
        this.settings.setBackupMethodForUserList(backupMethodForUser);
        this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
        this.settings.setAllowToReconfigureConfigured2faMethod(allowToReconfigureMethod);
        this.settings.setEnableEnforce2faMethodForUser(enableEnforceCurrentMethod);
        this.settings.setAppLabel(appLabel, "Crowd");
        if (BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod)) {
            this.settings.setPrimary2faMethodForUser(primaryMethodForUser);
        }
        this.settings.setShowAllConfiguredMethodToUser(showAllConfiguredMethodsDirectly);
    }

    public void saveAdvanced2FASettings(Boolean enableBruteForceProtection, String bruteForceNumberOfAttempts, String bruteForceTimeInterval, String bruteForceCustomTimeInterval, String bruteForceCustomTimeDuration, Boolean enableRememberMeDevice, String rememberMeDeviceDuration, String appLabel, Boolean showSupportedAppPopup, String emailTemplate, String otpLength, String otpValidityDuration) {
        LOGGER.debug("Saving Advanced Two Factor Settings : , appLabel : " + appLabel + ", showSupportedAppPopup : " + showSupportedAppPopup + ", enableRememberMeDevice : " + enableRememberMeDevice + ", rememberMeDeviceDuration : " + rememberMeDeviceDuration + ", enableBruteForceProtection : " + enableBruteForceProtection + ", bruteForceNumberOfAttempts : " + bruteForceNumberOfAttempts + ", bruteForceTimeInterval : " + bruteForceTimeInterval + ", bruteForceCustomTimeInterval : " + bruteForceCustomTimeInterval + ", bruteForceCustomTimeDuration : " + bruteForceCustomTimeDuration + ", emailTemplate : " + emailTemplate + ", otpLength : " + otpLength + ", otpValidityDuration : " + otpValidityDuration);
        this.settings.setAppLabel(appLabel, "Crowd");
        this.settings.setEnableRememberMeDevice(enableRememberMeDevice);
        if (BooleanUtils.toBoolean((Boolean)enableRememberMeDevice)) {
            this.settings.setRememberMeDeviceDuration(Integer.parseInt(rememberMeDeviceDuration));
        }
        this.settings.setEnableBruteForceProtection(enableBruteForceProtection);
        if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection)) {
            this.settings.setBruteForceNumberOfAttempts(Integer.parseInt(bruteForceNumberOfAttempts));
            this.settings.setBruteForceTimeInterval(bruteForceTimeInterval);
            this.settings.setBruteForceCustomTimeInterval(bruteForceCustomTimeInterval);
            this.settings.setBruteForceCustomTimeDuration(Integer.parseInt(bruteForceCustomTimeDuration));
        }
        this.settings.setEmailTemplate(emailTemplate);
        this.settings.setOtpLength(Integer.parseInt(otpLength));
        this.settings.setOtpValidityDuration(Integer.parseInt(otpValidityDuration));
        this.settings.setShowSupportedAppPopup(showSupportedAppPopup);
    }

    public void save2FATemplateSettings(String welcomeMessageTemplate, String configureGoogleAuthenticatorTemplate, String validateGoogleAuthenticatorTemplate, String configureSecurityQuestionTemplate, String validateSecurityQuestionTemplate, String configureOtpOverEmailTemplate, String validateOtpOverEmailTemplate, String configureBackupCodeTemplate, String validateBackupCodeTemplate, String lockedUsersTemplate, String blocklistIpTemplate) {
        LOGGER.debug("Calling save2FATemplateSettings");
        this.pluginSettings.setWelcomeMessageTemplate(welcomeMessageTemplate);
        this.pluginSettings.setConfigureGoogleAuthenticatorTemplate(configureGoogleAuthenticatorTemplate);
        this.pluginSettings.setValidateGoogleAuthenticatorTemplate(validateGoogleAuthenticatorTemplate);
        this.pluginSettings.setConfigureSecurityQuestionTemplate(configureSecurityQuestionTemplate);
        this.pluginSettings.setValidateSecurityQuestionTemplate(validateSecurityQuestionTemplate);
        this.pluginSettings.setConfigureOtpOverEmailTemplate(configureOtpOverEmailTemplate);
        this.pluginSettings.setValidateOtpOverEmailTemplate(validateOtpOverEmailTemplate);
        this.pluginSettings.setConfigureBackupCodeTemplate(configureBackupCodeTemplate);
        this.pluginSettings.setValidateBackupCodeTemplate(validateBackupCodeTemplate);
        this.pluginSettings.setLockedUserTemplate(lockedUsersTemplate);
        this.pluginSettings.setBlocklistIpTemplate(blocklistIpTemplate);
    }

    public List<String> getFromList(List<String> userList, String searchKeyword, int maxCount) {
        if (maxCount == -1) {
            return userList;
        }
        LinkedList<String> userToReturn = new LinkedList<String>();
        int currentCount = 0;
        for (String username : userList) {
            if (currentCount >= maxCount) break;
            if (!StringUtils.isBlank((CharSequence)searchKeyword) && !StringUtils.containsIgnoreCase((CharSequence)username, (CharSequence)searchKeyword)) continue;
            userToReturn.add(username);
            ++currentCount;
        }
        return userToReturn;
    }

    public List<String> getUserFromCrowdUsingUsername(String usernameSearchKeyword, int userCount) {
        ArrayList<String> availableUser = new ArrayList<String>();
        EntityQuery query = userCount == -1 ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1) : (StringUtils.isBlank((CharSequence)usernameSearchKeyword) || StringUtils.isEmpty((CharSequence)usernameSearchKeyword) ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(userCount) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)).returningAtMost(userCount));
        LOGGER.debug("Query for User : " + query);
        Iterable usersFromSystem = this.crowdService.search((Query)query);
        for (User user : usersFromSystem) {
            if (availableUser.contains(user.getName())) continue;
            availableUser.add(user.getName());
        }
        return availableUser;
    }

    public List<String> getGroupsFromCrowdUsingGroupname(String groupnameSearchKeyword, int groupCount) {
        ArrayList<String> availableGroups = new ArrayList<String>();
        EntityQuery query = groupCount == -1 ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1) : (StringUtils.isBlank((CharSequence)groupnameSearchKeyword) || StringUtils.isEmpty((CharSequence)groupnameSearchKeyword) ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(groupCount) : QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupnameSearchKeyword)).returningAtMost(groupCount));
        LOGGER.debug("Query for Group : " + query);
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (availableGroups.contains(group.getName())) continue;
            availableGroups.add(group.getName());
        }
        return availableGroups;
    }

    public List<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public List<String> getAllUsersInGroup(String groupName) {
        Iterable users = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        ArrayList<String> usersPresent = new ArrayList<String>();
        for (User userObject : users) {
            usersPresent.add(userObject.getName());
        }
        return usersPresent;
    }

    public List<String> getListOf2FAConfiguredUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorConfiguredUsers = this.settings.getListOf2FAConfiguredUsers();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorConfiguredUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getListOf2FAEnabledUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorEnable2FAForUsers = this.settings.getEnable2FAForUsersList();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorEnable2FAForUsers.contains(username) || selectedUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getListOf2FAEnabledGroupsUsingGroupname(List<String> groupnameList) {
        List<String> twoFactorEnable2FAForGroups = this.settings.getEnable2FAForGroupsList();
        ArrayList<String> selectedGroups = new ArrayList<String>();
        for (String groupName : groupnameList) {
            if (!twoFactorEnable2FAForGroups.contains(groupName) || selectedGroups.contains(groupName)) continue;
            selectedGroups.add(groupName);
        }
        return selectedGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        LOGGER.debug("Selected Details : " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public Map<String, String> getMapOfUsernameEmail(List<String> usernameList) {
        TreeMap<String, String> usernameEmailMap = new TreeMap<String, String>();
        for (String username : usernameList) {
            UserProfile userProfile = this.userManager.getUserProfile(username);
            if (userProfile == null) {
                usernameEmailMap.put(username, "");
                continue;
            }
            usernameEmailMap.put(username, userProfile.getEmail());
        }
        return usernameEmailMap;
    }

    public void redirectToValidUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling redirectToValidUrl for User");
        String currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        LOGGER.debug("currentLoggedInUser::" + currentLoggedInUser);
        if (StringUtils.isEmpty((CharSequence)currentLoggedInUser) || StringUtils.isBlank((CharSequence)currentLoggedInUser)) {
            LOGGER.debug("User is not Logged in 123");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        } else {
            LOGGER.debug("User is Logged in : " + currentLoggedInUser);
            HttpSession session = request.getSession();
            String referer = (String)session.getAttribute("Referer");
            LOGGER.debug("Current Referer : " + referer);
            if (StringUtils.isNotBlank((CharSequence)referer) && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/inlineregistration_") && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/validate_")) {
                MoTwoFactorUtility.clearCookie(request, response, "CROWD_RETURNTOCOOKIE");
                response.sendRedirect(referer);
            } else if (MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", request) != null) {
                String value = MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", request).getValue();
                LOGGER.debug("Redirect To : " + value);
                MoTwoFactorUtility.clearCookie(request, response, "CROWD_RETURNTOCOOKIE");
                response.sendRedirect(value);
            } else {
                LOGGER.debug("Redirecting to Base URL");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    public Boolean shouldConsiderMo2FA(String username, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("calling should Consider for Mo2FA");
        LOGGER.debug("username::" + username);
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isEmpty((CharSequence)username)) {
            LOGGER.debug("User is not logged in 456");
            return false;
        }
        Boolean twoFactorVerified = MoTwoFactorUtility.isTwoFactorVerified(request);
        if (BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
            LOGGER.debug("2FA already performed");
            return false;
        }
        LOGGER.debug("User is logged in & valid license found.");
        MoTwoFactorCommonUserSettings twoFactorUserSettings = this.settings.getUserSettings(username);
        if (this.check2FAIsEnabledForUser(username, twoFactorUserSettings).booleanValue()) {
            LOGGER.debug("Two Factor is enabled");
            if (this.checkIsTwofactorUrl(request)) {
                LOGGER.debug("Is twofactor URL");
                return false;
            }
            twoFactorVerified = MoTwoFactorUtility.isTwoFactorVerified(request);
            LOGGER.debug("Is Session for Verified " + twoFactorVerified);
            if (!BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
                LOGGER.debug("Is Remember me enabled : " + BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()));
                if (this.checkAndEvaluateDeviceDetails(username, request, twoFactorUserSettings).booleanValue() && BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice())) {
                    LOGGER.debug("Current Device is in Remember My device List");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return false;
                }
                String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request);
                if (BooleanUtils.toBoolean((Boolean)this.isInStoredIpAddress(currentIpAddress, this.settings.getWhitelistIpAddresses()))) {
                    LOGGER.debug("Current IP Address is in Whitelist IP Address");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return false;
                }
                LOGGER.debug("2FA not performed");
                return true;
            }
            LOGGER.debug("2FA performed");
            return false;
        }
        LOGGER.debug("Two Factor is not enabled");
        return false;
    }

    private boolean checkIsTwofactorUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String contextPath = request.getContextPath();
        LOGGER.debug("URL : " + url);
        LOGGER.debug("Context Path : " + contextPath);
        if (url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_2faenabledinfo") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_googleauthenticator") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_securityquestion") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_backupcode") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_otpoveremail") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_2famethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_backupmethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_securityquestion") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_backupcode") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otp") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_2famethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otpoveremail")) {
            LOGGER.info("Is a 2FA URL");
            return Boolean.TRUE;
        }
        LOGGER.info("Not a 2FA URL");
        return Boolean.FALSE;
    }

    private Boolean checkAndEvaluateDeviceDetails(String username, HttpServletRequest request, MoTwoFactorCommonUserSettings twoFactorUserSettings) {
        Boolean shouldIgnore2FA = Boolean.FALSE;
        if (twoFactorUserSettings.getRememberMeDeviceDetails().size() > 0) {
            String currentDeviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
            currentDeviceDetails = currentDeviceDetails.replaceAll(" ", "");
            LOGGER.debug("Current Device Details : " + currentDeviceDetails);
            String userAgent = request.getHeader("User-Agent");
            userAgent = userAgent.replaceAll(";", ":");
            userAgent = userAgent.replaceAll(" ", "");
            if (StringUtils.isNotBlank((CharSequence)currentDeviceDetails) && !StringUtils.containsIgnoreCase((CharSequence)currentDeviceDetails, (CharSequence)userAgent)) {
                LOGGER.debug("Invalid Agent Found. " + userAgent);
                currentDeviceDetails = "";
            }
            List<String> rememberMeDeviceDetails = twoFactorUserSettings.getRememberMeDeviceDetails();
            LOGGER.debug("Stored Device Details : " + rememberMeDeviceDetails);
            for (int i = rememberMeDeviceDetails.size() - 1; i >= 0; --i) {
                long storeTimeInMili;
                String storedDeviceDetails = rememberMeDeviceDetails.get(i);
                storedDeviceDetails = storedDeviceDetails.replaceAll(" ", "");
                long currentTimeInMili = System.currentTimeMillis();
                if (currentTimeInMili > (storeTimeInMili = Long.parseLong(storedDeviceDetails.split("=====")[1]))) {
                    rememberMeDeviceDetails.remove(i);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)currentDeviceDetails) || !StringUtils.containsIgnoreCase((CharSequence)storedDeviceDetails, (CharSequence)currentDeviceDetails) && !StringUtils.startsWithIgnoreCase((CharSequence)storedDeviceDetails, (CharSequence)currentDeviceDetails)) continue;
                shouldIgnore2FA = Boolean.TRUE;
            }
            twoFactorUserSettings.setRememberMeDeviceDetails(rememberMeDeviceDetails);
            LOGGER.debug("Stored Device Details After change : " + rememberMeDeviceDetails);
            this.settings.setUserSettings(username, twoFactorUserSettings);
        }
        LOGGER.debug("Is Current Device store : " + shouldIgnore2FA);
        return shouldIgnore2FA;
    }

    public String findValidUrlToRedirect(String username, HttpServletRequest request) {
        LOGGER.debug("Calling findValidUrlToRedirect");
        List<String> twoFactorConfiguredUser = this.settings.getListOf2FAConfiguredUsers();
        Boolean is2FAConfigured = twoFactorConfiguredUser.contains(username);
        String url = "";
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        List<String> configured2FAMethodsByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
        if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured)) {
            if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
                String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
                twoFactorUserClass.setUserSalt(userSpecific_salt_key);
                this.settings.setUserSettings(username, twoFactorUserClass);
            }
            List<String> backupMethod = this.settings.getBackupMethodForUserList();
            LOGGER.debug("configured2FAMethodsByUser : " + configured2FAMethodsByUser);
            LOGGER.debug("Backup Method : " + backupMethod);
            if (configured2FAMethodsByUser.size() == 0) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Showing 2FA enabled message");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2faenabledinfo");
            } else if (backupMethod.size() > 1) {
                LOGGER.debug("2FA is Not configured. Showing Backup method list");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupmethodlist");
            } else if (backupMethod.contains("SecurityQuestion")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Security Question");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
            } else if (backupMethod.contains("OtpOverEmail")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Security Question");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
            } else if (backupMethod.contains("BackupCode")) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Backup Code");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode");
            } else {
                LOGGER.debug("Backup Method is disabled after configuring primary 2FA.");
                this.settings.addTo2FAConfiguredUsersList(username);
                url = this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action");
            }
        } else if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor()) && !BooleanUtils.toBoolean((Boolean)this.settings.getEnableBackupMethod()) && twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode") && !twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator")) {
            LOGGER.debug("2FA is Enabled and Not Configured. Backup Method disabled but Configured. Contact Admin page shown");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/contact_admin");
        } else {
            LOGGER.debug("2FA is Configured.");
            LOGGER.debug("Enable force 2fa method for user : " + this.settings.getEnableEnforce2faMethodForUser());
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser())) {
                String primaryMethodForUser = this.settings.getPrimary2faMethodForUser();
                LOGGER.debug("Primary method for User : " + primaryMethodForUser);
                LOGGER.debug("Current primary User method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (!StringUtils.equalsIgnoreCase((CharSequence)primaryMethodForUser, (CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    LOGGER.debug("Configured 2fa method : " + configured2FAMethodsByUser);
                    if (configured2FAMethodsByUser.contains(primaryMethodForUser)) {
                        twoFactorUserClass.setCurrent2FAMethod(primaryMethodForUser);
                        this.settings.setUserSettings(username, twoFactorUserClass);
                    }
                }
            }
            LOGGER.debug("Should show All Configured Method TO User : " + this.settings.getShowAllConfiguredMethodToUser());
            if (BooleanUtils.toBoolean((Boolean)this.settings.getShowAllConfiguredMethodToUser()) && configured2FAMethodsByUser.size() > 1) {
                LOGGER.debug("Showing the list of configured 2FA methods");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist");
            } else {
                LOGGER.debug("Current 2FA method : " + twoFactorUserClass.getCurrent2FAMethod());
                switch (twoFactorUserClass.getCurrent2FAMethod()) {
                    case "GoogleAuthenticator": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otp");
                        break;
                    }
                    case "OtpOverEmail": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoveremail");
                        break;
                    }
                    case "SecurityQuestion": {
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_securityquestion");
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                if (configured2FAMethodsByUser.size() > 1) {
                    LOGGER.debug("Showing the list of configured 2FA methods");
                    url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist");
                } else {
                    LOGGER.debug("Single 2FA method is configured.");
                    if (configured2FAMethodsByUser.contains("GoogleAuthenticator")) {
                        LOGGER.debug("Validating Mobile Authentication");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otp");
                    } else if (configured2FAMethodsByUser.contains("OtpOverEmail")) {
                        LOGGER.debug("Validating OTP Over Email");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_otpoveremail");
                    } else if (configured2FAMethodsByUser.contains("SecurityQuestion")) {
                        LOGGER.debug("Validating Security Question");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_securityquestion");
                    } else if (configured2FAMethodsByUser.contains("BackupCode")) {
                        LOGGER.debug("Validating Backup Method");
                        url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_backupcode");
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                LOGGER.debug("Removing user from configured 2FA list.");
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                configuredUser.removeAll(Collections.singleton(username));
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
                this.settings.setUserSettings(username, twoFactorUserClass);
            }
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = this.pluginConfiguration.getBaseUrl();
        }
        return url;
    }

    public String getPrimaryConfigured2faMethod(List<String> configured2FAByUserList) {
        if (configured2FAByUserList.contains("GoogleAuthenticator")) {
            return "GoogleAuthenticator";
        }
        if (configured2FAByUserList.contains("OtpOverEmail")) {
            return "OtpOverEmail";
        }
        if (configured2FAByUserList.contains("SecurityQuestion")) {
            return "SecurityQuestion";
        }
        return "";
    }

    private Boolean check2FAIsEnabledForUser(String username, MoTwoFactorCommonUserSettings twoFactorUserSettings) {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor())) {
            List<String> excludeGroups = this.settings.getExclude2faForGroupList();
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (excludeGroups.size() > 0) {
                LOGGER.debug("Exclude Groups : " + excludeGroups);
                List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
                LOGGER.debug("User Groups : " + userGroups);
                for (String group : excludeGroups) {
                    if (!userGroups.contains(group) || !enable2FAForUsersList.contains(username)) continue;
                    LOGGER.debug("Group is present in Exclude Groups.");
                    return Boolean.FALSE;
                }
            }
            if (enable2FAForUsersList.contains(username)) {
                return Boolean.TRUE;
            }
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!disable2FAForUsersList.contains(username)) {
                if (this.settings.getEnable2FAForAllUsers().booleanValue()) {
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    return Boolean.TRUE;
                }
                List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
                List<String> groupsOfUser = this.pluginConfiguration.getUsersGroup(username);
                for (String g : enable2FAForGroupsList) {
                    if (!groupsOfUser.contains(g)) continue;
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    return Boolean.TRUE;
                }
                disable2FAForUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
        }
        return Boolean.FALSE;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public MailConfigurationService getMailConfigurationService() {
        return this.mailConfigurationService;
    }

    public void setMailConfigurationService(MailConfigurationService mailConfigurationService) {
        this.mailConfigurationService = mailConfigurationService;
    }

    public MoTwoFactorCrowdfreePluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdfreePluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public List<String> getStoredIpAddresses(List<String> storedIpAddresses, String ipSearchKeyword, int limit) {
        ArrayList<String> searchedAddress = new ArrayList();
        if (limit == -1) {
            searchedAddress = storedIpAddresses;
            Collections.sort(searchedAddress);
            return searchedAddress;
        }
        for (String ipAddress : storedIpAddresses) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)ipSearchKeyword)) continue;
            searchedAddress.add(ipAddress);
        }
        Collections.sort(searchedAddress);
        if (searchedAddress.size() > limit) {
            LinkedList<String> selectedIpAddresses = new LinkedList<String>();
            for (String ipAddress : searchedAddress) {
                selectedIpAddresses.add(ipAddress);
            }
            return selectedIpAddresses;
        }
        return searchedAddress;
    }

    public void saveWhitelistIpAddress(String ipAddress) {
        List<String> whitelistIpAddress = this.settings.getWhitelistIpAddresses();
        whitelistIpAddress.removeAll(Collections.singleton(ipAddress));
        whitelistIpAddress.removeAll(Collections.singleton(ipAddress.trim()));
        whitelistIpAddress.add(ipAddress.trim());
        this.settings.setWhitelistIpAddresses(whitelistIpAddress);
    }

    public void saveBlacklistIpAddress(String ipAddress) {
        List<String> blacklistIpAddress = this.settings.getBlacklistIpAddresses();
        blacklistIpAddress.removeAll(Collections.singleton(ipAddress));
        blacklistIpAddress.removeAll(Collections.singleton(ipAddress.trim()));
        blacklistIpAddress.add(ipAddress.trim());
        this.settings.setBlacklistIpAddresses(blacklistIpAddress);
    }

    public Map<String, String> getValidIpAddressToDisplay(List<String> ipAddresses) {
        TreeMap<String, String> ipAddressMap = new TreeMap<String, String>();
        for (String ipAddress : ipAddresses) {
            int count = ipAddress.split("\\.").length;
            String newIpAddress = count == 2 ? ipAddress.trim() + ".*.*" : (count == 3 ? ipAddress.trim() + ".*" : ipAddress);
            ipAddressMap.put(ipAddress, newIpAddress);
        }
        return ipAddressMap;
    }

    public Boolean isInStoredIpAddress(String ipAddress, List<String> storedIpAddresses) {
        Boolean isPresent = Boolean.FALSE;
        LOGGER.debug("Current IP Address : " + ipAddress);
        LOGGER.debug("Stored IP Addresses : " + storedIpAddresses);
        int ipSize = 0;
        for (String storedIpAddress : storedIpAddresses) {
            ipSize = storedIpAddress.split("\\.").length;
            if (ipSize == 4) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)storedIpAddress)) continue;
                LOGGER.debug("IP is matched with stored IP : " + storedIpAddress);
                isPresent = Boolean.TRUE;
                break;
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)(storedIpAddress + "."))) continue;
            LOGGER.debug("IP is matched with stored IP : " + storedIpAddress);
            isPresent = Boolean.TRUE;
            break;
        }
        return isPresent;
    }

    public Boolean checkBruteForceInvalidAttemptAction(HttpServletRequest request) {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableBruteForceProtection())) {
            HttpSession session = request.getSession();
            int count = 0;
            if (session.getAttribute("2fa_invalid_validation_attempt_count") != null) {
                count = (Integer)session.getAttribute("2fa_invalid_validation_attempt_count");
            }
            LOGGER.debug("Count : " + ++count);
            LOGGER.debug("Count : " + this.settings.getBruteForceNumberOfAttempts());
            if (count >= this.settings.getBruteForceNumberOfAttempts()) {
                return Boolean.FALSE;
            }
            session.setAttribute("2fa_invalid_validation_attempt_count", (Object)count);
        }
        return Boolean.TRUE;
    }

    public void performBruteForceUserLockAction(String username, HttpServletRequest request) {
        long currentTimeInMili = System.currentTimeMillis();
        LOGGER.debug("currentTimeInMili : " + currentTimeInMili);
        long newTimeInMili = this.getBruteForceLockingTimeInMili() + currentTimeInMili;
        LOGGER.debug("newTimeInMili : " + newTimeInMili);
        String currentIp = MoTwoFactorUtility.getCurrentIpAddress(request);
        LOGGER.debug("Current IP : " + currentIp);
        String fieldValue = Long.toString(newTimeInMili) + "=====" + currentIp;
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        lockedUserDetails.put(username, fieldValue);
        this.settings.setLockedUserDetails(lockedUserDetails);
    }

    private long getBruteForceLockingTimeInMili() {
        long newTimeInMili = 0L;
        long minutesMilis = 60000L;
        long hoursMilis = 3600000L;
        long daysMilis = 86400000L;
        String bruteForceTimeInterval = this.settings.getBruteForceTimeInterval();
        String bruteForceCustomTimeInterval = this.settings.getBruteForceCustomTimeInterval();
        Integer bruteForceCustomTimeDuration = this.settings.getBruteForceCustomTimeDuration();
        if (StringUtils.equalsIgnoreCase((CharSequence)bruteForceTimeInterval, (CharSequence)"custom")) {
            switch (bruteForceCustomTimeInterval) {
                case "minutes": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * minutesMilis;
                    break;
                }
                case "hours": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * hoursMilis;
                    break;
                }
                case "days": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * daysMilis;
                }
            }
        } else {
            switch (bruteForceTimeInterval) {
                case "15 minutes": {
                    newTimeInMili = 15L * minutesMilis;
                    break;
                }
                case "30 minutes": {
                    newTimeInMili = 30L * minutesMilis;
                    break;
                }
                case "1 hour": {
                    newTimeInMili = hoursMilis;
                    break;
                }
                case "5 hours": {
                    newTimeInMili = 5L * hoursMilis;
                    break;
                }
                case "1 day": {
                    newTimeInMili = daysMilis;
                    break;
                }
                case "7 days": {
                    newTimeInMili = 7L * hoursMilis;
                }
            }
        }
        return newTimeInMili;
    }

    public Boolean isUserLocked(String username) {
        long currentTimeInMili;
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        String fieldValue = lockedUserDetails.get(username);
        long storedTime = Long.parseLong(fieldValue.split("=====")[0]);
        if (storedTime > (currentTimeInMili = System.currentTimeMillis())) {
            return Boolean.TRUE;
        }
        lockedUserDetails.remove(username);
        this.settings.setLockedUserDetails(lockedUserDetails);
        return Boolean.FALSE;
    }

    public void performUserLogout(HttpServletResponse response, String username) throws IOException {
        LOGGER.debug("Performing Logout for :" + username);
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
    }

    public Map<String, String> getLockedUserDetailsUsingUsername(String usernameSearchKeyword, int userCount) {
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        if (userCount == -1) {
            return lockedUserDetails;
        }
        TreeMap<String, String> tempLockedUserDetails = new TreeMap<String, String>();
        for (String username : lockedUserDetails.keySet()) {
            if (StringUtils.containsIgnoreCase((CharSequence)username, (CharSequence)usernameSearchKeyword)) {
                tempLockedUserDetails.put(username, lockedUserDetails.get(username));
            }
            if (tempLockedUserDetails.size() < userCount) continue;
            return tempLockedUserDetails;
        }
        return tempLockedUserDetails;
    }

    public Map<String, String> getSelectedDetailsForPagination(Map<String, String> detailsList, Integer startIndex, Integer endIndex) {
        TreeMap<String, String> selectedDetailsPagination = new TreeMap<String, String>();
        int count = 0;
        for (String username : detailsList.keySet()) {
            if (++count < startIndex || count > endIndex) continue;
            String fieldValue = detailsList.get(username);
            String storedDate = new Date(Long.parseLong(fieldValue.split("=====")[0])).toString();
            storedDate = storedDate + "=====" + fieldValue.split("=====")[1];
            selectedDetailsPagination.put(username, storedDate);
        }
        LOGGER.debug("Selected Details : " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public void performLockedUserDetailsCleanUp() {
        LOGGER.debug("Performing Locked User Details Cleanup");
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        long currentTime = System.currentTimeMillis();
        ArrayList<String> detailsNeedsToBeRemoved = new ArrayList<String>();
        for (String username : lockedUserDetails.keySet()) {
            String fieldValue = lockedUserDetails.get(username);
            long storedValue = Long.parseLong(fieldValue.split("=====")[0]);
            if (currentTime <= storedValue) continue;
            detailsNeedsToBeRemoved.add(username);
        }
        LOGGER.debug("Locked User Details before remove : " + lockedUserDetails);
        for (String username : detailsNeedsToBeRemoved) {
            lockedUserDetails.remove(username);
        }
        LOGGER.debug("Locked User Details after remove : " + lockedUserDetails);
        this.settings.setLockedUserDetails(lockedUserDetails);
    }

    public Boolean shouldLockedOutUser(String username) {
        UserProfile user = this.userManager.getUserProfile(username);
        Boolean isAdmin = user != null && (this.userManager.isSystemAdmin(user.getUserKey()) || this.userManager.isAdmin(user.getUserKey()));
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            if (this.isOnlyUnlockedAdminUser(username).booleanValue()) {
                LOGGER.debug("Single Unlock Admin. Unable to unlock the user : " + username);
                return Boolean.FALSE;
            }
            LOGGER.debug("Not a single Admin Locked user: " + username);
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    private Boolean isOnlyUnlockedAdminUser(String username) {
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        int numberOfUnlockedAdminUsers = 0;
        List<String> administratorUsers = this.getAllUsersInGroup("crowd-administrators");
        Iterator<String> iterator = administratorUsers.iterator();
        while (iterator.hasNext()) {
            if (numberOfUnlockedAdminUsers > 0) {
                return Boolean.FALSE;
            }
            String adminUsername = iterator.next();
            if (StringUtils.equalsIgnoreCase((CharSequence)adminUsername, (CharSequence)username) || lockedUserDetails.get(adminUsername) != null) continue;
            ++numberOfUnlockedAdminUsers;
        }
        if (numberOfUnlockedAdminUsers == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<String> generateBackupCode() {
        ArrayList<String> backupCode = new ArrayList<String>();
        for (int i = 0; i < 15; ++i) {
            backupCode.add(this.randomAlphaNumeric(15));
        }
        return backupCode;
    }

    public List<String> encodeBackupCode(List<String> backupCodes) {
        ArrayList<String> encryptedBackupCode = new ArrayList<String>();
        for (String backupCode : backupCodes) {
            encryptedBackupCode.add(MoTwoFactorUtility.encryptString(backupCode, this.pluginConfiguration.SECRETE_KEY));
        }
        return encryptedBackupCode;
    }

    private String randomAlphaNumeric(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    private String randomNumericString(int count) {
        String ALPHA_NUMERIC_STRING = "0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public Boolean isSmtpConfigured() {
        return BooleanUtils.toBoolean((Boolean)this.mailConfigurationService.isConfigured());
    }

    public void sendOtpOnEmail(HttpServletRequest request, UserProfile crowdUser) throws Exception {
        LOGGER.debug("Calling sendOtpOnEmail.");
        String otp = this.randomNumericString(this.settings.getOtpLength());
        String subject = "OTP Verification";
        String body = this.settings.getEmailTemplate();
        body = StringUtils.replaceIgnoreCase((String)body, (String)"$$username$$", (String)crowdUser.getUsername());
        body = StringUtils.replaceIgnoreCase((String)body, (String)"$$otp$$", (String)otp);
        SMTPMailServer mailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
        Email email = new Email(crowdUser.getEmail());
        email.setFrom(mailServer.getDefaultFrom());
        email.setSubject(subject);
        email.setBody(body);
        email.setMimeType("text/html");
        mailServer.send(email);
        HttpSession httpSession = request.getSession(true);
        httpSession.setAttribute("otp_code", (Object)otp);
        long currentTimeInMili = System.currentTimeMillis();
        long newTimeInMili = (long)(this.settings.getOtpValidityDuration() * 60000) + currentTimeInMili;
        httpSession.setAttribute("otp_expiry_time", (Object)newTimeInMili);
        LOGGER.debug("Send email successfully");
    }

    public String getInlineRegistrationBackupMethodUrl(HttpServletRequest request, List<String> configuredMethodsByUser) {
        String url = "";
        List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
        ArrayList<String> remainingMethods = new ArrayList<String>();
        for (String method : enabledBackupMethodList) {
            if (configuredMethodsByUser.contains(method)) continue;
            remainingMethods.add(method);
        }
        if (remainingMethods.size() == 0) {
            LOGGER.debug("No backup method Enabled or backup method is already configured.");
            return url;
        }
        if (remainingMethods.size() > 1) {
            LOGGER.debug("Redirecting to Backup Method List");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupmethodlist");
        } else if (remainingMethods.contains("SecurityQuestion")) {
            LOGGER.debug("Redirecting to Security Question");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
        } else if (remainingMethods.contains("OtpOverEmail")) {
            LOGGER.debug("Redirecting to OTP Over Email");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
        } else if (remainingMethods.contains("BackupCode")) {
            LOGGER.debug("Redirecting to Backup Code");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode");
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            HttpSession session = request.getSession();
            session.setAttribute("considering_backup_method", (Object)true);
        }
        return url;
    }

    public Boolean isSystemAdmin() {
        Boolean isAdmin = Boolean.FALSE;
        String CurrentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        UserProfile userProfile = this.userManager.getUserProfile(CurrentLoggedInUser);
        LOGGER.debug("Current Logged In User : " + CurrentLoggedInUser);
        if (this.userManager.isAdmin(userProfile.getUserKey())) {
            isAdmin = Boolean.TRUE;
            return isAdmin;
        }
        return isAdmin;
    }
}

