/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowdfree.Migration;

import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowdfree.MoTwoFactorPluginHandler;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MoTwoFactorMigrationEvent
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorMigrationEvent.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorMigrationEvent(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.settings.getDisableUsersListMigrated().booleanValue()) {
            this.migrateDisableUsersSettings();
            this.settings.setDisableUsersListMigrated(true);
        } else {
            LOGGER.debug("Disabled users settings are already migrated");
        }
    }

    private void migrateDisableUsersSettings() {
        List<String> allUsers = this.pluginHandler.getUserFromCrowdUsingUsername("", -1);
        List<String> enabled2FAForUsersList = this.settings.getEnable2FAForUsersList();
        List disable2FAForUsersList = (List)CollectionUtils.subtract(allUsers, enabled2FAForUsersList);
        this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
        LOGGER.debug("destroy method called");
    }
}

