/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util;

import com.atlassian.user.impl.ldap.repository.DefaultLDAPRepository;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.util.ClassLoaderUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LDAPConfigurationBuilder {
    private static final Logger log = Logger.getLogger(LDAPConfigurationBuilder.class);
    public static final String CONNECTION_PROPERTIES = "connectionProperties";
    public static final String MAPPINGS_PROPERTIES = "mappingsProperties";
    public static final String CONFIGURATION_CLASS = "configurationClass";

    public static LDAPRepository getStandaloneLDAPConfiguration() {
        return LDAPConfigurationBuilder.getStandaloneLDAPConfiguration(null, null, null, null);
    }

    public static LDAPRepository getStandaloneLDAPConfiguration(Properties poolProperties) {
        return LDAPConfigurationBuilder.getStandaloneLDAPConfiguration(null, null, null, poolProperties);
    }

    public static LDAPRepository getStandaloneLDAPConfiguration(String connectionPropertiesPath, String mappingsPropertiesPath, String configurationClassName) {
        return LDAPConfigurationBuilder.getStandaloneLDAPConfiguration(connectionPropertiesPath, mappingsPropertiesPath, configurationClassName, null);
    }

    public static LDAPRepository getStandaloneLDAPConfiguration(String connectionPropertiesPath, String mappingsPropertiesPath, String configurationClassName, Properties ldapPoolProperties) {
        if (connectionPropertiesPath == null || mappingsPropertiesPath == null || configurationClassName == null) {
            connectionPropertiesPath = System.getProperty(CONNECTION_PROPERTIES, "apacheds_connection.properties");
            mappingsPropertiesPath = System.getProperty(MAPPINGS_PROPERTIES, "apacheds_mappings.properties");
            configurationClassName = System.getProperty(CONFIGURATION_CLASS, "com.atlassian.user.impl.ldap.ApacheDSTestRepository");
            System.out.println(connectionPropertiesPath);
            System.out.println(mappingsPropertiesPath);
            System.out.println(configurationClassName);
        }
        Properties connectionProperties = new Properties();
        Properties schemaMappingProperties = new Properties();
        try {
            connectionProperties.load(new FileInputStream(connectionPropertiesPath));
            schemaMappingProperties.load(new FileInputStream(mappingsPropertiesPath));
        }
        catch (IOException e) {
            try {
                connectionProperties.load(ClassLoaderUtils.getResourceAsStream(connectionPropertiesPath, LDAPConfigurationBuilder.class));
                schemaMappingProperties.load(ClassLoaderUtils.getResourceAsStream(mappingsPropertiesPath, LDAPConfigurationBuilder.class));
            }
            catch (IOException e1) {
                log.fatal((Object)"Could not load test properties files from the filesystem or the classpath!", (Throwable)e);
                System.exit(1);
            }
        }
        DefaultLDAPRepository repository = null;
        try {
            Class<?> repoClass = Class.forName(configurationClassName);
            if (ldapPoolProperties == null) {
                repository = (DefaultLDAPRepository)repoClass.newInstance();
            } else {
                Constructor<?> constr = repoClass.getConstructor(Properties.class);
                repository = (DefaultLDAPRepository)constr.newInstance(ldapPoolProperties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        repository.setConnectionProperties(connectionProperties);
        repository.setSchemaMappingsProperties(schemaMappingProperties);
        repository.setKey(connectionPropertiesPath);
        repository.setName(configurationClassName + System.currentTimeMillis());
        return repository;
    }
}

