/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import com.atlassian.user.search.page.PagerUtils;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Category;

public class LDAPMembershipToUsernamePager
extends LDAPSingleStringPager {
    public static final Category log = Category.getInstance(LDAPMembershipToUsernamePager.class);

    public LDAPMembershipToUsernamePager(LDAPRepository repository, LDAPPagerInfo info) {
        super(repository, info);
    }

    protected List preloadSearchResult(SearchResult result, List prefetched) throws EntityException {
        block6: {
            try {
                Attributes entityAttributes = result.getAttributes();
                String attributeToFind = this.returningAttributes[0];
                Attribute attr = entityAttributes.get(attributeToFind);
                String val = null;
                if (attr == null || attr.size() <= 0) break block6;
                if (attr.size() == 1) {
                    val = (String)attr.get();
                    prefetched.add(PagerUtils.extractSearchResultName(val));
                    break block6;
                }
                NamingEnumeration<?> interiorList = attr.getAll();
                while (interiorList.hasMoreElements()) {
                    val = (String)interiorList.nextElement();
                    String username = null;
                    try {
                        username = PagerUtils.extractSearchResultName(val);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error extracting username from '" + val + "'"), (Throwable)e);
                    }
                    prefetched.add(username);
                }
            }
            catch (Throwable t) {
                log.error((Object)("Error converting search result: " + result + " into list of members as usernames."), t);
            }
        }
        return prefetched;
    }
}

