/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.configuration;

import com.atlassian.user.configuration.AbstractRepositoryProcessor;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.repository.Repository;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultLDAPRepositoryProcessor
extends AbstractRepositoryProcessor {
    private LDAPGroupAdaptor groupAdaptor;
    private Properties connectionPoolProperties;
    private Properties serverProperties;
    private Properties schemaMappingsProperties = new Properties();
    public String maxSize;
    public String initSize;
    public String prefSize;
    public String debugLevel;
    public String securityProtocol;
    public String authentication;
    public String timeout;
    public String trustStore;
    public String host;
    public String securityPrincipal;
    public String securityCredential;
    public String port;
    public String baseContext;
    public String timeToLive;
    public String batchSize;
    public String initialContextFactory;
    public String baseUserNamespace;
    public String baseGroupNamespace;
    public String userNameAttribute;
    public String groupNameAttribute;
    public String userSearchFilterElement;
    public String userSearchFilter;
    public String groupSearchFilter;
    public String firstNameAttribute;
    public String surNameAttribute;
    public String emailAttribute;
    public String membershipAttribute;
    public String userSearchAllDepths;
    public String groupSearchAllDepths;
    public LDAPUserFactory userFactory;
    public LDAPGroupFactory groupFactory;
    public LDAPUserAdaptor userAdaptor;
    public String useUnqualifiedUsernameForMembershipComparison;

    public DefaultLDAPRepositoryProcessor() {
        this.serverProperties = new Properties();
        this.connectionPoolProperties = new Properties();
    }

    public RepositoryAccessor process(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        this.repository = this.configureRepository(processorData, processorClassNames);
        this.repositoryAccessor.setRepository(this.repository);
        this.userManager = this.configureUserManager(processorData, processorClassNames);
        this.repositoryAccessor.setUserManager(this.userManager);
        this.authenticator = this.configureAuthenticator(processorData, processorClassNames);
        this.repositoryAccessor.setAuthenticator(this.authenticator);
        this.userAdaptor = this.configureLDAPUserAdaptor(processorData, processorClassNames);
        this.userFactory = this.configureLDAPUserFactory(processorData, processorClassNames);
        this.groupFactory = this.configureLDAPGroupFactory(processorData, processorClassNames);
        this.groupAdaptor = this.configureLDAPGroupAdaptor(processorData, processorClassNames);
        this.groupManager = this.configureGroupManager(processorData, processorClassNames);
        this.repositoryAccessor.setGroupManager(this.groupManager);
        this.entityQueryParser = this.configureEntityQueryParser(processorData, processorClassNames);
        this.repositoryAccessor.setEntityQueryParser(this.entityQueryParser);
        String caching = (String)processorData.get("cache");
        if (caching != null && caching.equals("true")) {
            this.configureCaching(processorData);
        }
        return this.repositoryAccessor;
    }

    private LDAPUserAdaptor configureLDAPUserAdaptor(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        String userAdaptorClassName = (String)processorClassNames.get("userAdaptor");
        InitializationCheck.validateArgs(processorClassNames, new String[]{"userAdaptor"}, this);
        this.userAdaptor = (LDAPUserAdaptor)this.instantiateComponent(userAdaptorClassName);
        this.userAdaptor.init(processorData);
        processorData.put("userAdaptor", this.userAdaptor);
        return this.userAdaptor;
    }

    private LDAPGroupFactory configureLDAPGroupFactory(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        String groupFactoryClassName = (String)processorClassNames.get("groupFactory");
        InitializationCheck.validateArgs(processorClassNames, new String[]{"groupFactory"}, this);
        this.groupFactory = (LDAPGroupFactory)this.instantiateComponent(groupFactoryClassName);
        this.groupFactory.init(processorData);
        processorData.put("groupFactory", this.groupFactory);
        return this.groupFactory;
    }

    protected LDAPUserFactory configureLDAPUserFactory(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        String userFactoryClassName = (String)processorClassNames.get("userFactory");
        InitializationCheck.validateArgs(processorClassNames, new String[]{"userFactory"}, this);
        this.userFactory = (LDAPUserFactory)this.instantiateComponent(userFactoryClassName);
        this.userFactory.init(processorData);
        processorData.put("userFactory", this.userFactory);
        return this.userFactory;
    }

    public void init(HashMap processorData, HashMap processorClassNames) {
    }

    public Repository configureRepository(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        String className = (String)processorClassNames.get("class");
        InitializationCheck.validateArgs(processorClassNames, new String[]{"class"}, this);
        this.repository = (Repository)this.instantiateComponent(className);
        this.schemaMappingsProperties = this.parseSchemaMappings(processorData);
        this.connectionPoolProperties = this.parseConnectionPoolConfiguration(processorData);
        this.serverProperties = this.parseLDAPServerConfiguration(processorData);
        Properties p = System.getProperties();
        p.putAll((Map<?, ?>)this.connectionPoolProperties);
        System.setProperties(p);
        processorData.put("schemaMappings", this.schemaMappingsProperties);
        processorData.put("connectionPool", this.connectionPoolProperties);
        processorData.put("server", this.serverProperties);
        this.repository.init(processorData);
        processorData.put("repository", this.repository);
        return this.repository;
    }

    public Properties parseConnectionPoolConfiguration(HashMap processorData) {
        this.maxSize = (String)processorData.get("maxSize");
        this.validateAndStore("com.sun.jndi.ldap.connect.pool.maxsize", this.maxSize, this.connectionPoolProperties);
        this.initSize = (String)processorData.get("initSize");
        this.validateAndStore("com.sun.jndi.ldap.connect.pool.initsize", this.initSize, this.connectionPoolProperties);
        this.prefSize = (String)processorData.get("prefSize");
        if (this.prefSize != null) {
            this.connectionPoolProperties.setProperty("com.sun.jndi.ldap.connect.pool.prefsize", this.prefSize);
        }
        this.debugLevel = (String)processorData.get("debugLevel");
        this.validateAndStore("com.sun.jndi.ldap.connect.pool.debug", this.debugLevel, this.connectionPoolProperties);
        this.securityProtocol = (String)processorData.get("securityProtocol");
        this.validateAndStore("com.sun.jndi.ldap.connect.pool.protocol", this.securityProtocol, this.connectionPoolProperties);
        this.authentication = (String)processorData.get("authentication");
        this.validateAndStore("com.sun.jndi.ldap.connect.pool.authentication", this.authentication, this.connectionPoolProperties);
        this.timeout = (String)processorData.get("timeout");
        this.validateAndStore("com.sun.jndi.ldap.connect.pool.timeout", this.timeout, this.connectionPoolProperties);
        this.trustStore = (String)processorData.get("trustStore");
        this.validateAndStore("javax.net.ssl.trustStore", this.trustStore, this.connectionPoolProperties);
        boolean poolingOn = Boolean.valueOf((String)processorData.get("poolingOn"));
        this.validateAndStore("poolingOn", Boolean.toString(poolingOn), this.connectionPoolProperties);
        return this.connectionPoolProperties;
    }

    public Properties parseLDAPServerConfiguration(HashMap processorData) {
        this.host = (String)processorData.get("host");
        this.validateAndStore("host", this.host, this.serverProperties);
        this.port = (String)processorData.get("port");
        this.validateAndStore("port", this.port, this.serverProperties);
        this.securityPrincipal = (String)processorData.get("securityPrincipal");
        this.validateAndStore("securityPrincipal", this.securityPrincipal, this.serverProperties);
        this.securityCredential = (String)processorData.get("securityCredential");
        this.validateAndStore("securityCredential", this.securityCredential, this.serverProperties);
        this.securityProtocol = (String)processorData.get("securityProtocol");
        this.validateAndStore("securityProtocol", this.securityProtocol, this.serverProperties);
        this.authentication = (String)processorData.get("authentication");
        this.validateAndStore("securityAuthentication", this.authentication, this.serverProperties);
        this.baseContext = (String)processorData.get("baseContext");
        this.validateAndStore("baseContext", this.baseContext, this.serverProperties);
        this.timeToLive = (String)processorData.get("timeToLive");
        this.validateAndStore("timeToLive", this.timeToLive, this.serverProperties);
        this.batchSize = (String)processorData.get("batchSize");
        this.validateAndStore("batchSize", this.batchSize, this.serverProperties);
        this.initialContextFactory = (String)processorData.get("initialContextFactory");
        this.validateAndStore("initialContextFactory", this.initialContextFactory, this.serverProperties);
        return this.serverProperties;
    }

    public Properties parseSchemaMappings(HashMap processorData) {
        this.baseUserNamespace = (String)processorData.get("baseUserNamespace");
        this.validateAndStore("baseUserNamespace", this.baseUserNamespace, this.schemaMappingsProperties);
        this.baseGroupNamespace = (String)processorData.get("baseGroupNamespace");
        this.validateAndStore("baseGroupNamespace", this.baseGroupNamespace, this.schemaMappingsProperties);
        this.userNameAttribute = (String)processorData.get("usernameAttribute");
        this.validateAndStore("usernameAttribute", this.userNameAttribute, this.schemaMappingsProperties);
        this.groupNameAttribute = (String)processorData.get("groupnameAttribute");
        this.validateAndStore("groupnameAttribute", this.groupNameAttribute, this.schemaMappingsProperties);
        this.userSearchFilter = (String)processorData.get("userSearchFilter");
        this.validateAndStore("userSearchFilter", this.userSearchFilter, this.schemaMappingsProperties);
        this.groupSearchFilter = (String)processorData.get("groupSearchFilter");
        this.validateAndStore("groupSearchFilter", this.groupSearchFilter, this.schemaMappingsProperties);
        this.firstNameAttribute = (String)processorData.get("firstnameAttribute");
        this.validateAndStore("firstnameAttribute", this.firstNameAttribute, this.schemaMappingsProperties);
        this.surNameAttribute = (String)processorData.get("surnameAttribute");
        this.validateAndStore("surnameAttribute", this.surNameAttribute, this.schemaMappingsProperties);
        this.emailAttribute = (String)processorData.get("emailAttribute");
        this.validateAndStore("emailAttribute", this.emailAttribute, this.schemaMappingsProperties);
        this.membershipAttribute = (String)processorData.get("membershipAttribute");
        this.validateAndStore("membershipAttribute", this.membershipAttribute, this.schemaMappingsProperties);
        this.userSearchAllDepths = (String)processorData.get("userSearchAllDepths");
        this.validateAndStore("userSearchAllDepths", this.userSearchAllDepths, this.schemaMappingsProperties);
        this.groupSearchAllDepths = (String)processorData.get("groupSearchAllDepths");
        this.validateAndStore("groupSearchAllDepths", this.groupSearchAllDepths, this.schemaMappingsProperties);
        this.useUnqualifiedUsernameForMembershipComparison = (String)processorData.get("useUnqualifiedUsernameForMembershipComparison");
        this.validateAndStore("useUnqualifiedUsernameForMembershipComparison", this.useUnqualifiedUsernameForMembershipComparison, this.schemaMappingsProperties);
        return this.schemaMappingsProperties;
    }

    private void validateAndStore(String key, String value, Properties properties) {
        if (value != null) {
            properties.setProperty(key, value);
        } else {
            log.info((Object)("No " + key + " mapping specified."));
        }
    }

    protected LDAPGroupAdaptor configureLDAPGroupAdaptor(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        String groupAdaptorClassName = (String)processorClassNames.get("groupAdaptor");
        this.groupAdaptor = (LDAPGroupAdaptor)this.instantiateComponent(groupAdaptorClassName);
        this.groupAdaptor.init(processorData);
        processorData.put("groupAdaptor", this.groupAdaptor);
        return this.groupAdaptor;
    }
}

