/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.adaptor;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.adaptor.AbstractLDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPMembershipToUsernamePager;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.util.LDAPUtils;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public class LDAPStaticGroupAdaptor
extends AbstractLDAPGroupAdaptor {
    private static final Logger log = Logger.getLogger(LDAPStaticGroupAdaptor.class);
    private LDAPUserAdaptor userAdaptor;

    public LDAPStaticGroupAdaptor() {
    }

    public LDAPStaticGroupAdaptor(LDAPRepository repository, LDAPGroupFactory groupFactory) {
        super(repository, groupFactory);
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        this.groupFactory = (LDAPGroupFactory)args.get("groupFactory");
        this.userAdaptor = (LDAPUserAdaptor)args.get("userAdaptor");
        InitializationCheck.validateArgs(args, new String[]{"repository", "groupFactory", "userAdaptor", "userFactory"}, this);
    }

    public Pager getGroups(User user) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntriesViaMembership(user);
        if (info == null) {
            return new DefaultPager();
        }
        return new LDAPEntityPager(this.repository, this.groupFactory, info);
    }

    public Pager findMembers(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.repository.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.repository, info);
    }

    public Pager findMemberNames(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.repository.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.repository, info);
    }

    public boolean hasStaticGroups() {
        return true;
    }

    public boolean hasMembership(Group group, User user) throws RepositoryException {
        if (!(user instanceof LDAPEntity)) {
            return false;
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")"));
        }
        Filter searchFilter = LDAPUtils.makeAndFilter((Filter)new EqualsFilter(this.repository.getGroupnameAttribute(), group.getName()), (Filter)new EqualsFilter(this.repository.getMembershipAttribute(), this.getNameForMembershipComparison(user)));
        String[] attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
        LDAPPagerInfo result = this.search(searchFilter, attributesToReturn);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")"));
        }
        return result.getNamingEnumeration().hasMoreElements();
    }

    private String getNameForMembershipComparison(User user) {
        return this.repository.useUnqualifiedUsernameForMembershipComparison() ? user.getName() : ((LDAPEntity)((Object)user)).getDistinguishedName();
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(User user) throws EntityException {
        if (!(user instanceof LDAPEntity)) {
            log.info((Object)("Membership check for a non " + LDAPEntity.class.getName()));
            return this.getGroupEntriesViaMembership(user.getName());
        }
        LDAPEntity entity = (LDAPEntity)((Object)user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")"));
        }
        EqualsFilter searchTerm = null;
        LDAPPagerInfo ldapGroupPagerInfo = null;
        try {
            String[] attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
            searchTerm = new EqualsFilter(this.repository.getMembershipAttribute(), this.getNameForMembershipComparison(user));
            ldapGroupPagerInfo = this.getGroupEntries(attributesToReturn, (Filter)searchTerm);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")"));
        }
        return ldapGroupPagerInfo;
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String username) throws EntityException {
        return this.getGroupEntriesViaMembership(username, null);
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String username, String[] attributesToReturn) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + username + ")"));
        }
        LDAPPagerInfo ldapGroupPagerInfo = null;
        try {
            if (attributesToReturn == null) {
                attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
            }
            String name = this.repository.useUnqualifiedUsernameForMembershipComparison() ? username : this.userAdaptor.getUserDN(username);
            EqualsFilter searchTerm = new EqualsFilter(this.repository.getMembershipAttribute(), name);
            ldapGroupPagerInfo = this.getGroupEntries(attributesToReturn, (Filter)searchTerm);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + username + ")"));
        }
        return ldapGroupPagerInfo;
    }
}

