/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate.properties;

import com.atlassian.user.EntityException;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.properties.HibernatePropertySetFactory;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashMap;

public class HibernateLocalUserPropertySetFactory
extends HibernatePropertySetFactory {
    public HibernateLocalUserPropertySetFactory() {
    }

    public HibernateLocalUserPropertySetFactory(UserManager userManager, HibernateRepository repository) {
        this.userManager = userManager;
        this.repository = repository;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.userManager = (UserManager)args.get("userManager");
        this.repository = (HibernateRepository)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"repository", "userManager"}, this);
    }

    protected PropertySet getPropertySet(String entityName) throws EntityException {
        PropertySet propertySet = null;
        HashMap<String, Object> args = new HashMap<String, Object>();
        DefaultHibernateUser localUser = (DefaultHibernateUser)this.userManager.getUser(entityName);
        if (localUser != null) {
            args.put("entityId", new Long(localUser.getId()));
            args.put("entityName", "LOC_" + localUser.getName());
            args.put("configurationProvider", this.repository.getHibernateConfigurationProvider());
            propertySet = this.getPropertySet(args);
        }
        return propertySet;
    }
}

