/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromResource(String fileNamePath) {
        log.debug("Reading file from location: {}", (Object)fileNamePath);
        try (InputStream inputStream = PluginUtils.class.getResourceAsStream(fileNamePath);){
            if (inputStream == null) {
                log.error("File not found at path: {}", (Object)fileNamePath);
                String string2 = "";
                return string2;
            }
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException ioException) {
            log.error("I/O error occurred while reading default public certificate from path: {}", (Object)fileNamePath, (Object)ioException);
            return "";
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        log.debug("Generating authorization headers for API call to miniOrange license server");
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        log.debug("Generated hash value: {}", (Object)hashValue);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        log.debug("Authorization headers: {}", headers);
        return headers;
    }

    public static void sendEmail(String subject, String content, String customerId, String customerEmail, String customerApiKey) {
        try {
            log.debug("Initiating email alert for customer ID: {}", (Object)customerId);
            org.json.JSONObject emailObject = new org.json.JSONObject();
            emailObject.put("customerKey", (Object)customerId);
            emailObject.put("fromEmail", (Object)"info@miniorange.com");
            emailObject.put("bccEmail", (Object)"info@miniorange.com");
            emailObject.put("fromName", (Object)"miniOrange");
            emailObject.put("toEmail", (Object)customerEmail);
            emailObject.put("toName", (Object)customerEmail);
            emailObject.put("subject", (Object)subject);
            emailObject.put("content", (Object)content);
            org.json.JSONObject jsonObject = new org.json.JSONObject();
            jsonObject.put("customerKey", (Object)customerId);
            jsonObject.put("sendEmail", true);
            jsonObject.put("email", (Object)emailObject);
            String json = jsonObject.toString();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/notify/send", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf(customerId), customerApiKey));
            log.debug("Email alert sent successfully. Response: {}", (Object)response);
        }
        catch (Exception e) {
            log.error("An error occurred while sending the email alert to customer : {}", (Object)customerEmail, (Object)e);
        }
    }

    public static Boolean isJSONString(String string) {
        try {
            new JSONObject(string);
        }
        catch (JSONException ex) {
            try {
                new com.atlassian.json.jsonorg.JSONArray(string);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static Boolean isJCEInstalled() {
        try {
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (maxAllowedKeyLength < Integer.MAX_VALUE) {
                log.debug("JCE Strength: {}", (Object)maxAllowedKeyLength);
                log.debug("JCE unlimited strength jurisdiction policy files are not installed.");
                return false;
            }
            log.debug("JCE unlimited strength jurisdiction policy files are installed.");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Algorithm not found: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static String generateRandomAlphaNumericKey(int bytes) {
        return RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
    }

    public static List<String> convertArrayToList(String[] stringArray) {
        return stringArray != null ? new ArrayList<String>(Arrays.asList(stringArray)) : new ArrayList();
    }

    public static List<String> convertJsonArrayToList(JSONArray jsonArray) throws org.json.JSONException {
        ArrayList<String> stringList = new ArrayList<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringList.add(jsonArray.getString(i));
        }
        return stringList;
    }

    public static Boolean isValidDomainMapping(String[] domains, Boolean useDomainMapping) {
        log.debug("Check if entered username email belongs to valid domain for SSO");
        int count = 0;
        if (useDomainMapping != null && useDomainMapping.booleanValue()) {
            if (domains != null && domains.length > 0) {
                for (String domain : domains) {
                    if (StringUtils.isBlank((CharSequence)domain)) {
                        return false;
                    }
                    ++count;
                }
                return domains.length == count;
            }
            return false;
        }
        return true;
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        log.debug("User Input: {}", (Object)text);
        text = Jsoup.clean(text, Safelist.basic()).replace("&amp;", "&");
        log.debug("Sanitized Input: {}", (Object)text);
        return text;
    }

    public static String getIDPButtonsTemplate(String next, String crowdBaseUrl, Map<String, String> idpMap) {
        return "<html><head><title>SAML SSO</title><meta name='decorator' content='atl.general'><style>#main.aui-page-panel {border: 1px solid #ccc; border-radius: 20px; margin: 50px auto 50px auto;min-height: 200px; overflow: auto; max-width:400px !important; } </style></head><header style='background-color: #0052cc;\n    padding: 5px 5px 5px 30px;\n    font-size: 1.3rem;\n    font-weight: bold;\n    letter-spacing: 1px;\n    font-family: \"Atlassian Sans\", Arial, sans-serif;    color: white;'>Crowd</header><body style='margin:0px' id='com-atlassian-crowd' class='theme-default login aui-layout aui-theme-default'><div id='stp-licenseStatus-banner'></div><div id='page'><div id='full-height-container'><div id='main' class=' aui-page-panel'><table id='custom_login_page' style=' width: 100%;'><tr><td style='width: 49%;vertical-align: initial;;padding: 20px;'><div id='custom-sso-login' style='border-radius: 20px;padding: 20px;border: 1px solid lightgrey;'><h2 style='font-family: sans-serif;'>Single Sign-On</h2><hr><p style='color: #5e6c84;\n    font-family: sans-serif;\n    font-size: 0.8rem;'>Login with your corporate account</p><br/> &nbsp;&nbsp;" + PluginUtils.getMultipleIDPButtons(next, crowdBaseUrl, idpMap) + "</div></td></tr></table></div></div></div></body></html>";
    }

    public static String getBackdoorForm() {
        return "<html><head><title>BackDoor Restriction Form</title><meta name='decorator' content='atl.general'><style>#main.aui-page-panel {border: 1px solid #ccc; border-radius: 20px; margin: 50px auto 50px auto;min-height: 200px; overflow: auto; max-width:400px !important; } </style></head><body id='com-atlassian-crowd' class='theme-default login aui-layout aui-theme-default'><div id='stp-licenseStatus-banner'></div><div id='page'><div id='full-height-container'><div id='main' class=' aui-page-panel'><table id='custom_login_page' style=' width: 100%;'><tr><td style='width: 49%;vertical-align: initial;;padding: 20px;'><div id='backdoor_restriction_note' class='aui-message aui-message-info'>Please submit your username to access login form</div><form id='backdoor-restriction-form' method='post' action='' name='backdoor-restriction-form' class='aui gdt'><div class='field-group'><label accesskey='u' for='login-form-email' id='usernamelabel' style='display: block;'><strong>Username</strong></label><input class='text medium-field' id='login-form-email' name='mo_username' type='text' style='height: initial;'/></div><div class='field-group'><button id='check_backdoor_access' class='aui aui-button aui-button-primary'>Submit</button></div></form><br/> &nbsp;&nbsp;</div></td></tr></table></div></div></div></body></html>";
    }

    private static String getMultipleIDPButtons(String next, String crowdBaseUrl, Map<String, String> idpMap) {
        log.debug("next parameter is :{}", (Object)next);
        StringBuilder multipleLinks = new StringBuilder();
        for (String idpId : idpMap.keySet()) {
            String authUrl = crowdBaseUrl + "/plugins/servlet/saml/auth?idp=" + idpId;
            if (StringUtils.isNotBlank((CharSequence)next)) {
                authUrl = authUrl + "&return_to=" + next;
            }
            multipleLinks.append("<a class='aui-button aui-button-primary' style='display: block; width: 250px; margin: auto; background-color: #0052cc; padding: 7px; border-radius: 4px; font-family: sans-serif; color: white; text-decoration: none; text-align: center;' href='").append(authUrl).append("'>").append(idpMap.get(idpId)).append("</a><br>");
        }
        return multipleLinks.toString();
    }
}

