/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.exception.SAMLException;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.model.SAMLResponse;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.service.PluginUserService;
import com.miniorange.sso.saml.service.SAMLAuthenticationService;
import com.miniorange.sso.saml.service.SAMLService;
import com.miniorange.sso.saml.utils.EncryptionUtils;
import com.miniorange.sso.saml.utils.PluginUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

@UnrestrictedAccess
public class SAMLLoginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SAMLLoginServlet.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigService pluginConfigService;
    private final PluginLicenseService pluginLicenseService;
    private final SAMLService samlService;
    private final PluginUserService pluginUserService;
    private final SAMLAuthenticationService samlAuthenticationService;
    private IDPConfig idpConfig;
    private final CrowdService crowdService;

    public SAMLLoginServlet(PluginSettingsService pluginSettingsService, PluginConfigService pluginConfigService, PluginLicenseService pluginLicenseService, SAMLService samlService, PluginUserService pluginUserService, SAMLAuthenticationService samlAuthenticationService, CrowdService crowdService) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigService = pluginConfigService;
        this.pluginLicenseService = pluginLicenseService;
        this.samlService = samlService;
        this.pluginUserService = pluginUserService;
        this.samlAuthenticationService = samlAuthenticationService;
        this.crowdService = crowdService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Initiating SAML login flow");
        try {
            if (!this.pluginLicenseService.isValidLicense()) {
                if (this.pluginSettingsService.isNoOfUserExceed().booleanValue() && !this.pluginLicenseService.isTrialLicense()) {
                    log.debug("License Error:User count exceeded ");
                    this.samlService.redirectToSAMLError(request, response, PluginException.PluginErrorCode.USER_COUNT_EXCEEDED.getMessage(), null, PluginException.PluginErrorCode.USER_COUNT_EXCEEDED);
                    return;
                }
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            String idpId = PluginUtils.sanitizeText(request.getParameter("idp"));
            if (StringUtils.isBlank((CharSequence)idpId)) {
                idpId = (String)this.pluginSettingsService.getIdPList().stream().findFirst().orElseThrow(() -> new SAMLException(SAMLException.SAMLErrorCode.INVALID_IDP_ID));
            }
            this.idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpId);
            if (this.idpConfig == null || StringUtils.isBlank((CharSequence)this.idpConfig.getIdpId())) {
                log.error("IDP ID '{}' not found. Cannot generate SAML Authn Request.", (Object)idpId);
                throw new SAMLException(SAMLException.SAMLErrorCode.INVALID_IDP_ID);
            }
            String returnTo = PluginUtils.sanitizeText(request.getParameter("return_to"));
            if (StringUtils.isEmpty((CharSequence)returnTo)) {
                returnTo = this.pluginSettingsService.getBaseUrl();
            }
            log.debug("Relay State URL: {}", (Object)returnTo);
            if ("displaysamlrequest".equalsIgnoreCase(returnTo)) {
                this.samlService.displaySAMLRequest(request, response, this.idpConfig);
                return;
            }
            if (!StringUtils.isBlank((CharSequence)this.pluginSettingsService.getRelayState())) {
                returnTo = this.pluginSettingsService.getRelayState();
            }
            HttpSession session = request.getSession();
            session.setAttribute("RELAY_STATE", (Object)returnTo);
            log.debug("Creating SAML Authn Request and redirecting user to IDP '{}'.", (Object)this.idpConfig.getIdpId());
            this.samlService.createAuthnRequestAndRedirect(request, response, returnTo, this.idpConfig);
        }
        catch (SAMLException e) {
            log.error("SAMLException occurred while generating SAML Authn Request: {}", (Object)e.getMessage(), (Object)e);
            this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.UNKNOWN, null);
        }
        catch (PluginException e) {
            log.error("PluginException occurred: {}", (Object)e.getMessage(), (Object)e);
            this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.UNKNOWN, null);
        }
        catch (Exception e) {
            log.error("Unexpected error occurred: {}", (Object)e.getMessage(), (Object)e);
            this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.UNKNOWN, null);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block43: {
            log.debug("Processing SAML Response from IDP");
            log.debug("SAML Authentication Servlet doPost() called...");
            if (!this.pluginLicenseService.isValidLicense()) {
                if (this.pluginSettingsService.isNoOfUserExceed().booleanValue() && !this.pluginLicenseService.isTrialLicense()) {
                    log.debug("License Error:User count exceeded ");
                    this.samlService.redirectToSAMLError(request, response, PluginException.PluginErrorCode.USER_COUNT_EXCEEDED.getMessage(), null, PluginException.PluginErrorCode.USER_COUNT_EXCEEDED);
                    return;
                }
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            SAMLResponse samlResponse = null;
            User ssoUser = null;
            UserTemplate userTemplate = null;
            String relayState = request.getParameter("RelayState");
            relayState = PluginUtils.sanitizeText(relayState);
            try {
                String cookieValue;
                String usernameByEmail;
                String idpid = request.getParameter("idp");
                if (StringUtils.isNotBlank((CharSequence)idpid) && !this.pluginSettingsService.getIdPList().contains(idpid)) {
                    log.error("No IDP Configuration found for IDP ID : " + idpid + ". Redirecting to login page");
                    throw new SAMLException(SAMLException.SAMLErrorCode.INVALID_IDP_ID);
                }
                if (StringUtils.isEmpty((CharSequence)idpid) && this.idpConfig == null) {
                    if (this.pluginSettingsService.getIdPList().size() >= 1) {
                        idpid = this.pluginSettingsService.getIdPList().get(0);
                    } else if (StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) {
                        idpid = "miniorange.saml.DEFAULT_IDP_ID";
                    } else {
                        throw new SAMLException(SAMLException.SAMLErrorCode.INVALID_IDP_ID);
                    }
                    log.debug("Constructed idpConfig obj for default IDP ");
                    this.idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpid);
                }
                if (StringUtils.isNotEmpty((CharSequence)idpid) && this.idpConfig == null) {
                    log.debug("Constructed idpConfig obj for  IDP ID :  " + idpid);
                    this.idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpid);
                }
                log.debug("IDP Config : " + this.idpConfig.toString());
                try {
                    samlResponse = this.samlService.readSAMLResponse(request, response, this.idpConfig);
                }
                catch (MoSAMLException e) {
                    if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testidpconfiguration")) {
                        this.showTestConfigurationResult(null, response, e);
                        return;
                    }
                    this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.INCORRECT_IDP_CONFIGURATION, null);
                    return;
                }
                if (StringUtils.contains((CharSequence)samlResponse.getRelayStateURL(), (CharSequence)"testidpconfiguration")) {
                    this.showTestConfigurationResult(samlResponse, response, null);
                    return;
                }
                if (StringUtils.contains((CharSequence)samlResponse.getRelayStateURL(), (CharSequence)"displaysamlresponse")) {
                    this.displaySAMLResponse(samlResponse, request, response, null);
                    return;
                }
                Object username = "";
                String email = "";
                if (samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute()).length == 1) {
                    username = samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute())[0];
                }
                if (samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute()) != null && samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute()).length == 1) {
                    email = samlResponse.getAttributes().get(this.idpConfig.getEmailAttribute())[0];
                }
                log.debug("Username '{}' and email '{} received in SAML Response    '.", username, (Object)email);
                username = this.samlService.extractSSOUsernameUsingRegex((String)username, this.idpConfig);
                if (StringUtils.isNotEmpty((CharSequence)email) && StringUtils.equalsIgnoreCase((CharSequence)this.idpConfig.getLoginUserAttribute(), (CharSequence)"email") && StringUtils.isNotEmpty((CharSequence)(usernameByEmail = this.pluginUserService.findUserByEmail(email)))) {
                    username = usernameByEmail;
                }
                if (!StringUtils.isNotBlank((CharSequence)username)) break block43;
                try {
                    if (this.idpConfig.getRegexPatternEnabled().booleanValue()) {
                        try {
                            Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)this.idpConfig.getRegexPattern()));
                            Matcher matcher = pattern.matcher((CharSequence)username);
                            if (matcher.find()) {
                                username = "";
                                if (matcher.groupCount() > 0) {
                                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                                        username = (String)username + matcher.group(i);
                                    }
                                } else {
                                    username = matcher.group();
                                }
                                log.debug("Username after appling regex: " + (String)username);
                            }
                        }
                        catch (Exception e) {
                            log.error("Can't signin regex pattern exception occured", (Throwable)e);
                            this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.USERNAME_REGEX_VALIDATION_FAILED, null);
                        }
                    }
                    log.debug("Login user account by : " + this.idpConfig.getLoginUserAttribute());
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.idpConfig.getLoginUserAttribute(), (CharSequence)"email")) {
                        log.debug("searching for existing user with email  : " + email);
                        int size = 1;
                        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)email)).returningAtMost(10);
                        log.debug("user by email search query =  " + String.valueOf(query));
                        Iterable usersByEmail = this.crowdService.search((Query)query);
                        log.debug("usersByEmail =  " + usersByEmail.toString());
                        if (usersByEmail instanceof Collection) {
                            size = ((Collection)usersByEmail).size();
                            log.debug("Number of users found : " + size);
                            if (size >= 2) {
                                log.error(" Multiple users found with email : " + email + " Unable to identify the right SSO user. Please check and delete/update duplicate users and try again.");
                                throw new SAMLException(SAMLException.SAMLErrorCode.MULTIPLE_USER_WITH_EMAIL);
                            }
                        }
                        for (User user : usersByEmail) {
                            log.debug("user : " + user.getName());
                            ssoUser = user;
                        }
                    } else {
                        log.debug("searching for existing user with username : " + (String)username);
                        ssoUser = this.pluginUserService.findApplicationSpecificUser((String)username, samlResponse.getRelayStateURL());
                    }
                    if (ssoUser != null) {
                        log.debug("SSO User found " + ssoUser.getName());
                    }
                }
                catch (Exception e) {
                    ssoUser = null;
                    log.debug("User not found");
                }
                CookieConfiguration cookieConfiguration = this.samlAuthenticationService.getCookieConfiguration();
                if (ssoUser == null) {
                    if (this.idpConfig.getRestrictUserCreation().booleanValue()) {
                        log.debug("New user creation is restricted. Redirecting to Login page");
                        this.samlService.redirectToSAMLError(request, response, PluginException.PluginErrorCode.USER_CREATION_RESTRICTED.getMessage(), null, PluginException.PluginErrorCode.USER_CREATION_RESTRICTED);
                        return;
                    }
                    userTemplate = this.pluginUserService.createUser((String)username, email, samlResponse, this.idpConfig);
                    log.debug("Creating session for user " + (String)username);
                    this.samlAuthenticationService.createUserSessionAndRedirect((String)username, request, response, samlResponse, this.idpConfig.getApplicationGroupEnrollment());
                    cookieValue = samlResponse.getNameId() + "::" + samlResponse.getSessionIndex();
                    Cookie cookie = new Cookie("SAMLCOOKIE", EncryptionUtils.encrypt(this.pluginSettingsService.getCustomerTokenKey(), cookieValue));
                    cookie.setPath("/");
                    response.addCookie(cookie);
                    Cookie samlIDPCookie = new Cookie("samlsso_idp.key", this.idpConfig.getIdpId());
                    samlIDPCookie.setPath("/");
                    response.addCookie(samlIDPCookie);
                    this.samlService.redirectToSuccessfulAuthLandingPage(request, response, relayState, cookieConfiguration.getDomain());
                    return;
                }
                if (ssoUser != null) {
                    log.debug("Updating existing User");
                    Boolean isDeactivated = ssoUser.isActive();
                    if (!isDeactivated.booleanValue()) {
                        if (!this.pluginSettingsService.getAutoActivateUser().booleanValue()) {
                            log.debug("User is deactivated. Can't create user session, redirecting to the login page");
                            this.samlService.redirectToSAMLError(request, response, PluginException.PluginErrorCode.USER_DEACTIVATED.getMessage(), null, PluginException.PluginErrorCode.USER_DEACTIVATED);
                            return;
                        }
                        this.pluginUserService.reactivateUser(ssoUser);
                    }
                    userTemplate = this.pluginUserService.updateUser(ssoUser, email, samlResponse, this.idpConfig);
                }
                if (ssoUser != null && userTemplate != null) {
                    log.debug("Athenticating user");
                    this.samlAuthenticationService.createUserSessionAndRedirect((String)username, request, response, samlResponse, this.idpConfig.getApplicationGroupEnrollment());
                    cookieValue = samlResponse.getNameId() + "::" + samlResponse.getSessionIndex();
                    Cookie cookie = new Cookie("SAMLCOOKIE", EncryptionUtils.encrypt(this.pluginSettingsService.getCustomerTokenKey(), cookieValue));
                    cookie.setPath("/");
                    response.addCookie(cookie);
                    String ssoDomain = this.pluginSettingsService.getSSODomain();
                    Cookie samlIDPCookie = new Cookie("samlsso_idp.key", this.idpConfig.getIdpId());
                    samlIDPCookie.setPath("/");
                    samlIDPCookie.setDomain(ssoDomain);
                    response.addCookie(samlIDPCookie);
                    this.samlService.redirectToSuccessfulAuthLandingPage(request, response, relayState, cookieConfiguration.getDomain());
                    return;
                }
            }
            catch (SAMLException e) {
                log.error("SAMLException occurred while validating SAML Response: {}", (Object)e.getMessage(), (Object)e);
                if (StringUtils.equalsIgnoreCase((CharSequence)relayState, (CharSequence)"testidpconfiguration")) {
                    this.samlService.displayTestConfigurationResult(this.idpConfig, null, response, e);
                    return;
                }
                this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.UNKNOWN, null);
                return;
            }
            catch (PluginException e) {
                log.error("PluginException occurred: {}", (Object)e.getMessage(), (Object)e);
                this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.UNKNOWN, e.getErrorCode());
                return;
            }
            catch (Exception e) {
                log.error("Unexpected error occurred: {}", (Object)e.getMessage(), (Object)e);
                this.samlService.redirectToSAMLError(request, response, e.getMessage(), SAMLException.SAMLErrorCode.UNKNOWN, PluginException.PluginErrorCode.UNKNOWN);
                return;
            }
        }
        log.error("An error occured login the user. Redirecting to the login page ");
        this.samlService.redirectToSAMLError(request, response, "Check user profile mapping", SAMLException.SAMLErrorCode.INCORRECT_PROFILE_MAPPING, PluginException.PluginErrorCode.UNKNOWN);
    }

    private void showTestConfigurationResult(SAMLResponse samlResponse, HttpServletResponse response, MoSAMLException e) throws IOException {
        log.debug("showTestConfigurationResult called");
        if (e == null) {
            String username = "";
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            String[] usernameArray = samlResponse.getAttributes().get(this.idpConfig.getUsernameAttribute());
            if (usernameArray != null && usernameArray.length == 1) {
                username = usernameArray[0];
            }
            htmlStart = StringUtils.isBlank((CharSequence)username) ? htmlStart.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">WARNING: Username attribute not found in the response. Users will not be able to login.</div>") : htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
            htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + username + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
            for (String key : samlResponse.getAttributes().keySet()) {
                htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                String[] values = samlResponse.getAttributes().get(key);
                for (int i = 0; i < values.length; ++i) {
                    htmlStart = i == values.length - 1 ? htmlStart.append(StringUtils.join((Object[])new String[]{values[i], "<br/>"})) : htmlStart.append(StringUtils.join((Object[])new String[]{values[i], "<hr/>"}));
                }
                htmlStart = htmlStart.append("</td></tr>");
            }
            htmlStart = htmlStart.append("</table></div>");
            htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
        } else {
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            htmlStart = htmlStart.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
            htmlStart = htmlStart.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + String.valueOf((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
        }
    }

    private void displaySAMLResponse(SAMLResponse samlResponse, HttpServletRequest request, HttpServletResponse response, MoSAMLException e) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String encodedSAMLResponse = request.getParameter("SAMLResponse");
        String xml = new String(Base64.decode(encodedSAMLResponse), "UTF-8");
        xml = this.XmlFormatter(xml);
        output.append(xml);
        xml = HtmlUtils.htmlEscape((String)xml);
        output.append("</div>");
        output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>SAML Response</div>");
        output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:1062px; margin:0px; height:350px;' id ='reqmessage' readonly>" + xml + "</textarea> ");
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
        output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
        response.setCharacterEncoding("iso-8859-1");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    public String XmlFormatter(String xml) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            Boolean keepDeclaration = xml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

